/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import cn.sh1rocu.slashblade.api.extension.EntityExtension;
import cn.sh1rocu.slashblade.api.extension.IEntityAdditionalSpawnData;
import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import mods.flammpfeil.slashblade.entity.IShootable;
import mods.flammpfeil.slashblade.entity.Projectile;
import mods.flammpfeil.slashblade.event.handler.FallHandler;
import mods.flammpfeil.slashblade.util.AttackManager;
import mods.flammpfeil.slashblade.util.EnumSetConverter;
import mods.flammpfeil.slashblade.util.KnockBacks;
import mods.flammpfeil.slashblade.util.NBTHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1675;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_7833;
import org.joml.Vector4f;

public class EntitySlashEffect
extends Projectile
implements IShootable {
    private static final class_2940<Integer> COLOR = class_2945.method_12791(EntitySlashEffect.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> FLAGS = class_2945.method_12791(EntitySlashEffect.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> RANK = class_2945.method_12791(EntitySlashEffect.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> ROTATION_OFFSET = class_2945.method_12791(EntitySlashEffect.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> ROTATION_ROLL = class_2945.method_12791(EntitySlashEffect.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> BASESIZE = class_2945.method_12791(EntitySlashEffect.class, (class_2941)class_2943.field_13320);
    private int lifetime = 10;
    private KnockBacks action = KnockBacks.cancel;
    private double damage = 1.0;
    private boolean cycleHit = false;
    private List<class_1297> alreadyHits = Lists.newArrayList();
    private class_3414 livingEntitySound = class_3417.field_14688;
    EnumSet<FlagsState> flags = EnumSet.noneOf(FlagsState.class);
    int intFlags = 0;

    public KnockBacks getKnockBack() {
        return this.action;
    }

    public void setKnockBack(KnockBacks action) {
        this.action = action;
    }

    public void setKnockBackOrdinal(int ordinal) {
        this.action = 0 <= ordinal && ordinal < KnockBacks.values().length ? KnockBacks.values()[ordinal] : KnockBacks.cancel;
    }

    public boolean doCycleHit() {
        return this.cycleHit;
    }

    public void setCycleHit(boolean cycleHit) {
        this.cycleHit = cycleHit;
    }

    protected class_3414 getHitEntitySound() {
        return this.livingEntitySound;
    }

    public EntitySlashEffect(class_1299<? extends Projectile> entityTypeIn, class_1937 worldIn) {
        super(entityTypeIn, worldIn);
        this.method_5875(true);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(COLOR, (Object)0x3333FF);
        this.field_6011.method_12784(FLAGS, (Object)0);
        this.field_6011.method_12784(RANK, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(ROTATION_OFFSET, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(ROTATION_ROLL, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(BASESIZE, (Object)Float.valueOf(1.0f));
    }

    protected void method_5652(class_2487 compound) {
        super.method_5652(compound);
        NBTHelper.getNBTCoupler(compound).put("RotationOffset", Float.valueOf(this.getRotationOffset())).put("RotationRoll", Float.valueOf(this.getRotationRoll())).put("BaseSize", Float.valueOf(this.getBaseSize())).put("Color", this.getColor()).put("Rank", Float.valueOf(this.getRank())).put("damage", this.damage).put("crit", this.getIsCritical()).put("clip", this.isNoClip()).put("Lifetime", this.getLifetime()).put("Knockback", this.getKnockBack().ordinal());
    }

    protected void method_5749(class_2487 compound) {
        super.method_5749(compound);
        NBTHelper.getNBTCoupler(compound).get("RotationOffset", this::setRotationOffset, new Float[0]).get("RotationRoll", this::setRotationRoll, new Float[0]).get("BaseSize", this::setBaseSize, new Float[0]).get("Color", this::setColor, new Integer[0]).get("Rank", this::setRank, new Float[0]).get("damage", v -> {
            this.damage = v;
        }, this.damage).get("crit", this::setIsCritical, new Boolean[0]).get("clip", this::setNoClip, new Boolean[0]).get("Lifetime", this::setLifetime, new Integer[0]).get("Knockback", this::setKnockBackOrdinal, new Integer[0]);
    }

    public class_2596<class_2602> method_18002() {
        return IEntityAdditionalSpawnData.getEntitySpawningPacket((class_1297)this);
    }

    public boolean isWave() {
        return false;
    }

    @Override
    public void method_7485(double x, double y, double z, float velocity, float inaccuracy) {
        if (!this.isWave()) {
            this.method_18800(0.0, 0.0, 0.0);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_5640(double distance) {
        double d0 = this.method_5829().method_995() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntitySlashEffect.method_5824()) * d0;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_5759(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.method_5814(x, y, z);
        this.method_5710(yaw, pitch);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_5750(double x, double y, double z) {
        this.method_18800(0.0, 0.0, 0.0);
    }

    private void setFlags(FlagsState value) {
        this.flags.add(value);
        this.refreshFlags();
    }

    private void removeFlags(FlagsState value) {
        this.flags.remove((Object)value);
        this.refreshFlags();
    }

    private void refreshFlags() {
        if (this.method_37908().method_8608()) {
            int newValue = (Integer)this.field_6011.method_12789(FLAGS);
            if (this.intFlags != newValue) {
                this.intFlags = newValue;
                this.flags = EnumSetConverter.convertToEnumSet(FlagsState.class, this.intFlags);
            }
        } else {
            int newValue = EnumSetConverter.convertToInt(this.flags);
            if (this.intFlags != newValue) {
                this.field_6011.method_12778(FLAGS, (Object)newValue);
                this.intFlags = newValue;
            }
        }
    }

    public void setIndirect(boolean value) {
        if (value) {
            this.setFlags(FlagsState.Indirect);
        } else {
            this.removeFlags(FlagsState.Indirect);
        }
    }

    public boolean getIndirect() {
        this.refreshFlags();
        return this.flags.contains((Object)FlagsState.Indirect);
    }

    public void setMute(boolean value) {
        if (value) {
            this.setFlags(FlagsState.Mute);
        } else {
            this.removeFlags(FlagsState.Mute);
        }
    }

    public boolean getMute() {
        this.refreshFlags();
        return this.flags.contains((Object)FlagsState.Mute);
    }

    public void setIsCritical(boolean value) {
        if (value) {
            this.setFlags(FlagsState.Critical);
        } else {
            this.removeFlags(FlagsState.Critical);
        }
    }

    public boolean getIsCritical() {
        this.refreshFlags();
        return this.flags.contains((Object)FlagsState.Critical);
    }

    public void setNoClip(boolean value) {
        this.field_5960 = value;
        if (value) {
            this.setFlags(FlagsState.NoClip);
        } else {
            this.removeFlags(FlagsState.NoClip);
        }
    }

    public boolean isNoClip() {
        if (!this.method_37908().method_8608()) {
            return this.field_5960;
        }
        this.refreshFlags();
        return this.flags.contains((Object)FlagsState.NoClip);
    }

    public class_3414 getSlashSound() {
        return class_3417.field_15001;
    }

    public void method_5773() {
        super.method_5773();
        if (this.field_6012 == 2) {
            if (!this.getMute()) {
                this.method_5783(this.getSlashSound(), 0.8f, 0.625f + 0.1f * this.field_5974.method_43057());
            } else {
                this.method_5783(class_3417.field_14706, 0.5f, 0.4f / (this.field_5974.method_43057() * 0.4f + 0.8f));
            }
            if (this.getIsCritical()) {
                this.method_5783(this.getHitEntitySound(), 0.2f, 0.4f + 0.25f * this.field_5974.method_43057());
            }
        }
        if (this.field_6012 % 2 == 0 || this.field_6012 < 5) {
            class_243 start = this.method_19538();
            Vector4f normal = new Vector4f(1.0f, 0.0f, 0.0f, 1.0f);
            Vector4f dir = new Vector4f(0.0f, 0.0f, 1.0f, 1.0f);
            float progress = (float)this.field_6012 / (float)this.lifetime;
            class_7833.field_40716.rotationDegrees(60.0f + this.getRotationOffset() - 200.0f * progress).transform(normal);
            class_7833.field_40718.rotationDegrees(this.getRotationRoll()).transform(normal);
            class_7833.field_40714.rotationDegrees(this.method_36455()).transform(normal);
            class_7833.field_40716.rotationDegrees(-this.method_36454()).transform(normal);
            class_7833.field_40716.rotationDegrees(60.0f + this.getRotationOffset() - 200.0f * progress).transform(dir);
            class_7833.field_40718.rotationDegrees(this.getRotationRoll()).transform(dir);
            class_7833.field_40714.rotationDegrees(this.method_36455()).transform(dir);
            class_7833.field_40716.rotationDegrees(-this.method_36454()).transform(dir);
            class_243 normal3d = new class_243((double)normal.x(), (double)normal.y(), (double)normal.z());
            class_3965 rayResult = this.method_5770().method_17742(new class_3959(start.method_1019(normal3d.method_1021(1.5)), start.method_1019(normal3d.method_1021(3.0)), class_3959.class_3960.field_17558, class_3959.class_242.field_1347, null));
            if (this.getShooter() != null && !this.getShooter().method_5721() && rayResult.method_17783() == class_239.class_240.field_1332) {
                FallHandler.spawnLandingParticle((class_1297)this, rayResult.method_17784(), normal3d, 3.0f);
            }
            if (IConcentrationRank.ConcentrationRanks.S.level < this.getRankCode().level) {
                class_243 vec3 = start.method_1019(normal3d.method_1021((double)this.getBaseSize() * 2.5));
                this.method_37908().method_8406((class_2394)class_2398.field_11205, vec3.method_10216(), vec3.method_10214(), vec3.method_10215(), (double)(dir.x() + normal.x()), (double)(dir.y() + normal.y()), (double)(dir.z() + normal.z()));
                float randScale = this.field_5974.method_43057() * 1.0f + 0.5f;
                vec3 = vec3.method_1031((double)(dir.x() * randScale), (double)(dir.y() * randScale), (double)(dir.z() * randScale));
                this.method_37908().method_8406((class_2394)class_2398.field_11205, vec3.method_10216(), vec3.method_10214(), vec3.method_10215(), (double)(dir.x() + normal.x()), (double)(dir.y() + normal.y()), (double)(dir.z() + normal.z()));
            }
        }
        if (this.getShooter() != null && this.field_6012 % 2 == 0) {
            List<class_1297> hits;
            boolean forceHit = true;
            if (!this.getIndirect() && this.getShooter() instanceof class_1309) {
                class_1309 shooter = (class_1309)this.getShooter();
                float ratio = (float)this.damage * (this.getIsCritical() ? 1.1f : 1.0f);
                hits = AttackManager.areaAttack(shooter, this.action.action, ratio, forceHit, false, true, this.alreadyHits);
            } else {
                hits = AttackManager.areaAttack(this, this.action.action, 4.0, forceHit, false, this.alreadyHits);
            }
            if (!this.doCycleHit()) {
                this.alreadyHits.addAll(hits);
            }
        }
        this.tryDespawn();
    }

    public List<class_1297> getAlreadyHits() {
        return this.alreadyHits;
    }

    protected void tryDespawn() {
        if (!this.method_37908().method_8608() && this.getLifetime() < this.field_6012) {
            this.method_5650(class_1297.class_5529.field_26999);
        }
    }

    public int getColor() {
        return (Integer)this.method_5841().method_12789(COLOR);
    }

    public void setColor(int value) {
        this.method_5841().method_12778(COLOR, (Object)value);
    }

    public float getRank() {
        return ((Float)this.method_5841().method_12789(RANK)).floatValue();
    }

    public void setRank(float value) {
        this.method_5841().method_12778(RANK, (Object)Float.valueOf(value));
    }

    public IConcentrationRank.ConcentrationRanks getRankCode() {
        return IConcentrationRank.ConcentrationRanks.getRankFromLevel(this.getRank());
    }

    public int getLifetime() {
        return Math.min(this.lifetime, 1000);
    }

    public void setLifetime(int value) {
        this.lifetime = value;
    }

    public float getRotationOffset() {
        return ((Float)this.method_5841().method_12789(ROTATION_OFFSET)).floatValue();
    }

    public void setRotationOffset(float value) {
        this.method_5841().method_12778(ROTATION_OFFSET, (Object)Float.valueOf(value));
    }

    public float getRotationRoll() {
        return ((Float)this.method_5841().method_12789(ROTATION_ROLL)).floatValue();
    }

    public void setRotationRoll(float value) {
        this.method_5841().method_12778(ROTATION_ROLL, (Object)Float.valueOf(value));
    }

    public float getBaseSize() {
        return ((Float)this.method_5841().method_12789(BASESIZE)).floatValue();
    }

    public void setBaseSize(float value) {
        this.method_5841().method_12778(BASESIZE, (Object)Float.valueOf(value));
    }

    @Override
    @Nullable
    public class_1297 getShooter() {
        return this.method_24921();
    }

    @Override
    public void setShooter(class_1297 shooter) {
        this.method_7432(shooter);
    }

    public List<class_1293> getPotionEffects() {
        List effects = class_1844.method_8066((class_2487)((EntityExtension)((Object)this)).sb$getPersistentData());
        if (effects.isEmpty()) {
            effects.add(new class_1293(class_1294.field_5899, 1, 1));
        }
        return effects;
    }

    public void setDamage(double damageIn) {
        this.damage = damageIn;
    }

    @Override
    public double getDamage() {
        return this.damage;
    }

    @Nullable
    public class_3966 getRayTrace(class_243 p_213866_1_, class_243 p_213866_2_) {
        return class_1675.method_18077((class_1937)this.method_37908(), (class_1297)this, (class_243)p_213866_1_, (class_243)p_213866_2_, (class_238)this.method_5829().method_18804(this.method_18798()).method_1014(1.0), entity -> !entity.method_7325() && entity.method_5805() && entity.method_5863() && entity != this.getShooter());
    }

    static enum FlagsState {
        Critical,
        NoClip,
        Mute,
        Indirect;

    }
}

