/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event.bladestand;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.data.builtin.SlashBladeBuiltInRegistry;
import mods.flammpfeil.slashblade.data.tag.SlashBladeItemTags;
import mods.flammpfeil.slashblade.entity.BladeStandEntity;
import mods.flammpfeil.slashblade.event.SlashBladeEvent;
import mods.flammpfeil.slashblade.event.bladestand.BladeChangeSpecialAttackEvent;
import mods.flammpfeil.slashblade.event.bladestand.BladeChangeSpecialEffectEvent;
import mods.flammpfeil.slashblade.event.bladestand.CopySpecialAttackFromBladeEvent;
import mods.flammpfeil.slashblade.event.bladestand.CopySpecialEffectFromBladeEvent;
import mods.flammpfeil.slashblade.event.bladestand.PreCopySpecialAttackFromBladeEvent;
import mods.flammpfeil.slashblade.event.bladestand.PreCopySpecialEffectFromBladeEvent;
import mods.flammpfeil.slashblade.event.bladestand.ProudSoulEnchantmentEvent;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.recipe.RequestDefinition;
import mods.flammpfeil.slashblade.recipe.SlashBladeIngredient;
import mods.flammpfeil.slashblade.registry.SlashArtsRegistry;
import mods.flammpfeil.slashblade.registry.SpecialEffectsRegistry;
import mods.flammpfeil.slashblade.registry.slashblade.SlashBladeDefinition;
import mods.flammpfeil.slashblade.registry.specialeffects.SpecialEffect;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1528;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_8103;

public class BlandStandEventHandler {
    private static final class_2960 LOWEST = SlashBlade.prefix("lowest_priority");

    public static void init() {
        SlashBladeEvent.BLADE_STAND_ATTACK.addPhaseOrdering(Event.DEFAULT_PHASE, LOWEST);
        SlashBladeEvent.BLADE_STAND_ATTACK.register(BlandStandEventHandler::eventKoseki);
        SlashBladeEvent.BLADE_STAND_ATTACK.register(BlandStandEventHandler::eventChangeSE);
        SlashBladeEvent.BLADE_STAND_ATTACK.register(BlandStandEventHandler::eventChangeSA);
        SlashBladeEvent.BLADE_STAND_ATTACK.register(BlandStandEventHandler::eventCopySE);
        SlashBladeEvent.BLADE_STAND_ATTACK.register(BlandStandEventHandler::eventCopySA);
        SlashBladeEvent.BLADE_STAND_ATTACK.register(LOWEST, BlandStandEventHandler::eventProudSoulEnchantment);
        PreCopySpecialAttackFromBladeEvent.CALLBACK.register(BlandStandEventHandler::copySAEnchantmentCheck);
        ProudSoulEnchantmentEvent.CALLBACK.register(BlandStandEventHandler::proudSoulEnchantmentProbabilityCheck);
    }

    public static void eventKoseki(SlashBladeEvent.BladeStandAttackEvent event) {
        class_2378<SlashBladeDefinition> slashBladeDefinitionRegistry = SlashBlade.getSlashBladeDefinitionRegistry(event.getBladeStand().method_37908());
        if (!slashBladeDefinitionRegistry.method_10250(SlashBladeBuiltInRegistry.KOSEKI.method_29177())) {
            return;
        }
        if (!(event.getDamageSource().method_5529() instanceof class_1528)) {
            return;
        }
        if (!event.getDamageSource().method_48789(class_8103.field_42249)) {
            return;
        }
        SlashBladeIngredient in = SlashBladeIngredient.of(RequestDefinition.Builder.newInstance().build());
        if (!in.test(event.getBlade())) {
            return;
        }
        event.getBladeStand().method_6935(Objects.requireNonNull((SlashBladeDefinition)slashBladeDefinitionRegistry.method_29107(SlashBladeBuiltInRegistry.KOSEKI)).getBlade());
    }

    public static void eventChangeSE(SlashBladeEvent.BladeStandAttackEvent event) {
        class_1297 class_12972 = event.getDamageSource().method_5529();
        if (!(class_12972 instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)class_12972;
        class_1799 stack = player.method_5998(class_1268.field_5808);
        class_1799 blade = event.getBlade();
        if (blade.method_7960()) {
            return;
        }
        if (!stack.method_31573(SlashBladeItemTags.CAN_CHANGE_SE)) {
            return;
        }
        class_1937 world = player.method_37908();
        ISlashBladeState state = event.getSlashBladeState();
        if (stack.method_7969() == null) {
            return;
        }
        class_2487 tag = stack.method_7969();
        if (tag.method_10545("SpecialEffectType")) {
            BladeStandEntity bladeStand = event.getBladeStand();
            class_2960 SEKey = new class_2960(tag.method_10558("SpecialEffectType"));
            if (!SpecialEffectsRegistry.SPECIAL_EFFECT.method_10250(SEKey)) {
                return;
            }
            if (state.hasSpecialEffect(SEKey)) {
                return;
            }
            BladeChangeSpecialEffectEvent e = new BladeChangeSpecialEffectEvent(blade, state, SEKey, event);
            if (!player.method_7337()) {
                e.setShrinkCount(1);
            }
            ((BladeChangeSpecialEffectEvent.Callback)BladeChangeSpecialEffectEvent.CALLBACK.invoker()).onChangeSpecialEffect(e);
            if (e.isCanceled()) {
                return;
            }
            if (stack.method_7947() < e.getShrinkCount()) {
                return;
            }
            state.addSpecialEffect(e.getSEKey());
            class_5819 random = player.method_6051();
            BlandStandEventHandler.spawnSucceedEffects(world, bladeStand, random);
            stack.method_7934(e.getShrinkCount());
            event.setCanceled(true);
        }
    }

    public static void eventChangeSA(SlashBladeEvent.BladeStandAttackEvent event) {
        class_1297 class_12972 = event.getDamageSource().method_5529();
        if (!(class_12972 instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)class_12972;
        class_1799 stack = player.method_5998(class_1268.field_5808);
        class_2487 tag = stack.method_7969();
        if (!stack.method_31573(SlashBladeItemTags.CAN_CHANGE_SA) || tag == null || !tag.method_10545("SpecialAttackType")) {
            return;
        }
        class_2960 SAKey = new class_2960(tag.method_10558("SpecialAttackType"));
        if (!SlashArtsRegistry.SLASH_ARTS.method_10250(SAKey)) {
            return;
        }
        class_1799 blade = event.getBlade();
        CapabilitySlashBlade.BLADESTATE.maybeGet((Object)blade).ifPresent(state -> {
            if (!SAKey.equals((Object)state.getSlashArtsKey())) {
                BladeChangeSpecialAttackEvent e = new BladeChangeSpecialAttackEvent(blade, (ISlashBladeState)state, SAKey, event);
                if (!player.method_7337()) {
                    e.setShrinkCount(1);
                }
                ((BladeChangeSpecialAttackEvent.Callback)BladeChangeSpecialAttackEvent.CALLBACK.invoker()).onChangeSpecialAttack(e);
                if (e.isCanceled()) {
                    return;
                }
                if (stack.method_7947() < e.getShrinkCount()) {
                    return;
                }
                state.setSlashArtsKey(e.getSAKey());
                class_5819 random = player.method_6051();
                BladeStandEntity bladeStand = event.getBladeStand();
                BlandStandEventHandler.spawnSucceedEffects(player.method_37908(), bladeStand, random);
                stack.method_7934(e.getShrinkCount());
            }
        });
        event.setCanceled(true);
    }

    public static void eventCopySE(SlashBladeEvent.BladeStandAttackEvent event) {
        class_1297 class_12972 = event.getDamageSource().method_5529();
        if (!(class_12972 instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)class_12972;
        class_1799 stack = player.method_5998(class_1268.field_5808);
        class_1799 blade = event.getBlade();
        if (blade.method_7960()) {
            return;
        }
        if (!stack.method_31573(SlashBladeItemTags.CAN_COPY_SE)) {
            return;
        }
        class_2487 crystalTag = stack.method_7969();
        if (crystalTag != null && crystalTag.method_10545("SpecialEffectType")) {
            return;
        }
        class_1937 world = player.method_37908();
        ISlashBladeState state = event.getSlashBladeState();
        BladeStandEntity bladeStand = event.getBladeStand();
        List<class_2960> specialEffects = state.getSpecialEffects();
        for (class_2960 se : specialEffects) {
            if (!SpecialEffectsRegistry.SPECIAL_EFFECT.method_10250(se)) continue;
            PreCopySpecialEffectFromBladeEvent pe = new PreCopySpecialEffectFromBladeEvent(blade, state, se, event, Objects.requireNonNull((SpecialEffect)SpecialEffectsRegistry.SPECIAL_EFFECT.method_10223(se)).isRemovable(), Objects.requireNonNull((SpecialEffect)SpecialEffectsRegistry.SPECIAL_EFFECT.method_10223(se)).isCopiable());
            if (!player.method_7337()) {
                pe.setShrinkCount(1);
            }
            ((PreCopySpecialEffectFromBladeEvent.Callback)PreCopySpecialEffectFromBladeEvent.CALLBACK.invoker()).onPreCopySpecialEffect(pe);
            if (pe.isCanceled()) {
                return;
            }
            if (stack.method_7947() < pe.getShrinkCount() || !pe.isCopiable()) continue;
            class_1799 orb = new class_1799((class_1935)SBItems.proudsoul_crystal);
            class_2487 tag = new class_2487();
            tag.method_10582("SpecialEffectType", se.toString());
            orb.method_7980(tag);
            stack.method_7934(pe.getShrinkCount());
            class_5819 random = player.method_6051();
            BlandStandEventHandler.spawnSucceedEffects(world, bladeStand, random);
            class_1542 itemEntity = player.method_7328(orb, true);
            if (pe.isRemovable()) {
                state.removeSpecialEffect(se);
            }
            CopySpecialEffectFromBladeEvent e = new CopySpecialEffectFromBladeEvent(pe, orb, itemEntity);
            ((CopySpecialEffectFromBladeEvent.Callback)CopySpecialEffectFromBladeEvent.CALLBACK.invoker()).onCopySpecialEffect(e);
            event.setCanceled(true);
            return;
        }
    }

    public static void eventCopySA(SlashBladeEvent.BladeStandAttackEvent event) {
        class_1297 class_12972 = event.getDamageSource().method_5529();
        if (!(class_12972 instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)class_12972;
        class_1799 stack = player.method_5998(class_1268.field_5808);
        class_1799 blade = event.getBlade();
        if (blade.method_7960()) {
            return;
        }
        if (!stack.method_31573(SlashBladeItemTags.CAN_COPY_SA) || !stack.method_7942()) {
            return;
        }
        class_1937 world = player.method_37908();
        ISlashBladeState state = event.getSlashBladeState();
        BladeStandEntity bladeStand = event.getBladeStand();
        class_2960 SA = state.getSlashArtsKey();
        if (SA != null && !SA.equals((Object)SlashArtsRegistry.SLASH_ARTS.method_10221((Object)SlashArtsRegistry.NONE))) {
            PreCopySpecialAttackFromBladeEvent pe = new PreCopySpecialAttackFromBladeEvent(blade, state, SA, event);
            if (!player.method_7337()) {
                pe.setShrinkCount(1);
            }
            ((PreCopySpecialAttackFromBladeEvent.Callback)PreCopySpecialAttackFromBladeEvent.CALLBACK.invoker()).onPreCopySpecialAttack(pe);
            if (pe.isCanceled()) {
                return;
            }
            if (stack.method_7947() < pe.getShrinkCount()) {
                return;
            }
            class_1799 orb = new class_1799((class_1935)SBItems.proudsoul_sphere);
            class_2487 tag = new class_2487();
            tag.method_10582("SpecialAttackType", state.getSlashArtsKey().toString());
            orb.method_7980(tag);
            stack.method_7934(pe.getShrinkCount());
            class_5819 random = player.method_6051();
            BlandStandEventHandler.spawnSucceedEffects(world, bladeStand, random);
            class_1542 itemEntity = player.method_7328(orb, true);
            CopySpecialAttackFromBladeEvent e = new CopySpecialAttackFromBladeEvent(pe, orb, itemEntity);
            ((CopySpecialAttackFromBladeEvent.Callback)CopySpecialAttackFromBladeEvent.CALLBACK.invoker()).onCopySpecialAttack(e);
            event.setCanceled(true);
        }
    }

    public static void eventProudSoulEnchantment(SlashBladeEvent.BladeStandAttackEvent event) {
        class_1297 class_12972 = event.getDamageSource().method_5529();
        if (!(class_12972 instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)class_12972;
        class_1799 stack = player.method_5998(class_1268.field_5808);
        class_1799 blade = event.getBlade();
        if (blade.method_7960()) {
            return;
        }
        if (!stack.method_31573(SlashBladeItemTags.PROUD_SOULS)) {
            return;
        }
        if (!stack.method_7942()) {
            return;
        }
        class_1937 world = player.method_37908();
        class_5819 random = world.method_8409();
        BladeStandEntity bladeStand = event.getBladeStand();
        Map currentBladeEnchantments = class_1890.method_8222((class_1799)blade);
        HashMap enchantments = new HashMap();
        AtomicInteger totalShrinkCount = new AtomicInteger(0);
        if (!player.method_7337()) {
            totalShrinkCount.set(1);
        }
        class_1890.method_8222((class_1799)stack).forEach((enchantment, level) -> {
            if (event.isCanceled()) {
                return;
            }
            if (!enchantment.method_8192(blade)) {
                return;
            }
            float probability = 1.0f;
            if (stack.method_31574(SBItems.proudsoul_tiny)) {
                probability = 0.25f;
            }
            if (stack.method_31574(SBItems.proudsoul)) {
                probability = 0.5f;
            }
            if (stack.method_31574(SBItems.proudsoul_ingot)) {
                probability = 0.75f;
            }
            int enchantLevel = Math.min(enchantment.method_8183(), class_1890.method_8225((class_1887)enchantment, (class_1799)blade) + 1);
            ProudSoulEnchantmentEvent e = new ProudSoulEnchantmentEvent(blade, event.getSlashBladeState(), (class_1887)enchantment, enchantLevel, false, probability, totalShrinkCount.get(), event);
            ((ProudSoulEnchantmentEvent.Callback)ProudSoulEnchantmentEvent.CALLBACK.invoker()).onProudSoulEnchantment(e);
            if (e.isCanceled()) {
                return;
            }
            totalShrinkCount.set(e.getTotalShrinkCount());
            enchantments.put(e.getEnchantment(), e.getEnchantLevel());
            if (!e.willTryNextEnchant()) {
                event.setCanceled(true);
            }
        });
        if (stack.method_7947() < totalShrinkCount.get()) {
            return;
        }
        stack.method_7934(totalShrinkCount.get());
        currentBladeEnchantments.putAll(enchantments);
        class_1890.method_8214((Map)currentBladeEnchantments, (class_1799)blade);
        if (!enchantments.isEmpty()) {
            BlandStandEventHandler.spawnSucceedEffects(world, bladeStand, random);
        }
        event.setCanceled(true);
    }

    public static void copySAEnchantmentCheck(PreCopySpecialAttackFromBladeEvent event) {
        SlashBladeEvent.BladeStandAttackEvent oriEvent = event.getOriginalEvent();
        if (oriEvent == null) {
            return;
        }
        class_1657 player = (class_1657)oriEvent.getDamageSource().method_5529();
        if (player != null) {
            class_1799 stack = player.method_5998(class_1268.field_5808);
            class_1799 blade = event.getBlade();
            Set enchantments = class_1890.method_8222((class_1799)stack).keySet();
            boolean flag = false;
            for (class_1887 e : enchantments) {
                if (class_1890.method_8225((class_1887)e, (class_1799)blade) < e.method_8183()) continue;
                flag = true;
            }
            if (!flag) {
                event.setCanceled(true);
            }
        }
    }

    public static void proudSoulEnchantmentProbabilityCheck(ProudSoulEnchantmentEvent event) {
        class_1937 world;
        class_5819 random;
        SlashBladeEvent.BladeStandAttackEvent oriEvent = event.getOriginalEvent();
        if (oriEvent == null) {
            return;
        }
        class_1657 player = (class_1657)oriEvent.getDamageSource().method_5529();
        if (player != null && (random = (world = player.method_37908()).method_8409()).method_43057() > event.getProbability()) {
            event.setCanceled(true);
        }
    }

    private static void spawnSucceedEffects(class_1937 world, BladeStandEntity bladeStand, class_5819 random) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)world;
        serverLevel.method_45445((class_1297)bladeStand, bladeStand.method_6896(), class_3417.field_14792, class_3419.field_15245, 0.5f, 0.8f);
        for (int i = 0; i < 32; ++i) {
            double zDist;
            double yDist;
            double xDist = random.method_43057() * 2.0f - 1.0f;
            if (!(xDist * xDist + (yDist = (double)(random.method_43057() * 2.0f - 1.0f)) * yDist + (zDist = (double)(random.method_43057() * 2.0f - 1.0f)) * zDist <= 1.0)) continue;
            double x = bladeStand.method_23316(xDist / 4.0);
            double y = bladeStand.method_23323(0.5 + yDist / 4.0);
            double z = bladeStand.method_23324(zDist / 4.0);
            serverLevel.method_14199((class_2394)class_2398.field_11214, x, y, z, 0, xDist, yDist + 0.2, zDist, 1.0);
        }
    }
}

