/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event.handler;

import cn.sh1rocu.slashblade.api.event.LivingFallEvent;
import cn.sh1rocu.slashblade.api.event.PlayerFlyableFallEvent;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.combo.ComboState;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;

public class FallHandler {
    public static FallHandler getInstance() {
        return SingletonHolder.instance;
    }

    public void register() {
        LivingFallEvent.CALLBACK.register(this::onFall);
        PlayerFlyableFallEvent.CALLBACK.register(this::onFlyableFall);
    }

    public void onFall(LivingFallEvent event) {
        FallHandler.resetState(event.getEntity());
    }

    public void onFlyableFall(PlayerFlyableFallEvent event) {
        FallHandler.resetState((class_1309)event.getEntity());
    }

    public static void resetState(class_1309 user) {
        CapabilitySlashBlade.BLADESTATE.maybeGet((Object)user.method_6047()).ifPresent(state -> {
            ComboState combo;
            state.setFallDecreaseRate(0.0f);
            ComboState comboState = combo = ComboStateRegistry.COMBO_STATE.method_10223(state.getComboSeq()) != null ? (ComboState)ComboStateRegistry.COMBO_STATE.method_10223(state.getComboSeq()) : ComboStateRegistry.NONE;
            if (combo.isAerial()) {
                state.setComboSeq(combo.getNextOfTimeout(user));
            }
        });
    }

    public static void spawnLandingParticle(class_1309 user, float fallFactor) {
        if (!user.method_37908().method_8608()) {
            int x = class_3532.method_15357((double)user.method_23317());
            int y = class_3532.method_15357((double)(user.method_23318() - 0.5));
            int z = class_3532.method_15357((double)user.method_23321());
            class_2338 pos = new class_2338(x, y, z);
            class_2680 state = user.method_37908().method_8320(pos);
            float f = class_3532.method_15386((float)fallFactor);
            if (!state.method_26215()) {
                double d0 = Math.min((double)(0.2f + f / 15.0f), 2.5);
                int i = (int)(150.0 * d0);
                ((class_3218)user.method_37908()).method_14199((class_2394)new class_2388(class_2398.field_11217, state), user.method_23317(), user.method_23318(), user.method_23321(), i, 0.0, 0.0, 0.0, (double)0.15f);
            }
        }
    }

    public static void spawnLandingParticle(class_1297 user, class_243 targetPos, class_243 normal, float fallFactor) {
        if (!user.method_37908().method_8608()) {
            class_243 blockPos = targetPos.method_1019(normal.method_1029().method_1021(0.5));
            int x = class_3532.method_15357((double)blockPos.method_10216());
            int y = class_3532.method_15357((double)blockPos.method_10214());
            int z = class_3532.method_15357((double)blockPos.method_10215());
            class_2338 pos = new class_2338(x, y, z);
            class_2680 state = user.method_37908().method_8320(pos);
            float f = class_3532.method_15386((float)fallFactor);
            if (!state.method_26215()) {
                double d0 = Math.min((double)(0.2f + f / 15.0f), 2.5);
                int i = (int)(150.0 * d0);
                ((class_3218)user.method_37908()).method_14199((class_2394)new class_2388(class_2398.field_11217, state), targetPos.method_10216(), targetPos.method_10214(), targetPos.method_10215(), i, 0.0, 0.0, 0.0, (double)0.15f);
            }
        }
    }

    public static void fallDecrease(class_1309 user) {
        if (!user.method_5740() && !user.method_24828()) {
            user.field_6017 = 1.0f;
            float currentRatio = CapabilitySlashBlade.BLADESTATE.maybeGet((Object)user.method_6047()).map(state -> {
                float decRatio = state.getFallDecreaseRate();
                float newDecRatio = decRatio + 0.05f;
                newDecRatio = Math.min(1.0f, newDecRatio);
                state.setFallDecreaseRate(newDecRatio);
                return Float.valueOf(decRatio);
            }).orElse(Float.valueOf(1.0f)).floatValue();
            double gravityReductionFactor = 0.85f;
            int level = class_1890.method_8225((class_1887)class_1893.field_9129, (class_1799)user.method_6047());
            if (level > 0) {
                gravityReductionFactor = Math.min(0.93, gravityReductionFactor + 0.02 * (double)level);
                AdvancementHelper.grantedIf(class_1893.field_9129, user);
            }
            double g = 0.08 * gravityReductionFactor;
            class_243 motion = user.method_18798();
            if (motion.field_1351 < 0.0) {
                user.method_18800(motion.field_1352, (motion.field_1351 + g) * (double)currentRatio, motion.field_1350);
            }
        }
    }

    public static void fallResist(class_1309 user) {
        if (!user.method_5740() && !user.method_24828()) {
            user.field_6017 = 1.0f;
            class_243 motion = user.method_18798();
            double g = 0.08;
            if (motion.field_1351 < 0.0) {
                user.method_18800(motion.field_1352, motion.field_1351 + g + (double)0.002f, motion.field_1350);
            }
        }
    }

    private static final class SingletonHolder {
        private static final FallHandler instance = new FallHandler();

        private SingletonHolder() {
        }
    }
}

