/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.slashblade.SlashBladeDefinition;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2499;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import net.minecraft.class_8059;
import org.jetbrains.annotations.NotNull;

public class SlashBladeSmithingRecipe
implements class_8059 {
    public static final class_1865<SlashBladeSmithingRecipe> SERIALIZER = new Serializer();
    private final class_2960 outputBlade;
    private final class_2960 id;
    private final class_1856 template;
    private final class_1856 base;
    private final class_1856 addition;

    public SlashBladeSmithingRecipe(class_2960 id, class_2960 outputBlade, class_1856 template, class_1856 base, class_1856 addition) {
        this.id = id;
        this.outputBlade = outputBlade;
        this.template = template;
        this.base = base;
        this.addition = addition;
    }

    public SlashBladeSmithingRecipe(class_2960 outputBlade, class_1856 template, class_1856 base, class_1856 addition) {
        this(outputBlade, outputBlade, template, base, addition);
    }

    public class_1856 getTemplate() {
        return this.template;
    }

    public class_1856 getBase() {
        return this.base;
    }

    public class_1856 getAddition() {
        return this.addition;
    }

    private static class_1799 getResultBlade(class_2960 outputBlade) {
        class_1792 bladeItem = class_7923.field_41178.method_10250(outputBlade) ? (class_1792)class_7923.field_41178.method_10223(outputBlade) : SBItems.slashblade;
        return bladeItem.method_7854();
    }

    @NotNull
    public class_1799 method_8110(@NotNull class_5455 access) {
        class_1799 result = SlashBladeSmithingRecipe.getResultBlade(this.getOutputBlade());
        if (!class_7923.field_41178.method_10221((Object)result.method_7909()).equals((Object)this.getOutputBlade())) {
            result = ((SlashBladeDefinition)access.method_30530(SlashBladeDefinition.REGISTRY_KEY).method_10223(this.getOutputBlade())).getBlade();
        }
        return result;
    }

    public boolean method_8115(class_1263 container, @NotNull class_1937 level) {
        return this.template.method_8093(container.method_5438(0)) && this.base.method_8093(container.method_5438(1)) && this.addition.method_8093(container.method_5438(2));
    }

    @NotNull
    public class_1799 method_8116(@NotNull class_1263 container, @NotNull class_5455 access) {
        class_1799 result = this.method_8110(access);
        if (!(result.method_7909() instanceof ItemSlashBlade)) {
            result = new class_1799((class_1935)SBItems.slashblade);
        }
        ISlashBladeState resultState = (ISlashBladeState)CapabilitySlashBlade.BLADESTATE.maybeGet((Object)result).orElseThrow(NullPointerException::new);
        class_1799 stack = container.method_5438(1);
        if (CapabilitySlashBlade.BLADESTATE.maybeGet((Object)stack).isEmpty()) {
            return class_1799.field_8037;
        }
        ISlashBladeState ingredientState = (ISlashBladeState)CapabilitySlashBlade.BLADESTATE.maybeGet((Object)stack).orElseThrow(NullPointerException::new);
        resultState.setProudSoulCount(resultState.getProudSoulCount() + ingredientState.getProudSoulCount());
        resultState.setKillCount(resultState.getKillCount() + ingredientState.getKillCount());
        resultState.setRefine(resultState.getRefine() + ingredientState.getRefine());
        this.updateEnchantment(result, stack);
        return result;
    }

    @NotNull
    public class_2960 method_8114() {
        return this.id;
    }

    @NotNull
    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    public boolean method_31584() {
        return Stream.of(this.template, this.base, this.addition).anyMatch(SlashBladeSmithingRecipe::hasNoElements);
    }

    public boolean method_48453(@NotNull class_1799 stack) {
        return this.template.method_8093(stack);
    }

    public boolean method_48454(@NotNull class_1799 stack) {
        return this.base.method_8093(stack);
    }

    public boolean method_30029(@NotNull class_1799 stack) {
        return this.addition.method_8093(stack);
    }

    public class_2960 getOutputBlade() {
        return this.outputBlade;
    }

    private void updateEnchantment(class_1799 result, class_1799 ingredient) {
        Map newItemEnchants = class_1890.method_22445((class_2499)result.method_7921());
        Map oldItemEnchants = class_1890.method_22445((class_2499)ingredient.method_7921());
        Iterator iterator = oldItemEnchants.keySet().iterator();
        while (iterator.hasNext()) {
            class_1887 enchantIndex;
            class_1887 enchantment = enchantIndex = (class_1887)iterator.next();
            int destLevel = newItemEnchants.containsKey(enchantIndex) ? (Integer)newItemEnchants.get(enchantIndex) : 0;
            int srcLevel = (Integer)oldItemEnchants.get(enchantIndex);
            srcLevel = Math.max(srcLevel, destLevel);
            srcLevel = Math.min(srcLevel, enchantment.method_8183());
            boolean canApplyFlag = enchantment.method_8192(result);
            if (!canApplyFlag) continue;
            for (class_1887 curEnchantIndex : newItemEnchants.keySet()) {
                if (curEnchantIndex == enchantIndex || enchantment.method_8188(curEnchantIndex)) continue;
                canApplyFlag = false;
                break;
            }
            if (!canApplyFlag) continue;
            newItemEnchants.put(enchantIndex, srcLevel);
        }
        class_1890.method_8214((Map)newItemEnchants, (class_1799)result);
    }

    private static boolean hasNoElements(class_1856 ingredient) {
        class_1799[] items = ingredient.method_8105();
        if (items.length == 0) {
            return true;
        }
        if (items.length == 1) {
            class_5250 hoverName;
            class_2561 class_25612;
            class_1799 item = items[0];
            return item.method_7909() == class_1802.field_8077 && (class_25612 = item.method_7964()) instanceof class_5250 && (hoverName = (class_5250)class_25612).getString().startsWith("Empty Tag: ");
        }
        return false;
    }

    public static class Serializer
    implements class_1865<SlashBladeSmithingRecipe> {
        @NotNull
        public SlashBladeSmithingRecipe fromJson(@NotNull class_2960 id, @NotNull JsonObject json) {
            class_1856 ingredient = class_1856.method_52177((JsonElement)class_3518.method_52226((JsonObject)json, (String)"template"));
            class_1856 ingredient1 = class_1856.method_52177((JsonElement)class_3518.method_52226((JsonObject)json, (String)"base"));
            class_1856 ingredient2 = class_1856.method_52177((JsonElement)class_3518.method_52226((JsonObject)json, (String)"addition"));
            class_2960 output = new class_2960(class_3518.method_15265((JsonObject)json, (String)"blade"));
            return new SlashBladeSmithingRecipe(id, output, ingredient, ingredient1, ingredient2);
        }

        @NotNull
        public SlashBladeSmithingRecipe fromNetwork(@NotNull class_2960 id, @NotNull class_2540 buffer) {
            class_1856 ingredient = class_1856.method_8086((class_2540)buffer);
            class_1856 ingredient1 = class_1856.method_8086((class_2540)buffer);
            class_1856 ingredient2 = class_1856.method_8086((class_2540)buffer);
            class_2960 blade = buffer.method_10810();
            return new SlashBladeSmithingRecipe(id, blade, ingredient, ingredient1, ingredient2);
        }

        public void toNetwork(@NotNull class_2540 buffer, SlashBladeSmithingRecipe recipe) {
            recipe.template.method_8088(buffer);
            recipe.base.method_8088(buffer);
            recipe.addition.method_8088(buffer);
            buffer.method_10812(recipe.outputBlade);
        }
    }
}

