/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.util;

import cn.sh1rocu.slashblade.api.extension.ItemSlashBladeExtension;
import mods.flammpfeil.slashblade.SlashBladeConfig;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.util.AttackManager;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2743;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_5134;

public class AttackHelper {
    public static boolean onPlayerAttackTarget(class_1657 player, class_1297 target) {
        ItemSlashBladeExtension blade;
        class_1792 class_17922;
        if (((AttackEntityCallback)AttackEntityCallback.EVENT.invoker()).interact(player, player.method_37908(), class_1268.field_5808, target, null) == class_1269.field_5814) {
            return false;
        }
        class_1799 stack = player.method_6047();
        return stack.method_7960() || (class_17922 = stack.method_7909()) instanceof ItemSlashBladeExtension && !(blade = (ItemSlashBladeExtension)class_17922).onLeftClickEntity(stack, player, target);
    }

    public static void attack(class_1309 attacker, class_1297 target, float comboRatio) {
        class_1282 damageSource;
        class_1657 player;
        if (attacker instanceof class_1657 && !AttackHelper.onPlayerAttackTarget(player = (class_1657)attacker, target)) {
            return;
        }
        if (!target.method_5732() || target.method_5698((class_1297)attacker)) {
            return;
        }
        boolean isCritical = AttackHelper.isCriticalHit(attacker, target);
        double baseDamage = AttackHelper.calculateTotalDamage(attacker, target, comboRatio, isCritical);
        if (baseDamage <= 0.0) {
            return;
        }
        float knockback = AttackHelper.calculateKnockback(attacker);
        FireAspectResult fireAspectResult = AttackHelper.handleFireAspect(attacker, target);
        class_243 originalMotion = target.method_18798();
        if (attacker instanceof class_1657) {
            class_1657 player2 = (class_1657)attacker;
            damageSource = attacker.method_48923().method_48802(player2);
        } else {
            damageSource = attacker.method_48923().method_48812(attacker);
        }
        boolean damageSuccess = target.method_5643(damageSource, (float)baseDamage);
        if (damageSuccess) {
            AttackHelper.applyKnockback(attacker, target, knockback);
            AttackHelper.restoreTargetMotionIfNeeded(target, originalMotion);
            AttackHelper.playAttackEffects(attacker, target, isCritical);
            AttackHelper.handleEnchantmentsAndDurability(attacker, target);
            AttackHelper.handlePostAttackEffects(attacker, target, fireAspectResult);
        } else {
            AttackHelper.handleFailedAttack(attacker, target, fireAspectResult);
        }
    }

    public static double calculateTotalDamage(class_1309 attacker, class_1297 target, float comboRatio, boolean isCritical) {
        double baseDamage = attacker.method_26825(class_5134.field_23721);
        baseDamage += (double)AttackHelper.getSweepingBonus(attacker);
        baseDamage += (double)AttackHelper.getRankBonus(attacker);
        baseDamage += (double)AttackHelper.getEnchantmentBonus(attacker, target);
        baseDamage *= (double)(comboRatio * AttackManager.getSlashBladeDamageScale(attacker)) * (Double)SlashBladeConfig.SLASHBLADE_DAMAGE_MULTIPLIER.get();
        if (attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            baseDamage = 1.5;
        }
        return baseDamage;
    }

    public static float getSweepingBonus(class_1309 attacker) {
        return 10.0f * (class_1890.method_8217((class_1309)attacker) * 0.5f);
    }

    public static float getRankBonus(class_1309 attacker) {
        IConcentrationRank.ConcentrationRanks rankBonus = CapabilityConcentrationRank.RANK_POINT.maybeGet((Object)attacker).map(rp -> rp.getRank(attacker.method_5770().method_8510())).orElse(IConcentrationRank.ConcentrationRanks.NONE);
        double rankDamageBonus = (double)rankBonus.level / 2.0;
        if (IConcentrationRank.ConcentrationRanks.S.level <= rankBonus.level) {
            int refine = CapabilitySlashBlade.BLADESTATE.maybeGet((Object)attacker.method_6047()).map(ISlashBladeState::getRefine).orElse(0);
            int level = 0;
            if (attacker instanceof class_1657) {
                class_1657 player = (class_1657)attacker;
                level = player.field_7520;
            }
            rankDamageBonus = Math.max(rankDamageBonus, (double)Math.min(level, refine) * (Double)SlashBladeConfig.REFINE_DAMAGE_MULTIPLIER.get());
        }
        return (float)rankDamageBonus;
    }

    public static float getEnchantmentBonus(class_1309 attacker, class_1297 target) {
        if (target instanceof class_1309) {
            class_1309 living = (class_1309)target;
            return class_1890.method_8218((class_1799)attacker.method_6047(), (class_1310)living.method_6046());
        }
        return class_1890.method_8218((class_1799)attacker.method_6047(), (class_1310)class_1310.field_6290);
    }

    public static float calculateKnockback(class_1309 attacker) {
        float knockback = attacker.method_5996(class_5134.field_23722) != null ? (float)attacker.method_26825(class_5134.field_23722) : 0.0f;
        knockback += (float)class_1890.method_8205((class_1309)attacker);
        if (attacker.method_5624()) {
            attacker.method_37908().method_43128(null, attacker.method_23317(), attacker.method_23318(), attacker.method_23321(), class_3417.field_14999, attacker.method_5634(), 1.0f, 1.0f);
            knockback += 1.0f;
        }
        return knockback;
    }

    public static boolean isCriticalHit(class_1309 attacker, class_1297 target) {
        return attacker.field_6017 > 0.0f && !attacker.method_24828() && !attacker.method_6101() && !attacker.method_5799() && !attacker.method_6059(class_1294.field_5919) && !attacker.method_5765() && target instanceof class_1309 && !attacker.method_5624();
    }

    public static FireAspectResult handleFireAspect(class_1309 attacker, class_1297 target) {
        float preAttackHealth = 0.0f;
        boolean shouldSetFire = false;
        int fireAspectLevel = class_1890.method_8199((class_1309)attacker);
        if (target instanceof class_1309) {
            class_1309 living = (class_1309)target;
            preAttackHealth = living.method_6032();
            if (fireAspectLevel > 0 && !target.method_5809()) {
                shouldSetFire = true;
                target.method_5639(1);
            }
        }
        return new FireAspectResult(preAttackHealth, shouldSetFire, fireAspectLevel);
    }

    public static void applyKnockback(class_1309 attacker, class_1297 target, float knockback) {
        if (knockback > 0.0f) {
            if (target instanceof class_1309) {
                class_1309 living = (class_1309)target;
                living.method_6005((double)knockback * 0.5, (double)class_3532.method_15374((float)(attacker.method_36454() * ((float)Math.PI / 180))), (double)(-class_3532.method_15362((float)(attacker.method_36454() * ((float)Math.PI / 180)))));
            } else {
                target.method_5762((double)(-class_3532.method_15374((float)(attacker.method_36454() * ((float)Math.PI / 180))) * knockback) * 0.5, 0.1, (double)(class_3532.method_15362((float)(attacker.method_36454() * ((float)Math.PI / 180))) * knockback) * 0.5);
            }
            attacker.method_18799(attacker.method_18798().method_18805(0.6, 1.0, 0.6));
            attacker.method_5728(false);
        }
    }

    public static void restoreTargetMotionIfNeeded(class_1297 target, class_243 originalMotion) {
        if (target instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)target;
            if (target.field_6037) {
                target.method_18799(originalMotion);
                serverPlayer.field_13987.method_14364((class_2596)new class_2743(target));
                target.field_6037 = false;
            }
        }
    }

    public static void playAttackEffects(class_1309 attacker, class_1297 target, boolean isCritical) {
        attacker.method_37908().method_43128(null, attacker.method_23317(), attacker.method_23318(), attacker.method_23321(), class_3417.field_15016, attacker.method_5634(), 1.0f, 1.0f);
        if (isCritical && attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            player.method_7277(target);
        }
    }

    public static void handleEnchantmentsAndDurability(class_1309 attacker, class_1297 target) {
        attacker.method_6114(target);
        if (target instanceof class_1309) {
            class_1309 living = (class_1309)target;
            class_1890.method_8210((class_1309)living, (class_1297)attacker);
        }
        class_1890.method_8213((class_1309)attacker, (class_1297)target);
        class_1799 itemStack = attacker.method_6047();
        class_1297 entity = target;
        if (!attacker.method_37908().method_8608() && !itemStack.method_7960() && entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            class_1799 copy = itemStack.method_7972();
            class_1792 item = itemStack.method_7909();
            if (item.method_7873(itemStack, living, attacker) && attacker instanceof class_1657) {
                class_1657 player = (class_1657)attacker;
                player.method_7259(class_3468.field_15372.method_14956((Object)item));
            }
            if (itemStack.method_7960()) {
                if (attacker instanceof class_1657) {
                    class_1657 class_16572 = (class_1657)attacker;
                }
                attacker.method_6122(class_1268.field_5808, class_1799.field_8037);
            }
        }
    }

    public static void handlePostAttackEffects(class_1309 attacker, class_1297 target, FireAspectResult fireAspectResult) {
        if (target instanceof class_1309) {
            float damageDealt = fireAspectResult.preAttackHealth - ((class_1309)target).method_6032();
            if (attacker instanceof class_1657) {
                class_1657 player = (class_1657)attacker;
                player.method_7339(class_3468.field_15399, Math.round(damageDealt * 10.0f));
            }
            if (fireAspectResult.fireAspectLevel > 0) {
                target.method_5639(fireAspectResult.fireAspectLevel * 4);
            }
            if (attacker.method_37908() instanceof class_3218 && damageDealt > 2.0f) {
                int k = (int)((double)damageDealt * 0.5);
                ((class_3218)attacker.method_37908()).method_14199((class_2394)class_2398.field_11209, target.method_23317(), target.method_23323(0.5), target.method_23321(), k, 0.1, 0.0, 0.1, 0.2);
            }
        }
        if (attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            player.method_7322(0.1f);
        }
    }

    public static void handleFailedAttack(class_1309 attacker, class_1297 target, FireAspectResult fireAspectResult) {
        attacker.method_37908().method_43128(null, attacker.method_23317(), attacker.method_23318(), attacker.method_23321(), class_3417.field_14914, attacker.method_5634(), 1.0f, 1.0f);
        if (fireAspectResult.shouldSetFire) {
            target.method_5646();
        }
    }

    public static class FireAspectResult {
        final float preAttackHealth;
        final boolean shouldSetFire;
        final int fireAspectLevel;

        FireAspectResult(float preAttackHealth, boolean shouldSetFire, int fireAspectLevel) {
            this.preAttackHealth = preAttackHealth;
            this.shouldSetFire = shouldSetFire;
            this.fireAspectLevel = fireAspectLevel;
        }
    }
}

