/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.util;

import com.google.common.collect.Lists;
import com.jamieswhiteshirt.reachentityattributes.ReachEntityAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.SlashBladeConfig;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.data.tag.SlashBladeEntityTypeTagProvider;
import mods.flammpfeil.slashblade.entity.IShootable;
import mods.flammpfeil.slashblade.event.handler.InputCommandEvent;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.InputCommand;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1510;
import net.minecraft.class_1531;
import net.minecraft.class_1541;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4051;

public class TargetSelector {
    public static final class_4051 lockon = new SlashBladeTargetingConditions().method_18418(40.0).method_18420((Predicate)new AttackablePredicate());
    public static final class_4051 test = new SlashBladeTargetingConditions().method_18420(new AttackablePredicate());
    static final String AttackableTag = "RevengeAttacker";
    public static final class_4051 areaAttack = new SlashBladeTargetingConditions().method_18418(12.0).method_18424().method_18420((Predicate)new AttackablePredicate());

    static boolean isAttackable(class_1297 revengeTarget, class_1297 attacker) {
        return revengeTarget != null && attacker != null && (revengeTarget == attacker || revengeTarget.method_5722(attacker));
    }

    public static class_4051 getAreaAttackPredicate(double reach) {
        return areaAttack.method_18418(reach);
    }

    public static List<class_1297> getReflectableEntitiesWithinAABB(class_1309 attacker) {
        double reach = TargetSelector.getResolvedReach(attacker);
        class_238 aabb = TargetSelector.getResolvedAxisAligned(attacker.method_5829(), attacker.method_5720(), reach);
        class_1937 world = attacker.method_37908();
        return Stream.of(world.method_18467(class_1676.class, aabb).stream().filter(e -> !(e.method_24921() != null && e.method_24921() == attacker || e instanceof IShootable && ((IShootable)e).getShooter() == attacker))).flatMap(s -> s).filter(e -> e.method_5858((class_1297)attacker) < reach * reach).collect(Collectors.toList());
    }

    public static List<class_1297> getExtinguishableEntitiesWithinAABB(class_1309 attacker) {
        double reach = TargetSelector.getResolvedReach(attacker);
        class_238 aabb = TargetSelector.getResolvedAxisAligned(attacker.method_5829(), attacker.method_5720(), reach);
        class_1937 world = attacker.method_37908();
        return world.method_18467(class_1541.class, aabb).stream().filter(e -> e.method_5858((class_1297)attacker) < reach * reach).collect(Collectors.toList());
    }

    public static List<class_1297> getTargettableEntitiesWithinAABB(class_1937 world, class_1309 attacker) {
        return TargetSelector.getTargettableEntitiesWithinAABB(world, attacker, TargetSelector.getResolvedAxisAligned(attacker.method_5829(), attacker.method_5720(), TargetSelector.getResolvedReach(attacker)));
    }

    public static List<class_1297> getTargettableEntitiesWithinAABB(class_1937 world, class_1309 attacker, class_238 aabb) {
        double reach = TargetSelector.getResolvedReach(attacker);
        return TargetSelector.getTargettableEntitiesWithinAABB(world, attacker, aabb, reach);
    }

    public static List<class_1297> getTargettableEntitiesWithinAABB(class_1937 world, class_1309 attacker, class_238 aabb, double reach) {
        ArrayList list1 = Lists.newArrayList();
        list1.addAll(TargetSelector.getReflectableEntitiesWithinAABB(attacker));
        list1.addAll(TargetSelector.getExtinguishableEntitiesWithinAABB(attacker));
        list1.addAll(world.method_8390(class_1309.class, aabb.method_1014(5.0), e -> true).stream().filter(t -> {
            boolean result = false;
            AttackablePredicate check = new AttackablePredicate();
            result = check.test((class_1309)t);
            return result;
        }).toList());
        class_4051 predicate = TargetSelector.getAreaAttackPredicate(reach);
        list1.addAll(world.method_18467(class_1309.class, aabb).stream().filter(t -> {
            boolean result = false;
            result = predicate.method_18419(attacker, t);
            return result;
        }).toList());
        return list1;
    }

    public static <E extends class_1297> List<class_1297> getTargettableEntitiesWithinAABB(class_1937 world, double reach, E owner) {
        class_238 aabb = owner.method_5829().method_1014(reach);
        ArrayList list1 = Lists.newArrayList();
        list1.addAll(world.method_18467(class_1510.class, aabb.method_1014(5.0)).stream().flatMap(d -> Arrays.stream(d.method_5690())).filter(e -> e.method_5858(owner) < reach * reach).collect(Collectors.toList()));
        class_1309 user = ((IShootable)owner).getShooter() instanceof class_1309 ? (class_1309)((IShootable)owner).getShooter() : null;
        list1.addAll(TargetSelector.getReflectableEntitiesWithinAABB(world, reach, owner));
        class_4051 predicate = TargetSelector.getAreaAttackPredicate(0.0);
        list1.addAll(world.method_8390(class_1309.class, aabb, e -> true).stream().filter(t -> predicate.method_18419(user, t)).collect(Collectors.toList()));
        return list1;
    }

    public static <E extends class_1297> List<class_1297> getReflectableEntitiesWithinAABB(class_1937 world, double reach, E owner) {
        class_238 aabb = owner.method_5829().method_1014(reach);
        return Stream.of(world.method_18467(class_1676.class, aabb).stream().filter(e -> e.method_24921() == null || e.method_24921() != ((IShootable)owner).getShooter())).flatMap(s -> s).filter(e -> e.method_5858(owner) < reach * reach && e != owner).collect(Collectors.toList());
    }

    public static class_238 getResolvedAxisAligned(class_238 bb, class_243 dir, double reach) {
        double padding = 1.0;
        bb = dir == class_243.field_1353 ? bb.method_1014(reach * 2.0) : bb.method_997(dir.method_1021(reach * 0.5)).method_1014(reach);
        bb = bb.method_1014(1.0);
        return bb;
    }

    public static double getResolvedReach(class_1309 user) {
        double reach = 4.0;
        class_1324 attrib = user.method_5996(ReachEntityAttributes.REACH);
        if (attrib != null) {
            reach = attrib.method_6194() - 1.0;
        }
        return reach;
    }

    public static void onInputChange(InputCommandEvent event) {
        EnumSet<InputCommand> old = event.getOld();
        EnumSet<InputCommand> current = event.getCurrent();
        class_3222 sender = event.getEntity();
        class_1799 stack = sender.method_6047();
        if (stack.method_7960()) {
            return;
        }
        if (!(stack.method_7909() instanceof ItemSlashBlade)) {
            return;
        }
        if (old.contains((Object)InputCommand.M_DOWN) || !current.contains((Object)InputCommand.M_DOWN) || !current.contains((Object)InputCommand.SNEAK)) {
            return;
        }
        CapabilitySlashBlade.BLADESTATE.maybeGet((Object)stack).ifPresent(s -> {
            class_1297 tmp = s.getTargetEntity(sender.method_37908());
            if (tmp == null) {
                return;
            }
            if (!(tmp instanceof class_1309)) {
                return;
            }
            class_1309 target = (class_1309)tmp;
            if (target.method_6065() == sender) {
                return;
            }
            target.method_6015((class_1309)sender);
            if (target.method_37908() instanceof class_3218) {
                class_3218 sw = (class_3218)target.method_37908();
                sw.method_14166(sender, (class_2394)class_2398.field_11231, false, target.method_23317(), target.method_23318() + (double)target.method_5751(), target.method_23321(), 5, (double)target.method_17681() * 1.5, (double)target.method_17682(), (double)target.method_17681() * 1.5, 0.02);
            }
        });
    }

    public static class AttackablePredicate
    implements Predicate<class_1309> {
        @Override
        public boolean test(class_1309 livingentity) {
            if (!((Boolean)SlashBladeConfig.PVP_ENABLE.get()).booleanValue() && livingentity instanceof class_1657) {
                return false;
            }
            if (livingentity instanceof class_1531) {
                return ((class_1531)livingentity).method_6912();
            }
            if (livingentity.method_5752().contains(TargetSelector.AttackableTag)) {
                livingentity.method_5738(TargetSelector.AttackableTag);
                return true;
            }
            if (!((Boolean)SlashBladeConfig.FRIENDLY_ENABLE.get()).booleanValue() && !(livingentity instanceof class_1569)) {
                return false;
            }
            if (livingentity.method_5703(entity -> entity instanceof class_1657)) {
                return false;
            }
            if (livingentity.method_5851()) {
                return true;
            }
            if (livingentity.method_5781() != null) {
                return true;
            }
            return !livingentity.method_5864().method_20210(SlashBladeEntityTypeTagProvider.EntityTypeTags.ATTACKABLE_BLACKLIST);
        }
    }

    public static class SlashBladeTargetingConditions
    extends class_4051 {
        public SlashBladeTargetingConditions() {
            super(true);
        }

        public boolean method_18419(@Nullable class_1309 attacker, class_1309 target) {
            boolean isAttackable = false;
            if (!(isAttackable |= TargetSelector.isAttackable((class_1297)target.method_6065(), (class_1297)attacker)) && target instanceof class_1308) {
                isAttackable |= TargetSelector.isAttackable((class_1297)((class_1308)target).method_5968(), (class_1297)attacker);
            }
            if (isAttackable) {
                target.method_5780(TargetSelector.AttackableTag);
            }
            return super.method_18419(attacker, target);
        }
    }
}

