/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.emi.mixin;

import cn.sh1rocu.slashblade.mixin.accessor.ItemStackAccessor;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.ItemEmiStack;
import dev.emi.emi.api.stack.serializer.EmiIngredientSerializer;
import dev.emi.emi.api.stack.serializer.EmiStackSerializer;
import dev.emi.emi.runtime.EmiLog;
import dev.emi.emi.stack.serializer.ItemEmiStackSerializer;
import java.util.Optional;
import java.util.regex.Matcher;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={ItemEmiStackSerializer.class}, remap=false)
public abstract class MixinItemEmiStackSerializer
implements EmiStackSerializer<ItemEmiStack> {
    public JsonElement serialize(ItemEmiStack stack) {
        Optional optional;
        class_1799 itemStack;
        if (stack.getAmount() == 1L && stack.getChance() == 1.0f && stack.getRemainder().isEmpty() && !(stack.getItemStack().method_7909() instanceof ItemSlashBlade)) {
            String s = this.getType() + ":" + String.valueOf(stack.getId());
            if (stack.hasNbt()) {
                s = s + stack.getNbt().method_10714();
            }
            return new JsonPrimitive(s);
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", this.getType());
        json.addProperty("id", stack.getId().toString());
        if (stack.hasNbt()) {
            json.addProperty("nbt", stack.getNbt().method_10714());
        }
        if (stack.getAmount() != 1L) {
            json.addProperty("amount", (Number)stack.getAmount());
        }
        if (stack.getChance() != 1.0f) {
            json.addProperty("chance", (Number)Float.valueOf(stack.getChance()));
        }
        if ((itemStack = stack.getItemStack()).method_7909() instanceof ItemSlashBlade && (optional = CapabilitySlashBlade.BLADESTATE.maybeGet((Object)itemStack)).isPresent()) {
            json.addProperty("sbCaps", ((ISlashBladeState)optional.orElseThrow(NullPointerException::new)).getBladeState().method_10714());
        }
        if (!stack.getRemainder().isEmpty()) {
            JsonElement remainderElement;
            EmiStack remainder = stack.getRemainder();
            if (!remainder.getRemainder().isEmpty()) {
                remainder = remainder.copy().setRemainder(EmiStack.EMPTY);
            }
            if (remainder.getRemainder().isEmpty() && (remainderElement = EmiIngredientSerializer.getSerialized((EmiIngredient)remainder)) != null) {
                json.add("remainder", remainderElement);
            }
        }
        return json;
    }

    public EmiIngredient deserialize(JsonElement element) {
        class_2960 id = null;
        String nbt = null;
        String capNBT = null;
        long amount = 1L;
        float chance = 1.0f;
        EmiStack remainder = EmiStack.EMPTY;
        if (class_3518.method_15286((JsonElement)element)) {
            String s = element.getAsString();
            Matcher m = STACK_REGEX.matcher(s);
            if (m.matches()) {
                id = EmiPort.id((String)m.group(2), (String)m.group(3));
                nbt = m.group(4);
            }
        } else if (element.isJsonObject()) {
            EmiIngredient ing;
            JsonObject json = element.getAsJsonObject();
            id = EmiPort.id((String)class_3518.method_15265((JsonObject)json, (String)"id"));
            nbt = class_3518.method_15253((JsonObject)json, (String)"nbt", null);
            capNBT = class_3518.method_15265((JsonObject)json, (String)"sbCaps");
            amount = class_3518.method_15280((JsonObject)json, (String)"amount", (long)1L);
            chance = class_3518.method_15277((JsonObject)json, (String)"chance", (float)1.0f);
            if (class_3518.method_15294((JsonObject)json, (String)"remainder") && (ing = EmiIngredientSerializer.getDeserialized((JsonElement)json.get("remainder"))) instanceof EmiStack) {
                EmiStack stack;
                remainder = stack = (EmiStack)ing;
            }
        }
        if (id != null) {
            try {
                EmiStack stack;
                class_2487 nbtComp = null;
                if (nbt != null) {
                    nbtComp = class_2522.method_10718(nbt);
                }
                if (capNBT != null) {
                    class_2487 tag = new class_2487();
                    tag.method_10566("Parent", (class_2520)class_2522.method_10718((String)capNBT));
                    class_1799 itemStack = ItemStackAccessor.sb$create((class_1935)EmiPort.getItemRegistry().method_10223(id), (int)amount, Optional.of(tag));
                    class_2487 newNbt = itemStack.method_7948();
                    if (nbtComp != null) {
                        for (String key : nbtComp.method_10541()) {
                            newNbt.method_10566(key, nbtComp.method_10580(key).method_10707());
                        }
                    }
                    stack = new ItemEmiStack(itemStack);
                } else {
                    stack = this.create(id, nbtComp, amount);
                }
                if (chance != 1.0f) {
                    stack.setChance(chance);
                }
                if (!remainder.isEmpty()) {
                    stack.setRemainder(remainder);
                }
                return stack;
            }
            catch (Exception e) {
                EmiLog.error((String)"Error parsing NBT in deserialized stack", (Throwable)e);
                return EmiStack.EMPTY;
            }
        }
        return EmiStack.EMPTY;
    }
}

