/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event.handler;

import cn.sh1rocu.slashblade.api.event.LivingExperienceDropEvent;
import mods.flammpfeil.slashblade.SlashBladeConfig;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.event.SlashBladeEvent;
import mods.flammpfeil.slashblade.item.SwordType;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

public class KillCounter {
    public static KillCounter getInstance() {
        return SingletonHolder.instance;
    }

    private KillCounter() {
    }

    public void register() {
        ServerLivingEntityEvents.AFTER_DEATH.register(this::onLivingDeathEvent);
        LivingExperienceDropEvent.CALLBACK.register(this::onXPDropping);
    }

    public void onLivingDeathEvent(class_1309 attacker, class_1282 source) {
        class_1297 trueSource = source.method_5529();
        if (!(trueSource instanceof class_1309)) {
            return;
        }
        class_1799 stack = ((class_1309)trueSource).method_6047();
        if (stack.method_7960()) {
            return;
        }
        if (CapabilitySlashBlade.BLADESTATE.maybeGet((Object)stack).isEmpty()) {
            return;
        }
        CapabilitySlashBlade.BLADESTATE.maybeGet((Object)stack).ifPresent(state -> {
            SlashBladeEvent.AddKillCountEvent killCountEvent = new SlashBladeEvent.AddKillCountEvent(stack, (ISlashBladeState)state, 1);
            ((SlashBladeEvent.AddKillCount)SlashBladeEvent.ADD_KILL_COUNT.invoker()).onAddAddKillCount(killCountEvent);
            state.setKillCount(state.getKillCount() + killCountEvent.getNewCount());
        });
    }

    public void onXPDropping(LivingExperienceDropEvent event) {
        class_1657 player = event.getAttackingPlayer();
        if (player == null) {
            return;
        }
        class_1799 stack = player.method_6047();
        if (stack.method_7960()) {
            return;
        }
        if (CapabilitySlashBlade.BLADESTATE.maybeGet((Object)stack).isEmpty()) {
            return;
        }
        IConcentrationRank.ConcentrationRanks rankBonus = CapabilityConcentrationRank.RANK_POINT.maybeGet((Object)player).map(rp -> rp.getRank(player.method_5770().method_8510())).orElse(IConcentrationRank.ConcentrationRanks.NONE);
        int souls = (int)Math.floor((float)event.getDroppedExperience() * (1.0f + (float)rankBonus.level * 0.1f));
        CapabilitySlashBlade.BLADESTATE.maybeGet((Object)stack).ifPresent(state -> {
            SlashBladeEvent.AddProudSoulEvent soulEvent = new SlashBladeEvent.AddProudSoulEvent(stack, (ISlashBladeState)state, Math.min((Integer)SlashBladeConfig.MAX_PROUD_SOUL_GOT.get(), souls));
            ((SlashBladeEvent.AddProudSoul)SlashBladeEvent.ADD_PROUD_SOUL.invoker()).onAddProudSoul(soulEvent);
            int newCount = soulEvent.getNewCount();
            state.setProudSoulCount(state.getProudSoulCount() + newCount);
            if (SwordType.from(stack).contains((Object)SwordType.SOULEATER)) {
                int damage = Math.max(1, newCount / 4);
                stack.method_7974(Math.max(stack.method_7919() - damage, 0));
            }
        });
    }

    private static final class SingletonHolder {
        private static final KillCounter instance = new KillCounter();

        private SingletonHolder() {
        }
    }
}

