/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.recipe;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.recipe.RequestDefinition;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2359;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7922;
import net.minecraft.class_7923;

public class SlashBladeIngredient
implements CustomIngredient {
    private final Set<class_1792> items;
    private final RequestDefinition request;

    protected SlashBladeIngredient(Set<class_1792> items, RequestDefinition request) {
        if (items.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a SlashBladeIngredient with no items");
        }
        this.items = Collections.unmodifiableSet(items);
        this.request = request;
    }

    public static SlashBladeIngredient of(class_1935 item, RequestDefinition request) {
        return new SlashBladeIngredient(Set.of(item.method_8389()), request);
    }

    public static SlashBladeIngredient of(RequestDefinition request) {
        return new SlashBladeIngredient(Set.of(SBItems.SLASHBLADE), request);
    }

    public static SlashBladeIngredient of(class_1935 item, class_2960 request) {
        return new SlashBladeIngredient(Set.of(item.method_8389()), RequestDefinition.Builder.newInstance().name(request).build());
    }

    public static SlashBladeIngredient of(class_2960 request) {
        return new SlashBladeIngredient(Set.of(SBItems.SLASHBLADE), RequestDefinition.Builder.newInstance().name(request).build());
    }

    public static SlashBladeIngredient blankNameless() {
        return SlashBladeIngredient.of(RequestDefinition.Builder.newInstance().build());
    }

    public boolean test(class_1799 input) {
        if (input == null) {
            return false;
        }
        return this.items.contains(input.method_7909()) && this.request.test(input);
    }

    public List<class_1799> getMatchingStacks() {
        return this.items.stream().map(item -> {
            class_1799 stack = new class_1799((class_1935)item);
            this.request.initItemStack(stack);
            return stack;
        }).toList();
    }

    public boolean requiresTesting() {
        return true;
    }

    public CustomIngredientSerializer<? extends CustomIngredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements CustomIngredientSerializer<SlashBladeIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final class_2960 RES = SlashBlade.prefix("blade");

        public class_2960 getIdentifier() {
            return RES;
        }

        public SlashBladeIngredient read(JsonObject jsonObject) {
            ImmutableSet items;
            if (jsonObject.has("item")) {
                class_2960 loc = class_2960.method_12829((String)class_3518.method_15265((JsonObject)jsonObject, (String)"item"));
                if (loc == null) {
                    throw new JsonSyntaxException("Item " + String.valueOf(loc) + " is not a valid item");
                }
                items = Set.of((class_1792)class_7923.field_41178.method_10223(loc));
            } else if (jsonObject.has("items")) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                JsonArray itemArray = class_3518.method_15261((JsonObject)jsonObject, (String)"items");
                for (int i = 0; i < itemArray.size(); ++i) {
                    class_2960 loc = class_2960.method_12829((String)class_3518.method_15287((JsonElement)itemArray.get(i), (String)("items[" + i + "]")));
                    if (loc == null) {
                        throw new JsonSyntaxException("Item " + String.valueOf(loc) + " is not a valid item");
                    }
                    builder.add((Object)((class_1792)class_7923.field_41178.method_10223(loc)));
                }
                items = builder.build();
            } else {
                throw new JsonSyntaxException("Must set either 'item' or 'items'");
            }
            RequestDefinition request = RequestDefinition.fromJSON(jsonObject.getAsJsonObject("request"));
            return new SlashBladeIngredient((Set<class_1792>)items, request);
        }

        public void write(JsonObject jsonObject, SlashBladeIngredient slashBladeIngredient) {
            jsonObject.addProperty("type", RES.toString());
            if (slashBladeIngredient.items.size() == 1) {
                jsonObject.addProperty("item", class_7923.field_41178.method_10221((Object)slashBladeIngredient.items.iterator().next()).toString());
            } else {
                JsonArray items = new JsonArray();
                slashBladeIngredient.items.stream().map(arg_0 -> ((class_7922)class_7923.field_41178).method_10221(arg_0)).sorted().forEach(name -> items.add(name.toString()));
                jsonObject.add("items", (JsonElement)items);
            }
            jsonObject.add("request", slashBladeIngredient.request.toJson());
        }

        public SlashBladeIngredient read(class_2540 friendlyByteBuf) {
            Set<class_1792> items = Stream.generate(() -> (class_1792)friendlyByteBuf.method_42064((class_2359)class_7923.field_41178)).limit(friendlyByteBuf.method_10816()).collect(Collectors.toSet());
            RequestDefinition request = RequestDefinition.fromNetwork(friendlyByteBuf);
            return new SlashBladeIngredient(items, request);
        }

        public void write(class_2540 buffer, SlashBladeIngredient ingredient) {
            buffer.method_10804(ingredient.items.size());
            for (class_1792 item : ingredient.items) {
                buffer.method_42065((class_2359)class_7923.field_41178, (Object)item);
            }
            ingredient.request.toNetwork(buffer);
        }
    }
}

