/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.recipe.SlashBladeShapedRecipe;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7710;
import net.minecraft.class_7798;
import net.minecraft.class_7800;
import net.minecraft.class_7923;

public class SlashBladeShapedRecipeBuilder
extends class_7798
implements class_5797 {
    private final class_7800 category = class_7800.field_40639;
    private final class_1792 result;
    private final int count;
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, class_1856> key = Maps.newLinkedHashMap();
    private final class_161.class_162 advancement = class_161.class_162.method_51698();
    @Nullable
    private String group;
    private boolean showNotification = true;
    private class_2960 blade = null;

    public SlashBladeShapedRecipeBuilder(class_1935 item, int count) {
        this.result = item.method_8389();
        this.count = count;
    }

    public static SlashBladeShapedRecipeBuilder shaped(class_2960 blade) {
        return SlashBladeShapedRecipeBuilder.shaped((class_1935)SBItems.SLASHBLADE, 1).blade(blade);
    }

    public static SlashBladeShapedRecipeBuilder shaped(class_1935 result) {
        return SlashBladeShapedRecipeBuilder.shaped(result, 1);
    }

    public static SlashBladeShapedRecipeBuilder shaped(class_1935 result, int count) {
        return new SlashBladeShapedRecipeBuilder(result, count);
    }

    public SlashBladeShapedRecipeBuilder define(Character key, class_6862<class_1792> tag) {
        return this.define(key, class_1856.method_8106(tag));
    }

    public SlashBladeShapedRecipeBuilder define(Character key, class_1935 tag) {
        return this.define(key, class_1856.method_8091((class_1935[])new class_1935[]{tag}));
    }

    public SlashBladeShapedRecipeBuilder blade(class_2960 blade) {
        this.blade = blade;
        return this;
    }

    public SlashBladeShapedRecipeBuilder define(Character key, class_1856 ingredient) {
        if (this.key.containsKey(key)) {
            throw new IllegalArgumentException("Symbol '" + key + "' is already defined!");
        }
        if (key.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(key, ingredient);
        return this;
    }

    public SlashBladeShapedRecipeBuilder pattern(String pattern) {
        if (!this.rows.isEmpty() && pattern.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(pattern);
        return this;
    }

    public SlashBladeShapedRecipeBuilder unlockedBy(String key, class_184 trigger) {
        this.advancement.method_709(key, trigger);
        return this;
    }

    public SlashBladeShapedRecipeBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    public SlashBladeShapedRecipeBuilder showNotification(boolean show) {
        this.showNotification = show;
        return this;
    }

    public class_1792 method_36441() {
        return this.result;
    }

    public void method_10431(Consumer<class_2444> consumer) {
        this.method_17972(consumer, this.blade != null ? this.blade : class_7923.field_41178.method_10221((Object)this.method_36441()));
    }

    public void method_17972(Consumer<class_2444> consumer, class_2960 id) {
        this.ensureValid(id);
        this.advancement.method_708(field_39377).method_709("has_the_recipe", (class_184)class_2119.method_27847((class_2960)id)).method_703(class_170.class_171.method_753((class_2960)id)).method_704(class_193.field_1257);
        consumer.accept((class_2444)new Result(id, this.result, this.count, this.blade, this.group == null ? "" : this.group, this.rows, this.key, this.advancement, id.method_45138("recipes/" + this.category.method_46203() + "/"), this.showNotification));
    }

    private void ensureValid(class_2960 p_126144_) {
        if (this.rows.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + String.valueOf(p_126144_) + "!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.rows) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + String.valueOf(p_126144_) + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + String.valueOf(p_126144_));
        }
        if (this.rows.size() == 1 && this.rows.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + String.valueOf(p_126144_) + " only takes in a single item - should it be a shapeless recipe instead?");
        }
        if (this.advancement.method_710().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(p_126144_));
        }
    }

    public static class Result
    extends class_7798.class_7799 {
        private final class_2960 id;
        private final class_1792 result;
        private final int count;
        private final String group;
        private final List<String> pattern;
        private final Map<Character, class_1856> key;
        private final class_161.class_162 advancement;
        private final class_2960 advancementId;
        private final class_2960 bladeId;
        private final boolean showNotification;

        public Result(class_2960 id, class_1792 result, int count, class_2960 bladeId, String group, List<String> pattern, Map<Character, class_1856> key, class_161.class_162 advancement, class_2960 advancementId, boolean showNotification) {
            super(class_7710.field_40250);
            this.id = id;
            this.result = result;
            this.count = count;
            this.group = group;
            this.pattern = pattern;
            this.key = key;
            this.advancement = advancement;
            this.advancementId = advancementId;
            this.bladeId = bladeId;
            this.showNotification = showNotification;
        }

        public void method_10416(JsonObject json) {
            super.method_10416(json);
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray jsonarray = new JsonArray();
            for (String string : this.pattern) {
                jsonarray.add(string);
            }
            json.add("pattern", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            for (Map.Entry<Character, class_1856> entry : this.key.entrySet()) {
                jsonobject.add(String.valueOf(entry.getKey()), entry.getValue().method_8089());
            }
            json.add("key", (JsonElement)jsonobject);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", class_7923.field_41178.method_10221((Object)this.result).toString());
            if (this.count > 1) {
                jsonObject.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)jsonObject);
            if (this.bladeId != null) {
                json.addProperty("blade", this.bladeId.toString());
            }
            json.addProperty("show_notification", Boolean.valueOf(this.showNotification));
        }

        public class_1865<?> method_17800() {
            return SlashBladeShapedRecipe.SERIALIZER;
        }

        public class_2960 method_10417() {
            return this.id;
        }

        @Nullable
        public JsonObject method_10415() {
            return this.advancement.method_698();
        }

        @Nullable
        public class_2960 method_10418() {
            return this.advancementId;
        }
    }
}

