/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.registry.slashblade;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Comparator;
import java.util.List;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.SlashBladeCreativeGroup;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.capability.slashblade.SlashBladeState;
import mods.flammpfeil.slashblade.event.SlashBladeRegistryEvent;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.registry.slashblade.EnchantmentDefinition;
import mods.flammpfeil.slashblade.registry.slashblade.PropertiesDefinition;
import mods.flammpfeil.slashblade.registry.slashblade.RenderDefinition;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class SlashBladeDefinition {
    public static final Codec<SlashBladeDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.optionalFieldOf("item", (Object)SlashBlade.prefix("slashblade")).forGetter(SlashBladeDefinition::getItemName), (App)class_2960.field_25139.fieldOf("name").forGetter(SlashBladeDefinition::getName), (App)RenderDefinition.CODEC.fieldOf("render").forGetter(SlashBladeDefinition::getRenderDefinition), (App)PropertiesDefinition.CODEC.fieldOf("properties").forGetter(SlashBladeDefinition::getStateDefinition), (App)EnchantmentDefinition.CODEC.listOf().optionalFieldOf("enchantments", (Object)Lists.newArrayList()).forGetter(SlashBladeDefinition::getEnchantments), (App)class_2960.field_25139.optionalFieldOf("creativeGroup", (Object)class_7923.field_44687.method_10221((Object)SlashBladeCreativeGroup.SLASHBLADE_GROUP)).forGetter(SlashBladeDefinition::getCreativeGroup)).apply((Applicative)instance, SlashBladeDefinition::new));
    public static final class_5321<class_2378<SlashBladeDefinition>> REGISTRY_KEY = class_5321.method_29180((class_2960)SlashBlade.prefix("named_blades"));
    private final class_2960 item;
    private final class_2960 name;
    private final RenderDefinition renderDefinition;
    private final PropertiesDefinition stateDefinition;
    private final List<EnchantmentDefinition> enchantments;
    private final class_2960 creativeGroup;
    public static final BladeComparator COMPARATOR = new BladeComparator();

    public SlashBladeDefinition(class_2960 name, RenderDefinition renderDefinition, PropertiesDefinition stateDefinition, List<EnchantmentDefinition> enchantments) {
        this(SlashBlade.prefix("slashblade"), name, renderDefinition, stateDefinition, enchantments, class_7923.field_44687.method_10221((Object)SlashBladeCreativeGroup.SLASHBLADE_GROUP));
    }

    public SlashBladeDefinition(class_2960 name, RenderDefinition renderDefinition, PropertiesDefinition stateDefinition, List<EnchantmentDefinition> enchantments, class_2960 creativeGroup) {
        this(SlashBlade.prefix("slashblade"), name, renderDefinition, stateDefinition, enchantments, creativeGroup);
    }

    public SlashBladeDefinition(class_2960 item, class_2960 name, RenderDefinition renderDefinition, PropertiesDefinition stateDefinition, List<EnchantmentDefinition> enchantments) {
        this(item, name, renderDefinition, stateDefinition, enchantments, class_7923.field_44687.method_10221((Object)SlashBladeCreativeGroup.SLASHBLADE_GROUP));
    }

    public SlashBladeDefinition(class_2960 item, class_2960 name, RenderDefinition renderDefinition, PropertiesDefinition stateDefinition, List<EnchantmentDefinition> enchantments, class_2960 creativeGroup) {
        this.item = item;
        this.name = name;
        this.renderDefinition = renderDefinition;
        this.stateDefinition = stateDefinition;
        this.enchantments = enchantments;
        this.creativeGroup = creativeGroup;
    }

    public class_2960 getItemName() {
        return this.item;
    }

    public class_2960 getName() {
        return this.name;
    }

    public String getTranslationKey() {
        return class_156.method_646((String)"item", (class_2960)this.getName());
    }

    public RenderDefinition getRenderDefinition() {
        return this.renderDefinition;
    }

    public PropertiesDefinition getStateDefinition() {
        return this.stateDefinition;
    }

    public List<EnchantmentDefinition> getEnchantments() {
        return this.enchantments;
    }

    public class_1799 getBlade() {
        return this.getBlade(this.getItem());
    }

    public class_1799 getBlade(class_1792 bladeItem) {
        SlashBladeRegistryEvent.Pre event = new SlashBladeRegistryEvent.Pre(this);
        ((SlashBladeRegistryEvent.Pre.Callback)SlashBladeRegistryEvent.PRE.invoker()).onPre(event);
        if (event.isCanceled()) {
            return class_1799.field_8037;
        }
        class_1799 result = new class_1799((class_1935)bladeItem);
        ISlashBladeState state = CapabilitySlashBlade.BLADESTATE.maybeGet((Object)result).orElse(new SlashBladeState(result));
        state.setNonEmpty();
        state.setBaseAttackModifier(this.stateDefinition.getBaseAttackModifier());
        state.setMaxDamage(this.stateDefinition.getMaxDamage());
        state.setComboRoot(this.stateDefinition.getComboRoot());
        state.setSlashArtsKey(this.stateDefinition.getSpecialAttackType());
        this.stateDefinition.getSpecialEffects().forEach(state::addSpecialEffect);
        this.stateDefinition.getDefaultType().forEach(type -> {
            switch (type) {
                case BEWITCHED: {
                    state.setDefaultBewitched(true);
                    break;
                }
                case BROKEN: {
                    result.method_7974(result.method_7936() - 1);
                    state.setBroken(true);
                    break;
                }
                case SEALED: {
                    state.setSealed(true);
                    break;
                }
            }
        });
        state.setModel(this.renderDefinition.getModelName());
        state.setTexture(this.renderDefinition.getTextureName());
        state.setColorCode(this.renderDefinition.getSummonedSwordColor());
        state.setEffectColorInverse(this.renderDefinition.isSummonedSwordColorInverse());
        state.setCarryType(this.renderDefinition.getStandbyRenderType());
        if (!this.getName().equals((Object)SlashBlade.prefix("none"))) {
            state.setTranslationKey(this.getTranslationKey());
        }
        for (EnchantmentDefinition instance : this.enchantments) {
            class_1887 enchantment = (class_1887)class_7923.field_41176.method_10223(instance.getEnchantmentID());
            result.method_7978(enchantment, instance.getEnchantmentLevel());
        }
        if (this.stateDefinition.isUnbreakable()) {
            result.method_7948().method_10556("Unbreakable", true);
        }
        SlashBladeRegistryEvent.Post postRegistry = new SlashBladeRegistryEvent.Post(this, result);
        ((SlashBladeRegistryEvent.Post.Callback)SlashBladeRegistryEvent.POST.invoker()).onPost(postRegistry);
        return postRegistry.getBlade();
    }

    public class_1792 getItem() {
        @Nullable class_1792 value = (class_1792)class_7923.field_41178.method_10223(this.item);
        if (value == null) {
            return SBItems.SLASHBLADE;
        }
        return value;
    }

    public class_2960 getCreativeGroup() {
        return this.creativeGroup;
    }

    private static class BladeComparator
    implements Comparator<class_6880.class_6883<SlashBladeDefinition>> {
        private BladeComparator() {
        }

        @Override
        public int compare(class_6880.class_6883<SlashBladeDefinition> left, class_6880.class_6883<SlashBladeDefinition> right) {
            class_2960 leftKey = left.method_40237().method_29177();
            class_2960 rightKey = right.method_40237().method_29177();
            boolean checkSame = leftKey.method_12836().equalsIgnoreCase(rightKey.method_12836());
            if (!checkSame) {
                if (leftKey.method_12836().equalsIgnoreCase("slashblade")) {
                    return -1;
                }
                if (rightKey.method_12836().equalsIgnoreCase("slashblade")) {
                    return 1;
                }
            }
            String leftName = leftKey.toString();
            String rightName = rightKey.toString();
            return leftName.compareToIgnoreCase(rightName);
        }
    }
}

