package mods.flammpfeil.slashblade.entity;

import cn.sh1rocu.slashblade.api.extension.EntityExtension;
import cn.sh1rocu.slashblade.api.extension.IEntityAdditionalSpawnData;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import mods.flammpfeil.slashblade.ability.StunManager;
import mods.flammpfeil.slashblade.event.SlashBladeEvent;
import mods.flammpfeil.slashblade.util.AttackManager;
import mods.flammpfeil.slashblade.util.EnumSetConverter;
import mods.flammpfeil.slashblade.util.NBTHelper;
import mods.flammpfeil.slashblade.util.TargetSelector;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1560;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1844;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_7924;
import net.minecraft.world.phys.*;
import javax.annotation.Nullable;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;

import static mods.flammpfeil.slashblade.SlashBladeConfig.SLASHBLADE_DAMAGE_MULTIPLIER;

public class EntityAbstractSummonedSword extends Projectile implements IShootable, EntityExtension {
    private static final class_2940<Integer> COLOR = class_2945
            .<Integer>method_12791(EntityAbstractSummonedSword.class, class_2943.field_13327);
    private static final class_2940<Integer> FLAGS = class_2945
            .<Integer>method_12791(EntityAbstractSummonedSword.class, class_2943.field_13327);
    private static final class_2940<Integer> HIT_ENTITY_ID = class_2945
            .<Integer>method_12791(EntityAbstractSummonedSword.class, class_2943.field_13327);
    private static final class_2940<Float> OFFSET_YAW = class_2945
            .<Float>method_12791(EntityAbstractSummonedSword.class, class_2943.field_13320);
    private static final class_2940<Float> ROLL = class_2945
            .<Float>method_12791(EntityAbstractSummonedSword.class, class_2943.field_13320);
    private static final class_2940<Byte> PIERCE = class_2945.method_12791(EntityAbstractSummonedSword.class,
            class_2943.field_13319);
    private static final class_2940<String> MODEL = class_2945
            .method_12791(EntityAbstractSummonedSword.class, class_2943.field_13326);
    private static final class_2940<Integer> DELAY = class_2945
            .<Integer>method_12791(EntityAbstractSummonedSword.class, class_2943.field_13327);

    private int ticksInGround;
    private boolean inGround;
    private class_2680 inBlockState;
    private int ticksInAir;
    private double damage = 1.0D;

    private IntOpenHashSet alreadyHits;

    private class_1297 hitEntity = null;

    static final int ON_GROUND_LIFE_TIME = 20 * 5;

    private class_3414 hitEntitySound = class_3417.field_15213;
    private class_3414 hitEntityPlayerSound = class_3417.field_15213;
    private class_3414 hitGroundSound = class_3417.field_15104;

    protected class_3414 getHitEntitySound() {
        return this.hitEntitySound;
    }

    protected class_3414 getHitEntityPlayerSound() {
        return this.hitEntityPlayerSound;
    }

    protected class_3414 getHitGroundSound() {
        return this.hitGroundSound;
    }

    public EntityAbstractSummonedSword(class_1299<? extends Projectile> entityTypeIn, class_1937 worldIn) {
        super(entityTypeIn, worldIn);
        this.method_5875(true);
        // this.setGlowing(true);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(COLOR, 0x3333FF);
        this.field_6011.method_12784(FLAGS, 0);
        this.field_6011.method_12784(HIT_ENTITY_ID, -1);
        this.field_6011.method_12784(OFFSET_YAW, 0f);
        this.field_6011.method_12784(ROLL, 0f);
        this.field_6011.method_12784(PIERCE, (byte) 0);
        this.field_6011.method_12784(MODEL, "");
        this.field_6011.method_12784(DELAY, 10);
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);

        NBTHelper.getNBTCoupler(compound).put("Color", this.getColor()).put("life", (short) this.ticksInGround)
                .put("inBlockState", (this.inBlockState != null ? class_2512.method_10686(this.inBlockState) : null))
                .put("inGround", this.inGround).put("damage", this.damage).put("crit", this.getIsCritical())
                .put("clip", this.isNoClip()).put("PierceLevel", this.getPierce()).put("model", this.getModelName())
                .put("Delay", this.getDelay());
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);

        NBTHelper.getNBTCoupler(compound).get("Color", this::setColor)
                .get("life", ((Integer v) -> this.ticksInGround = v))
                .get("inBlockState",
                        ((class_2487 v) -> this.inBlockState = class_2512
                                .method_10681(this.method_37908().method_45448(class_7924.field_41254), v)))
                .get("inGround", ((Boolean v) -> this.inGround = v))
                .get("damage", ((Double v) -> this.damage = v), this.damage).get("crit", this::setIsCritical)
                .get("clip", this::setNoClip).get("PierceLevel", this::setPierce).get("model", this::setModelName)
                .get("Delay", this::setDelay);
    }

    @Override
    public class_2596<class_2602> method_18002() {
        //return NetworkHooks.getEntitySpawningPacket(this);
        return IEntityAdditionalSpawnData.getEntitySpawningPacket(this);
    }

    @Override
    public void method_7485(double x, double y, double z, float velocity, float inaccuracy) {
        class_243 vec3d = (new class_243(x, y, z)).method_1029()
                .method_1031(this.field_5974.method_43059() * (double) 0.0075F * (double) inaccuracy,
                        this.field_5974.method_43059() * (double) 0.0075F * (double) inaccuracy,
                        this.field_5974.method_43059() * (double) 0.0075F * (double) inaccuracy)
                .method_1021(velocity);
        this.method_18799(vec3d);
        float f = class_3532.method_15355((float) vec3d.method_37268());
        this.method_33574(this.method_19538());
        this.method_36456((float) (class_3532.method_15349(vec3d.field_1352, vec3d.field_1350) * (double) (180F / (float) Math.PI)));
        this.method_36457((float) (class_3532.method_15349(vec3d.field_1351, (double) f) * (double) (180F / (float) Math.PI)));
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
        this.ticksInGround = 0;
    }

    @Override
    @Environment(EnvType.CLIENT)
    public boolean method_5640(double distance) {
        double d0 = this.method_5829().method_995() * 10.0D;
        if (Double.isNaN(d0)) {
            d0 = 1.0D;
        }

        d0 = d0 * 64.0D * method_5824();
        return distance < d0 * d0;
    }

    @Override
    @Environment(EnvType.CLIENT)
    public void method_5759(double x, double y, double z, float yaw, float pitch, int posRotationIncrements,
                       boolean teleport) {
        this.method_5814(x, y, z);
        this.method_5710(yaw, pitch);
    }

    @Override
    @Environment(EnvType.CLIENT)
    public void method_5750(double x, double y, double z) {
        this.method_18800(x, y, z);
        if (this.field_6004 == 0.0F && this.field_5982 == 0.0F) {
            float f = class_3532.method_15355((float) (x * x + z * z));
            this.method_36457((float) (class_3532.method_15349(y, (double) f) * (double) (180F / (float) Math.PI)));
            this.method_36456((float) (class_3532.method_15349(x, z) * (double) (180F / (float) Math.PI)));
            this.field_6004 = this.method_36455();
            this.field_5982 = this.method_36454();
            this.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), this.method_36454(), this.method_36455());
            this.ticksInGround = 0;
        }

    }

    enum FlagsState {
        Critical, NoClip,
    }

    protected EnumSet<FlagsState> flags = EnumSet.noneOf(FlagsState.class);
    protected int intFlags = 0;

    protected void setFlags(FlagsState value) {
        this.flags.add(value);
        refreshFlags();
    }

    protected void removeFlags(FlagsState value) {
        this.flags.remove(value);
        refreshFlags();
    }

    private void refreshFlags() {
        if (this.method_37908().method_8608()) {
            int newValue = this.field_6011.method_12789(FLAGS).intValue();
            if (intFlags != newValue) {
                intFlags = newValue;
                flags = EnumSetConverter.convertToEnumSet(FlagsState.class, intFlags);
            }
        } else {
            int newValue = EnumSetConverter.convertToInt(this.flags);
            if (this.intFlags != newValue) {
                this.field_6011.method_12778(FLAGS, newValue);
                this.intFlags = newValue;
            }
        }
    }

    public void setIsCritical(boolean value) {
        if (value)
            setFlags(FlagsState.Critical);
        else
            removeFlags(FlagsState.Critical);
    }

    public boolean getIsCritical() {
        refreshFlags();
        return flags.contains(FlagsState.Critical);
    }

    public void setNoClip(boolean value) {
        this.field_5960 = value;
        if (value)
            setFlags(FlagsState.NoClip);
        else
            removeFlags(FlagsState.NoClip);
    }

    // disallowedHitBlock
    public boolean isNoClip() {
        if (!this.method_37908().method_8608()) {
            return this.field_5960;
        } else {
            refreshFlags();
            return flags.contains(FlagsState.NoClip);
        }
    }

    @Override
    public void method_5773() {
        super.method_5773();

        if (getHitEntity() != null) {
            class_1297 hits = getHitEntity();

            if (!hits.method_5805()) {
                this.burst();
            } else {
                this.method_5814(hits.method_23317(), hits.method_23318() + hits.method_5751() * 0.5f, hits.method_23321());

                int delay = getDelay();
                delay--;
                setDelay(delay);

                if (!this.method_37908().method_8608() && delay < 0)
                    this.burst();
            }

            return;
        }

        boolean disallowedHitBlock = this.isNoClip();

        class_2338 blockpos = this.method_23312();
        class_2680 blockstate = this.method_37908().method_8320(blockpos);
        if (!blockstate.method_26215() && !disallowedHitBlock) {
            class_265 voxelshape = blockstate.method_26220(this.method_37908(), blockpos);
            if (!voxelshape.method_1110()) {
                for (class_238 axisalignedbb : voxelshape.method_1090()) {
                    if (axisalignedbb.method_996(blockpos).method_1006(new class_243(this.method_23317(), this.method_23318(), this.method_23321()))) {
                        this.inGround = true;
                        break;
                    }
                }
            }
        }

        if (this.method_5721()) {
            this.method_5646();
        }

        if (this.inGround && !disallowedHitBlock) {
            if (this.inBlockState != blockstate && this.method_37908().method_18026(this.method_5829().method_1014(0.06D))) {
                // block breaked
                this.burst();
            } else if (!this.method_37908().method_8608()) {
                // onBlock
                this.tryDespawn();
            }
        } else {
            // process pose
            class_243 motionVec = this.method_18798();
            if (this.field_6004 == 0.0F && this.field_5982 == 0.0F) {
                float f = class_3532.method_15355((float) motionVec.method_37268());
                this.method_36456((float) (class_3532.method_15349(motionVec.field_1352, motionVec.field_1350) * (double) (180F / (float) Math.PI)));
                this.method_36457((float) (class_3532.method_15349(motionVec.field_1351, (double) f) * (double) (180F / (float) Math.PI)));
                this.field_5982 = this.method_36454();
                this.field_6004 = this.method_36455();
            }

            // process inAir
            ++this.ticksInAir;
            class_243 positionVec = this.method_19538();
            class_243 movedVec = positionVec.method_1019(motionVec);
            class_239 raytraceresult = this.method_37908().method_17742(
                    new class_3959(positionVec, movedVec, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, this));
            if (raytraceresult.method_17783() != class_239.class_240.field_1333) {
                movedVec = raytraceresult.method_17784();
            }

            while (this.method_5805()) {
                // todo : replace TargetSelector
                class_3966 entityraytraceresult = this.getRayTrace(positionVec, movedVec);
                if (entityraytraceresult != null) {
                    raytraceresult = entityraytraceresult;
                }

                if (raytraceresult != null && raytraceresult.method_17783() == class_239.class_240.field_1331) {
                    class_1297 entity = ((class_3966) raytraceresult).method_17782();
                    class_1297 entity1 = this.getShooter();
                    if (entity instanceof class_1309 && entity1 instanceof class_1309) {
                        if (!TargetSelector.test.method_18419((class_1309) entity1, (class_1309) entity)) {
                            raytraceresult = null;
                            entityraytraceresult = null;
                        }
                    }
                }

                if (raytraceresult != null && !(disallowedHitBlock && raytraceresult.method_17783() == class_239.class_240.field_1332)
                    /*&& !net.minecraftforge.event.ForgeEventFactory.onProjectileImpact(this, raytraceresult)*/) {
                    this.method_7488(raytraceresult);
                    this.field_6007 = true;
                }

                if (entityraytraceresult == null || this.getPierce() <= 0) {
                    break;
                }

                raytraceresult = null;
            }

            motionVec = this.method_18798();
            double mx = motionVec.field_1352;
            double my = motionVec.field_1351;
            double mz = motionVec.field_1350;
            if (this.getIsCritical()) {
                for (int i = 0; i < 4; ++i) {
                    this.method_37908().method_8406(class_2398.field_11205, this.method_23317() + mx * (double) i / 4.0D,
                            this.method_23318() + my * (double) i / 4.0D, this.method_23321() + mz * (double) i / 4.0D, -mx, -my + 0.2D,
                            -mz);
                }
            }

            this.method_5814(this.method_23317() + mx, this.method_23318() + my, this.method_23321() + mz);
            float f4 = class_3532.method_15355((float) motionVec.method_37268());
            if (disallowedHitBlock) {
                this.method_36456((float) (class_3532.method_15349(-mx, -mz) * (double) (180F / (float) Math.PI)));
            } else {
                this.method_36456((float) (class_3532.method_15349(mx, mz) * (double) (180F / (float) Math.PI)));
            }

            for (this.method_36457((float) (class_3532.method_15349(my, (double) f4) * (double) (180F / (float) Math.PI))); this.method_36455()
                    - this.field_6004 < -180.0F; this.field_6004 -= 360.0F) {
                ;
            }

            while (this.method_36455() - this.field_6004 >= 180.0F) {
                this.field_6004 += 360.0F;
            }

            while (this.method_36454() - this.field_5982 < -180.0F) {
                this.field_5982 -= 360.0F;
            }

            while (this.method_36454() - this.field_5982 >= 180.0F) {
                this.field_5982 += 360.0F;
            }

            this.method_36457(class_3532.method_16439(0.2F, this.field_6004, this.method_36455()));
            this.method_36456(class_3532.method_16439(0.2F, this.field_5982, this.method_36454()));
            float f1 = 0.99F;
            if (this.method_5799()) {
                for (int j = 0; j < 4; ++j) {
                    this.method_37908().method_8406(class_2398.field_11247, this.method_23317() - mx * 0.25D, this.method_23318() - my * 0.25D,
                            this.method_23321() - mz * 0.25D, mx, my, mz);
                }
            }

            this.method_18799(motionVec.method_1021((double) f1));
            if (!this.method_5740() && !disallowedHitBlock) {
                class_243 vec3d3 = this.method_18798();
                this.method_18800(vec3d3.field_1352, vec3d3.field_1351 - (double) 0.05F, vec3d3.field_1350);
            }

            // this.setPosition(this.getPosX(), this.getPosY(), this.getPosZ());
            this.method_5852();
        }

        if (!this.method_37908().method_8608() && ticksInGround <= 0 && 100 < this.field_6012)
            this.method_5650(class_5529.field_26999);

    }

    protected void tryDespawn() {
        ++this.ticksInGround;
        if (ON_GROUND_LIFE_TIME <= this.ticksInGround) {
            this.burst();
        }

    }

    protected void method_7488(class_239 raytraceResultIn) {
        class_239.class_240 type = raytraceResultIn.method_17783();
        switch (type) {
            case field_1331:
                this.method_7454((class_3966) raytraceResultIn);
                break;
            case field_1332:
                this.method_24920((class_3965) raytraceResultIn);
                break;
            default:
                break;
        }
    }

    protected void method_24920(class_3965 blockraytraceresult) {
        class_2680 blockstate = this.method_37908().method_8320(blockraytraceresult.method_17777());
        this.inBlockState = blockstate;
        class_243 vec3d = blockraytraceresult.method_17784().method_1023(this.method_23317(), this.method_23318(), this.method_23321());
        this.method_18799(vec3d);
        class_243 vec3d1 = this.method_19538().method_1020(vec3d.method_1029().method_1021((double) 0.05F));
        this.method_5814(vec3d1.field_1352, vec3d1.field_1351, vec3d1.field_1350);
        this.method_5783(this.getHitGroundSound(), 1.0F, 2.2F / (this.field_5974.method_43057() * 0.2F + 0.9F));
        this.inGround = true;
        this.setIsCritical(false);
        this.setPierce((byte) 0);
        this.resetAlreadyHits();
        blockstate.method_26175(this.method_37908(), blockstate, blockraytraceresult, this);
    }

    public void doForceHitEntity(class_1297 target) {
        method_7454(new class_3966(target));
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_1297 targetEntity = entityHitResult.method_17782();
        SlashBladeEvent.SummonedSwordOnHitEntityEvent event = new SlashBladeEvent.SummonedSwordOnHitEntityEvent(this, targetEntity);
        SlashBladeEvent.SUMMONEDSWORD_ONHIT_ENTITY.invoker().onSummonedSwordOnHitEntity(event);
        int i = class_3532.method_15384(this.getDamage());
        if (this.getPierce() > 0) {
            if (this.alreadyHits == null) {
                this.alreadyHits = new IntOpenHashSet(5);
            }

            if (this.alreadyHits.size() >= this.getPierce() + 1) {
                this.burst();
                return;
            }

            this.alreadyHits.add(targetEntity.method_5628());
        }

        if (this.getIsCritical()) {
            i += this.field_5974.method_43048(i / 2 + 2);
        }

        class_1297 shooter = this.getShooter();
        class_1282 damagesource;
        if (shooter == null) {
            damagesource = this.method_48923().method_48815(this, this);
        } else {
            damagesource = this.method_48923().method_48815(this, shooter);
            if (shooter instanceof class_1309) {
                class_1297 hits = targetEntity;
                //if (targetEntity instanceof PartEntity) {
                //    hits = ((PartEntity<?>) targetEntity).getParent();
                //}
                ((class_1309) shooter).method_6114(hits);
            }
        }

        int fireTime = targetEntity.method_20802();
        if (this.method_5809() && !(targetEntity instanceof class_1560)) {
            targetEntity.method_5639(5);
        }

        // todo: attack manager
        targetEntity.field_6008 = 0;
        float scale = 1f;
        if (shooter instanceof class_1309 living) {
            scale = (float) (AttackManager.getSlashBladeDamageScale(living) * SLASHBLADE_DAMAGE_MULTIPLIER.get());
        }
        float damageValue = i * scale;
        if (targetEntity.method_5643(damagesource, damageValue)) {
            class_1297 hits = targetEntity;
            //if (targetEntity instanceof PartEntity) {
            //    hits = ((PartEntity<?>) targetEntity).getParent();
            //}

            if (hits instanceof class_1309) {
                class_1309 targetLivingEntity = (class_1309) hits;

                StunManager.setStun(targetLivingEntity);

                if (!this.method_37908().method_8608() && this.getPierce() <= 0) {
                    setHitEntity(hits);
                }

                if (!this.method_37908().method_8608() && shooter instanceof class_1309) {
                    class_1890.method_8210(targetLivingEntity, shooter);
                    class_1890.method_8213((class_1309) shooter, targetLivingEntity);
                }

                // this.arrowHit(targetLivingEntity);

                affectEntity(targetLivingEntity, getPotionEffects(), 1.0f);

                if (shooter != null && targetLivingEntity != shooter && targetLivingEntity instanceof class_1657
                        && shooter instanceof class_3222) {
                    ((class_3222) shooter).method_17356(this.getHitEntityPlayerSound(), class_3419.field_15248, 0.18F,
                            0.45F);
                }
            }

            this.method_5783(this.getHitEntitySound(), 1.0F, 1.2F / (this.field_5974.method_43057() * 0.2F + 0.9F));
            if (this.getPierce() <= 0 && (getHitEntity() == null || !getHitEntity().method_5805())) {
                this.burst();
            }
        } else {
            targetEntity.method_20803(fireTime);
            // this.setMotion(this.getMotion().scale(-0.1D));
            // this.setYRot(this.getYRot() + 180.0F);
            // this.yRotO += 180.0F;
            this.ticksInAir = 0;
            if (!this.method_37908().method_8608() && this.method_18798().method_1027() < 1.0E-7D) {
                if (getPierce() <= 1)
                    this.burst();
                else
                    this.setPierce((byte) (getPierce() - 1));
            }
        }

    }

    public int getColor() {
        return this.method_5841().method_12789(COLOR);
    }

    public void setColor(int value) {
        this.method_5841().method_12778(COLOR, value);
    }

    public byte getPierce() {
        return this.method_5841().method_12789(PIERCE);
    }

    public void setPierce(byte value) {
        this.method_5841().method_12778(PIERCE, (byte) value);
    }

    public int getDelay() {
        return this.method_5841().method_12789(DELAY);
    }

    public void setDelay(int value) {
        this.method_5841().method_12778(DELAY, value);
    }

    @Nullable
    protected class_3966 getRayTrace(class_243 p_213866_1_, class_243 p_213866_2_) {
        return class_1675.method_18077(this.method_37908(), this, p_213866_1_, p_213866_2_,
                this.method_5829().method_18804(this.method_18798()).method_1014(1.0D), (entity) -> {
                    return entity.method_49108() && !entity.method_7325()
                            && (entity != this.getShooter() || this.ticksInAir >= 5)
                            && (this.alreadyHits == null || !this.alreadyHits.contains(entity.method_5628()));
                });
    }

    @Nullable
    @Override
    public class_1297 getShooter() {
        return this.method_24921();
    }

    @Override
    public void setShooter(class_1297 shooter) {
        method_7432(shooter);
    }

    public List<class_1293> getPotionEffects() {
        List<class_1293> effects = class_1844.method_8066(((EntityExtension) this).sb$getPersistentData());

        if (effects.isEmpty())
            effects.add(new class_1293(class_1294.field_5899, 1, 1));

        return effects;
    }

    public void burst() {
        this.method_5783(class_3417.field_15081, 1.0F, 1.2F / (this.field_5974.method_43057() * 0.2F + 0.9F));

        if (!this.method_37908().method_8608()) {
            if (this.method_37908() instanceof class_3218)
                ((class_3218) this.method_37908()).method_14199(class_2398.field_11205, this.method_23317(), this.method_23318(), this.method_23321(),
                        16, 0.5, 0.5, 0.5, 0.25f);

            this.burst(getPotionEffects(), null);
        }

        super.method_5650(class_5529.field_26999);
    }

    public void burst(List<class_1293> effects, @Nullable class_1297 focusEntity) {
        // AABB axisalignedbb = this.getBoundingBox().inflate(4.0D, 2.0D, 4.0D);
        List<class_1297> list = TargetSelector.getTargettableEntitiesWithinAABB(this.method_37908(), 2, this);
        // this.world.getEntitiesWithinAABB(LivingEntity.class, axisalignedbb);

        list.stream().filter(e -> e instanceof class_1309).map(e -> (class_1309) e).forEach(e -> {
            double distanceSq = this.method_5858(e);
            if (distanceSq < 9.0D) {
                double factor = 1.0D - Math.sqrt(distanceSq) / 4.0D;
                if (e == focusEntity) {
                    factor = 1.0D;
                }

                affectEntity(e, effects, factor);
            }
        });
    }

    public void affectEntity(class_1309 focusEntity, List<class_1293> effects, double factor) {
        for (class_1293 effectinstance : getPotionEffects()) {
            class_1291 effect = effectinstance.method_5579();
            if (effect.method_5561()) {
                effect.method_5564(this, this.getShooter(), focusEntity, effectinstance.method_5578(),
                        factor);
            } else {
                int duration = (int) (factor * (double) effectinstance.method_5584() + 0.5D);
                if (duration > 0) {
                    focusEntity.method_6092(new class_1293(effect, duration, effectinstance.method_5578(),
                            effectinstance.method_5591(), effectinstance.method_5581()));
                }
            }
        }
    }

    public void resetAlreadyHits() {
        if (this.alreadyHits != null)
            alreadyHits.clear();
    }

    public void setHitEntity(class_1297 hitEntity) {
        if (hitEntity != this) {
            this.field_6011.method_12778(HIT_ENTITY_ID, hitEntity.method_5628());

            this.field_6011.method_12778(OFFSET_YAW, this.field_5974.method_43057() * 360);

            this.setDelay(20 * 5);
        }
    }

    @Nullable
    public class_1297 getHitEntity() {
        if (hitEntity == null) {
            int id = this.field_6011.method_12789(HIT_ENTITY_ID);
            if (0 <= id) {
                hitEntity = this.method_37908().method_8469(id);
            }
        }
        return hitEntity;
    }

    public float getOffsetYaw() {
        return this.field_6011.method_12789(OFFSET_YAW);
    }

    public float getRoll() {
        return this.field_6011.method_12789(ROLL);
    }

    public void setRoll(float value) {
        this.field_6011.method_12778(ROLL, value);
    }

    public void setDamage(double damageIn) {
        this.damage = damageIn;
    }

    @Override
    public double getDamage() {
        return this.damage;
    }

    private static final String defaultModelName = "slashblade:model/util/ss";

    public void setModelName(String name) {
        this.field_6011.method_12778(MODEL, Optional.ofNullable(name).orElse(defaultModelName));
    }

    public String getModelName() {
        String name = this.field_6011.method_12789(MODEL);
        if (name == null || name.length() == 0) {
            name = defaultModelName;
        }
        return name;
    }

    private static final class_2960 defaultModel = new class_2960(defaultModelName + ".obj");
    public class_2960 modelLoc = new class_2960(getModelName() + ".obj");
    private static final class_2960 defaultTexture = new class_2960(defaultModelName + ".png");
    public class_2960 textureLoc = new class_2960(getModelName() + ".png");

    public class_2960 getModelLoc() {
        return modelLoc != null ? modelLoc : defaultModel;
    }

    public class_2960 getTextureLoc() {
        return textureLoc != null ? textureLoc : defaultTexture;
    }

    @Override
    public void method_5697(class_1297 entityIn) {
        // Suppress velocity change due to collision
        // super.applyEntityCollision(entityIn);
    }

    // todo: 射撃攻撃との相殺 pierce値＝HPにした近接攻撃との相殺
}
