package mods.flammpfeil.slashblade.util;

import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3959;
import net.minecraft.class_3966;
import java.util.Optional;
import java.util.function.Predicate;

public class RayTraceHelper {

    public static Optional<class_239> rayTrace(class_1937 worldIn, class_1297 entityIn, class_243 start, class_243 dir, double blockReach,
            double entityReach, Predicate<class_1297> selector) {
        class_243 end = start.method_1019(dir.method_1021(blockReach));

        class_239 raytraceresult = worldIn
                .method_17742(new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, entityIn));
        if (raytraceresult.method_17783() != class_239.class_240.field_1333) {
            end = raytraceresult.method_17784();
            entityReach = start.method_1022(end);
        } else {
            end = start.method_1019(dir.method_1021(entityReach));
        }

        class_238 area = entityIn.method_5829().method_18804(dir.method_1021(entityReach)).method_1014(1.0D);
        class_3966 entityraytraceresult = rayTrace(worldIn, entityIn, start, end, area, selector);

        if (entityraytraceresult != null) {
            raytraceresult = entityraytraceresult;
        }

        return Optional.ofNullable(raytraceresult);
    }

    @Nullable
    public static class_3966 rayTrace(class_1937 worldIn, class_1297 entityIn, class_243 start, class_243 end, class_238 boundingBox,
            Predicate<class_1297> selector) {
        return rayTrace(worldIn, entityIn, start, end, boundingBox, selector, Double.MAX_VALUE);
    }

    @Nullable
    public static class_3966 rayTrace(class_1937 worldIn, class_1297 entityIn, class_243 start, class_243 end, class_238 boundingBox,
            Predicate<class_1297> selector, double limitDist) {
        double currentDist = limitDist;
        class_1297 resultEntity = null;

        for (class_1297 foundEntity : worldIn.method_8333(entityIn, boundingBox, selector)) {
            class_238 axisalignedbb = foundEntity.method_5829().method_1014((double) 0.5F);
            Optional<class_243> optional = axisalignedbb.method_992(start, end);
            if (optional.isPresent()) {
                double newDist = start.method_1025(optional.get());
                if (newDist < currentDist) {
                    resultEntity = foundEntity;
                    currentDist = newDist;
                }
            }
        }

        if (resultEntity == null) {
            return null;
        } else {
            return new class_3966(resultEntity);
        }
    }
}
