package mods.flammpfeil.slashblade.ability;

import cn.sh1rocu.slashblade.api.extension.EntityExtension;
import io.github.fabricators_of_create.porting_lib.entity.events.tick.PlayerTickEvent;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.event.handler.InputCommandEvent;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import mods.flammpfeil.slashblade.util.InputCommand;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2388;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2743;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4051;
import java.util.EnumSet;

public class KickJump {
    private static final class SingletonHolder {
        private static final KickJump instance = new KickJump();
    }

    public static KickJump getInstance() {
        return SingletonHolder.instance;
    }

    private KickJump() {
    }

    public void register() {
        InputCommandEvent.CALLBACK.register(this::onInputChange);
        PlayerTickEvent.Pre.EVENT.register(this::onTick);
    }

    static final class_4051 tc = new class_4051(false).method_36627()
            .method_18424();

    public static final class_2960 ADVANCEMENT_KICK_JUMP = class_2960.method_60655(SlashBlade.MODID,
            "abilities/kick_jump");

    public static final String KEY_KICKJUMP = "sb.kickjump";

    public void onInputChange(InputCommandEvent event) {

        EnumSet<InputCommand> old = event.getOld();
        EnumSet<InputCommand> current = event.getCurrent();
        class_3222 sender = event.getEntity();
        class_1937 worldIn = sender.method_37908();

        if (sender.method_24828())
            return;
        if (old.contains(InputCommand.JUMP))
            return;
        if (!current.contains(InputCommand.JUMP))
            return;

        if (0 != ((EntityExtension) sender).sb$getPersistentData().method_10550(KEY_KICKJUMP))
            return;

        Iterable<class_265> list = worldIn.method_20812(sender, sender.method_5829().method_1009(0.5, 0, 1));
        if (!list.iterator().hasNext())
            return;

        // 保存当前疾跑状态
        boolean wasSprinting = sender.method_5624();

        // execute
        Untouchable.setUntouchable(sender, Untouchable.JUMP_TICKS);

        // set cooldown
        ((EntityExtension) sender).sb$getPersistentData().method_10569(KEY_KICKJUMP, 2);

        class_243 delta = sender.method_18798();
        class_243 motion = new class_243(delta.field_1352, +0.8, delta.field_1350);

        sender.method_5784(class_1313.field_6308, motion);

        //疾跑时保持水平动量，非疾跑时保持原缩放
        class_243 adjustedMotion = wasSprinting
                ? new class_243(motion.field_1352, motion.field_1351 * 0.75f, motion.field_1350) // 只缩放垂直分量
                : motion.method_1021(0.75f);                           // 整体缩放

        sender.field_13987.method_14364(new class_2743(sender.method_5628(), adjustedMotion));

        //强制恢复疾跑状态
        if (wasSprinting) {
            sender.method_5728(true);
        }

        AdvancementHelper.grantCriterion(sender, ADVANCEMENT_KICK_JUMP);
        sender.method_17356(class_3417.field_14778, class_3419.field_15248, 0.5f, 1.2f);

        CapabilitySlashBlade.getBladeState(sender.method_6047()).ifPresent(s -> {
            s.updateComboSeq(sender, ComboStateRegistry.getId(ComboStateRegistry.NONE));
        });

        if (worldIn instanceof class_3218) {
            ((class_3218) worldIn).method_14199(
                    new class_2388(class_2398.field_11217, class_2246.field_10033.method_9564()), sender.method_23317(),
                    sender.method_23318(), sender.method_23321(), 20, 0.0D, 0.0D, 0.0D, 0.15F);
        }
    }

    public void onTick(PlayerTickEvent.Pre event) {
        class_1309 player = event.getEntity();
        // cooldown
        if (player.method_24828() && 0 < ((EntityExtension) player).sb$getPersistentData().method_10550(KEY_KICKJUMP)) {

            int count = ((EntityExtension) player).sb$getPersistentData().method_10550(KEY_KICKJUMP);
            count--;

            if (count <= 0) {
                ((EntityExtension) player).sb$getPersistentData().method_10551(KEY_KICKJUMP);
            } else {
                ((EntityExtension) player).sb$getPersistentData().method_10569(KEY_KICKJUMP, count);
            }
        }
    }
}