package mods.flammpfeil.slashblade.client.renderer;

import cn.sh1rocu.slashblade.api.event.LivingEntityRenderEvents;
import cn.sh1rocu.slashblade.mixin.accessor.EntityRendererAccessor;
import mods.flammpfeil.slashblade.capability.inputstate.CapabilityInputState;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.util.InputCommand;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_922;
import java.awt.*;
import java.util.Optional;

public class LockonCircleRender {
    private static final class SingletonHolder {
        private static final LockonCircleRender instance = new LockonCircleRender();
    }

    public static LockonCircleRender getInstance() {
        return SingletonHolder.instance;
    }

    private LockonCircleRender() {
    }

    public void register() {
        LivingEntityRenderEvents.PRE.register((class_1309 entity, class_922<?, ?> renderer, float partialRenderTick, class_4587 matrixStack, class_4597 buffers, int light) -> {
            this.onRenderLiving(entity, renderer, partialRenderTick, matrixStack, buffers, light);
            return false;
        });
        LivingEntityRenderEvents.POST.register(this::onRenderLiving);
    }

    static final class_2960 modelLoc = class_2960.method_60655("slashblade", "model/util/lockon.obj");
    static final class_2960 textureLoc = class_2960.method_60655("slashblade", "model/util/lockon.png");

    public void onRenderLiving(class_1309 livingEntity, class_922<?, ?> renderer, float partialTicks, class_4587 poseStack, class_4597 buffer, int light) {
        final class_310 minecraftInstance = class_310.method_1551();
        class_1657 player = minecraftInstance.field_1724;
        if (player == null)
            return;
        if (CapabilityInputState.INPUT_STATE.maybeGet(player)
                .filter(input -> input.getCommands().contains(InputCommand.SNEAK)).isEmpty())
            return;

        class_1799 stack = player.method_6047();
        class_1937 level = player.method_37908();
        Optional<Color> effectColor = CapabilitySlashBlade.getBladeState(stack)
                .filter(s -> livingEntity.equals(s.getTargetEntity(level))).map(ISlashBladeState::getEffectColor);

        if (effectColor.isEmpty())
            return;

        if (!livingEntity.method_5805())
            return;

        float health = livingEntity.method_6032() / livingEntity.method_6063();

        Color col = new Color(effectColor.get().getRGB() & 0xFFFFFF | 0xAA000000, true);

        float f = livingEntity.method_17682() * 0.5f;

        poseStack.method_22903();
        poseStack.method_22904(0.0D, f, 0.0D);

        class_243 offset = ((EntityRendererAccessor) renderer).sb$getEntityRenderDispatcher().field_4686.method_19326()
                .method_1020(livingEntity.method_30950(partialTicks).method_1031(0, f, 0));
        offset = offset.method_1021(0.5f);
        poseStack.method_22904(offset.method_10216(), offset.method_10214(), offset.method_10215());

        poseStack.method_22907(((EntityRendererAccessor) renderer).sb$getEntityRenderDispatcher().method_24197());
        // poseStack.scale(-0.025F, -0.025F, 0.025F);

        float scale = 0.0025f;
        poseStack.method_22905(scale, -scale, scale);

        WavefrontObject model = BladeModelManager.getInstance().getModel(modelLoc);
        class_2960 resourceTexture = textureLoc;

        final String base = "lockonBase";
        final String mask = "lockonHealthMask";
        final String value = "lockonHealth";

        BladeRenderState.setCol(col);
        BladeRenderState.renderOverridedLuminous(class_1799.field_8037, model, base, resourceTexture, poseStack, buffer,
                BladeRenderState.MAX_LIGHT);
        {
            poseStack.method_22903();
            poseStack.method_46416(0, 0, health * 10.0f);
            BladeRenderState.setCol(new Color(0x20000000, true));
            BladeRenderState.renderOverridedLuminousDepthWrite(class_1799.field_8037, model, mask, resourceTexture, poseStack,
                    buffer, BladeRenderState.MAX_LIGHT);
            poseStack.method_22909();
        }
        BladeRenderState.setCol(col);
        BladeRenderState.renderOverridedLuminousDepthWrite(class_1799.field_8037, model, value, resourceTexture, poseStack,
                buffer, BladeRenderState.MAX_LIGHT);

        poseStack.method_22909();
    }
}
