package mods.flammpfeil.slashblade.client.renderer.entity;

import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank.ConcentrationRanks;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.Face;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import mods.flammpfeil.slashblade.entity.EntitySlashEffect;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import javax.annotation.Nullable;

@Environment(EnvType.CLIENT)
public class SlashEffectRenderer<T extends EntitySlashEffect> extends class_897<T> {

    static private final class_2960 modelLocation = class_2960.method_60655(SlashBlade.MODID,
            "model/util/slash.obj");
    static private final class_2960 textureLocation = class_2960.method_60655(SlashBlade.MODID,
            "model/util/slash.png");

    @Nullable
    @Override
    public class_2960 getTextureLocation(T entity) {
        return textureLocation;
    }

    public SlashEffectRenderer(class_5617.class_5618 context) {
        super(context);
    }

    @Override
    public void render(T entity, float entityYaw, float partialTicks, class_4587 matrixStackIn,
                       class_4597 bufferIn, int packedLightIn) {

        try (MSAutoCloser msac = MSAutoCloser.pushMatrix(matrixStackIn)) {

            matrixStackIn
                    .method_22907(class_7833.field_40716.rotationDegrees(-class_3532.method_16439(partialTicks, entity.field_5982, entity.method_36454()) - 90.0F));
            matrixStackIn.method_22907(class_7833.field_40718.rotationDegrees(class_3532.method_16439(partialTicks, entity.field_6004, entity.method_36455())));
            matrixStackIn.method_22907(class_7833.field_40714.rotationDegrees(entity.getRotationRoll()));

            WavefrontObject model = BladeModelManager.getInstance().getModel(modelLocation);

            int lifetime = entity.getLifetime();

            float progress = Math.min(lifetime, (entity.field_6012 + partialTicks)) / lifetime;

            double deathTime = lifetime;
            // double baseAlpha = Math.sin(Math.PI * 0.5 * (Math.min(deathTime, Math.max(0,
            // (lifetime - (entity.ticksExisted) - partialTicks))) / deathTime));
            double baseAlpha = (Math.min(deathTime, Math.max(0, (lifetime - (entity.field_6012) - partialTicks)))
                    / deathTime);
            baseAlpha = -Math.pow(baseAlpha - 1, 4.0) + 1.0;

            // baseAlpha = Math.sin(-Math.PI + Math.PI * 2 * progress) * 0.5f + 0.5f;
            // baseAlpha = Math.sin(Math.PI * progress);

            // time
            matrixStackIn.method_22907(class_7833.field_40716.rotationDegrees(entity.getRotationOffset() - 135.0F * progress));

            matrixStackIn.method_22905(1, 0.25f, 1);

            float baseScale = 1.2f;
            matrixStackIn.method_22905(baseScale, baseScale, baseScale);

            float yscale = 0.03f;
            float scale = entity.getBaseSize() * class_3532.method_16439(progress, 0.03f, 0.035f);

            int color = entity.getColor() & 0xFFFFFF;

            ConcentrationRanks rank = entity.getRankCode();

            // rank color overwrite
            if (rank.level < ConcentrationRanks.C.level) {
                color = 0x555555;
            }

            class_2960 rl = getTextureLocation(entity);

            // baseAlpha = 1.0f;
            int alpha = ((0xFF & (int) (0xFF * baseAlpha)) << 24);

            // black alpha insidee
            if (ConcentrationRanks.S.level <= rank.level)
                try (MSAutoCloser msacb = MSAutoCloser.pushMatrix(matrixStackIn)) {
                    float windscale = entity.getBaseSize() * class_3532.method_16439(progress, 0.035f, 0.03f);
                    matrixStackIn.method_22905(windscale, yscale, windscale);
                    Face.setAlphaOverride(Face.alphaOverrideYZZ);
                    Face.setUvOperator(1, 1, 0, -0.8f + progress * 0.3f);
                    BladeRenderState.setCol(0x222222 | alpha);
                    BladeRenderState.renderOverridedColorWrite(class_1799.field_8037, model, "base", rl, matrixStackIn,
                            bufferIn, packedLightIn);
                }

            // color alpha base
            if (ConcentrationRanks.D.level <= rank.level)
                try (MSAutoCloser msacb = MSAutoCloser.pushMatrix(matrixStackIn)) {
                    matrixStackIn.method_22905(scale, yscale, scale);
                    Face.setAlphaOverride(Face.alphaOverrideYZZ);
                    Face.setUvOperator(1, 1, 0, -0.35f + progress * -0.15f);
                    BladeRenderState.setCol(color | alpha);
                    BladeRenderState.renderOverridedColorWrite(class_1799.field_8037, model, "base", rl, matrixStackIn,
                            bufferIn, packedLightIn);
                }

            // white add outside
            if (ConcentrationRanks.B.level <= rank.level)
                try (MSAutoCloser msacb = MSAutoCloser.pushMatrix(matrixStackIn)) {
                    float windscale = entity.getBaseSize() * class_3532.method_16439(progress, 0.03f, 0.0375f);
                    matrixStackIn.method_22905(windscale, yscale, windscale);
                    Face.setAlphaOverride(Face.alphaOverrideYZZ);
                    Face.setUvOperator(1, 1, 0, -0.5f + progress * -0.2f);
                    BladeRenderState.setCol(0x404040 | alpha);
                    BladeRenderState.renderOverridedLuminous(class_1799.field_8037, model, "base", rl, matrixStackIn,
                            bufferIn, packedLightIn);
                }

            // color add base
            try (MSAutoCloser msacb = MSAutoCloser.pushMatrix(matrixStackIn)) {
                matrixStackIn.method_22905(scale, yscale, scale);
                Face.setAlphaOverride(Face.alphaOverrideYZZ);
                Face.setUvOperator(1, 1, 0, -0.35f + progress * -0.15f);
                BladeRenderState.setCol(color | alpha);
                BladeRenderState.renderOverridedLuminous(class_1799.field_8037, model, "base", rl, matrixStackIn, bufferIn,
                        packedLightIn);
            }
        }
    }
}