package mods.flammpfeil.slashblade.client.renderer.entity;

import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import mods.flammpfeil.slashblade.entity.EntityAbstractSummonedSword;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import javax.annotation.Nullable;

@Environment(EnvType.CLIENT)
public class SummonedSwordRenderer<T extends EntityAbstractSummonedSword> extends class_897<T> {

    @Nullable
    @Override
    public class_2960 getTextureLocation(T entity) {
        return entity.getTextureLoc();
    }

    public SummonedSwordRenderer(class_5617.class_5618 context) {
        super(context);
    }

    @Override
    public void render(T entity, float entityYaw, float partialTicks, class_4587 matrixStack, class_4597 bufferIn,
                       int packedLightIn) {

        try (MSAutoCloser msac = MSAutoCloser.pushMatrix(matrixStack)) {
            class_1297 hits = entity.getHitEntity();
            boolean hasHitEntity = hits != null;

            if (hasHitEntity) {
                matrixStack
                        .method_22907(class_7833.field_40715.rotationDegrees(class_3532.method_17821(partialTicks, hits.field_5982, hits.method_36454()) - 90));
                matrixStack.method_22907(class_7833.field_40715.rotationDegrees(entity.getOffsetYaw()));
            } else {
                matrixStack.method_22907(
                        class_7833.field_40716.rotationDegrees(class_3532.method_17821(partialTicks, entity.field_5982, entity.method_36454()) - 90.0F));
            }

            matrixStack.method_22907(class_7833.field_40718.rotationDegrees(class_3532.method_17821(partialTicks, entity.field_6004, entity.method_36455())));

            matrixStack.method_22907(class_7833.field_40714.rotationDegrees(entity.getRoll()));

            float scale = 0.0075f;
            matrixStack.method_22905(scale, scale, scale);
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(90.0F));

            if (hasHitEntity) {
                matrixStack.method_46416(0, 0, -100);
            }

            // matrixStack.blendEquation(GL14.GL_FUNC_REVERSE_SUBTRACT);
            WavefrontObject model = BladeModelManager.getInstance().getModel(entity.getModelLoc());
            BladeRenderState.setCol(entity.getColor(), false);
            BladeRenderState.renderOverridedLuminous(class_1799.field_8037, model, "ss", getTextureLocation(entity),
                    matrixStack, bufferIn, packedLightIn);
        }
    }
}