package mods.flammpfeil.slashblade.entity;

import cn.sh1rocu.slashblade.api.extension.EntityExtension;
import cn.sh1rocu.slashblade.util.PotionUtils;
import mods.flammpfeil.slashblade.init.SBEntityTypes;
import mods.flammpfeil.slashblade.util.*;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1675;
import net.minecraft.class_1937;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3966;
import javax.annotation.Nullable;
import java.util.EnumSet;
import java.util.List;

public class EntityJudgementCut extends Projectile implements IShootable {
    private static final class_2940<Integer> COLOR = class_2945
            .method_12791(EntityJudgementCut.class, class_2943.field_13327);
    private static final class_2940<Integer> FLAGS = class_2945
            .method_12791(EntityJudgementCut.class, class_2943.field_13327);
    private static final class_2940<Float> RANK = class_2945.method_12791(EntityJudgementCut.class,
            class_2943.field_13320);

    private int lifetime = 10;
    private int seed = -1;

    private double damage = 1.0D;

    private boolean cycleHit = false;

    public int getSeed() {
        return seed;
    }

    public boolean doCycleHit() {
        return cycleHit;
    }

    public void setCycleHit(boolean cycleHit) {
        this.cycleHit = cycleHit;
    }

    private final class_3414 livingEntitySound = class_3417.field_14688;

    protected class_3414 getHitEntitySound() {
        return this.livingEntitySound;
    }

    public EntityJudgementCut(class_1299<? extends Projectile> entityTypeIn, class_1937 worldIn) {
        super(entityTypeIn, worldIn);
        this.method_5875(true);
        // this.setGlowing(true);

        this.seed = this.field_5974.method_43048(360);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(COLOR, 0x3333FF);
        builder.method_56912(FLAGS, 0);
        builder.method_56912(RANK, 0.0f);
    }

    @Override
    protected void method_5652(class_2487 compound) {
        super.method_5652(compound);

        NBTHelper.getNBTCoupler(compound).put("Color", this.getColor()).put("Rank", this.getRank())
                .put("damage", this.damage).put("crit", this.getIsCritical()).put("clip", this.isNoClip())
                .put("Lifetime", this.getLifetime());
    }

    @Override
    protected void method_5749(class_2487 compound) {
        super.method_5749(compound);

        NBTHelper.getNBTCoupler(compound).get("Color", this::setColor).get("Rank", this::setRank)
                .get("damage", ((Double v) -> this.damage = v), this.damage).get("crit", this::setIsCritical)
                .get("clip", this::setNoClip).get("Lifetime", this::setLifetime);
    }

    @Override
    public void method_7485(double x, double y, double z, float velocity, float inaccuracy) {
        this.method_18800(0, 0, 0);
    }

    @Override
    @Environment(EnvType.CLIENT)
    public boolean method_5640(double distance) {
        double d0 = this.method_5829().method_995() * 10.0D;
        if (Double.isNaN(d0)) {
            d0 = 1.0D;
        }

        d0 = d0 * 64.0D * method_5824();
        return distance < d0 * d0;
    }

    @Override
    @Environment(EnvType.CLIENT)
    public void method_5759(double x, double y, double z, float yaw, float pitch, int i) {
        this.method_5814(x, y, z);
        this.method_5710(yaw, pitch);
    }

    @Override
    @Environment(EnvType.CLIENT)
    public void method_5750(double x, double y, double z) {
        this.method_18800(0, 0, 0);
    }

    enum FlagsState {
        Critical, NoClip,
    }

    EnumSet<FlagsState> flags = EnumSet.noneOf(FlagsState.class);
    int intFlags = 0;

    private void setFlags(FlagsState value) {
        this.flags.add(value);
        refreshFlags();
    }

    private void removeFlags(FlagsState value) {
        this.flags.remove(value);
        refreshFlags();
    }

    private void refreshFlags() {
        if (this.method_37908().method_8608()) {
            int newValue = this.field_6011.method_12789(FLAGS).intValue();
            if (intFlags != newValue) {
                intFlags = newValue;
                flags = EnumSetConverter.convertToEnumSet(FlagsState.class, intFlags);
            }
        } else {
            int newValue = EnumSetConverter.convertToInt(this.flags);
            if (this.intFlags != newValue) {
                this.field_6011.method_12778(FLAGS, newValue);
                this.intFlags = newValue;
            }
        }
    }

    public void setIsCritical(boolean value) {
        if (value)
            setFlags(FlagsState.Critical);
        else
            removeFlags(FlagsState.Critical);
    }

    public boolean getIsCritical() {
        refreshFlags();
        return flags.contains(FlagsState.Critical);
    }

    public void setNoClip(boolean value) {
        this.field_5960 = value;
        if (value)
            setFlags(FlagsState.NoClip);
        else
            removeFlags(FlagsState.NoClip);
    }

    // disallowedHitBlock
    public boolean isNoClip() {
        if (!this.method_37908().method_8608()) {
            return this.field_5960;
        } else {
            refreshFlags();
            return flags.contains(FlagsState.NoClip);
        }
    }

    @Override
    public void method_5773() {
        super.method_5773();

        if (field_6012 < 8 && field_6012 % 2 == 0) {
            this.method_5783(getHitEntitySound(), 0.2F, 0.5F + 0.25f * this.field_5974.method_43057());
        }

        if (this.getShooter() != null) {

            // cyclehit
            if (this.field_6012 % 2 == 0) {
                KnockBacks knockBackType = getIsCritical() ? KnockBacks.toss : KnockBacks.cancel;
                AttackManager.areaAttack(this, knockBackType.action, 4.0, true, false, 0.16f, null);
            }

            final int count = 3;
            if (getIsCritical() && 0 < field_6012 && field_6012 <= count) {
                EntitySlashEffect jc = new EntitySlashEffect(SBEntityTypes.SlashEffect, this.method_37908());
                jc.method_5641(this.method_23317(), this.method_23318(), this.method_23321(), (360.0f / count) * field_6012 + this.seed, 0);
                jc.setRotationRoll(30);

                jc.method_7432(this.getShooter());

                jc.setMute(false);
                jc.setIsCritical(true);

                jc.setDamage(0.1F);

                jc.setColor(this.getColor());
                jc.setBaseSize(0.5f);

                jc.setKnockBack(KnockBacks.cancel);

                jc.setIndirect(true);

                jc.setRank(this.getRank());

                this.method_37908().method_8649(jc);
            }
        }

        tryDespawn();

    }

    protected void tryDespawn() {
        if (!this.method_37908().method_8608()) {
            if (getLifetime() < this.field_6012) {
                this.burst();
            }
        }
    }

    /*
     * protected void onHitEntity(EntityRayTraceResult p_213868_1_) { Entity
     * targetEntity = p_213868_1_.getEntity(); float f =
     * (float)this.getMotion().length(); int i = MathHelper.ceil(Math.max((double)f
     * * this.damage, 0.0D));
     *
     * if (this.getIsCritical()) { i += this.rand.nextInt(i / 2 + 2); }
     *
     * Entity shooter = this.getShooter(); DamageSource damagesource; if (shooter ==
     * null) { damagesource = CustomDamageSource.causeSummonedSwordDamage(this,
     * this); } else { damagesource =
     * CustomDamageSource.causeSummonedSwordDamage(this, shooter); if (shooter
     * instanceof LivingEntity) {
     * ((LivingEntity)shooter).setLastAttackedEntity(targetEntity); } }
     *
     * int fireTime = targetEntity.getRemainingFireTicks(); if (this.isBurning() &&
     * !(targetEntity instanceof EndermanEntity)) { targetEntity.setFire(5); }
     *
     * if (targetEntity.attackEntityFrom(damagesource, (float)i)) { if (targetEntity
     * instanceof LivingEntity) { LivingEntity targetLivingEntity =
     * (LivingEntity)targetEntity;
     *
     * if (!this.world.isRemote && shooter instanceof LivingEntity) {
     * EnchantmentHelper.applyThornEnchantments(targetLivingEntity, shooter);
     * EnchantmentHelper.applyArthropodEnchantments((LivingEntity)shooter,
     * targetLivingEntity); }
     *
     * //this.arrowHit(targetLivingEntity);
     *
     * affectEntity(targetLivingEntity, getPotionEffects(), 1.0f);
     *
     * if (shooter != null && targetLivingEntity != shooter && targetLivingEntity
     * instanceof PlayerEntity && shooter instanceof ServerPlayerEntity) {
     * ((ServerPlayerEntity)
     * shooter).playNotifySound(this.getHitEntityPlayerSound(),
     * SoundCategory.PLAYERS, 0.18F, 0.45F); } }
     *
     * this.playSound(this.getHitEntitySound(), 1.0F, 1.2F / (this.rand.nextFloat()
     * * 0.2F + 0.9F)); } else { targetEntity.func_223308_g(fireTime);
     * this.setMotion(this.getMotion().scale(-0.1D)); this.rotationYaw += 180.0F;
     * this.prevRotationYaw += 180.0F; if (!this.world.isRemote &&
     * this.getMotion().lengthSquared() < 1.0E-7D) { this.burst(); } }
     *
     * }
     */

    public int getColor() {
        return this.method_5841().method_12789(COLOR);
    }

    public void setColor(int value) {
        this.method_5841().method_12778(COLOR, value);
    }

    public float getRank() {
        return this.method_5841().method_12789(RANK);
    }

    public void setRank(float value) {
        this.method_5841().method_12778(RANK, value);
    }

    public int getLifetime() {
        return Math.min(this.lifetime, 1000);
    }

    public void setLifetime(int value) {
        this.lifetime = value;
    }

    @Nullable
    @Override
    public class_1297 getShooter() {
        return this.method_24921();
    }

    @Override
    public void setShooter(class_1297 shooter) {
        method_7432(shooter);
    }

    public List<class_1293> getPotionEffects() {
        List<class_1293> effects = PotionUtils.getAllEffects(((EntityExtension) this).sb$getPersistentData());

        if (effects.isEmpty())
            effects.add(new class_1293(class_1294.field_5899, 1, 1));

        return effects;
    }

    public void burst() {
        // this.playSound(SoundEvents.BLOCK_GLASS_BREAK, 1.0F, 1.2F /
        // (this.rand.nextFloat() * 0.2F + 0.9F));

        if (!this.method_37908().method_8608()) {
            if (this.method_37908() instanceof class_3218)
                ((class_3218) this.method_37908()).method_14199(class_2398.field_11205, this.method_23317(), this.method_23318(), this.method_23321(),
                        16, 0.5, 0.5, 0.5, 0.25f);

            this.burst(getPotionEffects(), null);
        }

        super.method_5650(class_5529.field_26999);
    }

    public void burst(List<class_1293> effects, @Nullable class_1297 focusEntity) {
        // AABB axisalignedbb = this.getBoundingBox().inflate(4.0D, 2.0D, 4.0D);
        List<class_1297> list = TargetSelector.getTargettableEntitiesWithinAABB(this.method_37908(), 2, this);
        // this.world.getEntitiesWithinAABB(LivingEntity.class, axisalignedbb);

        list.stream().filter(e -> e instanceof class_1309).map(e -> (class_1309) e).forEach(e -> {
            double distanceSq = this.method_5858(e);
            if (distanceSq < 9.0D) {
                double factor = 1.0D - Math.sqrt(distanceSq) / 4.0D;
                if (e == focusEntity) {
                    factor = 1.0D;
                }

                affectEntity(e, effects, factor);
            }
        });
    }

    public void affectEntity(class_1309 focusEntity, List<class_1293> effects, double factor) {
        for (class_1293 effectinstance : getPotionEffects()) {
            var holder = effectinstance.method_5579();
            class_1291 effect = holder.comp_349();
            if (effect.method_5561()) {
                effect.method_5564(this, this.getShooter(), focusEntity, effectinstance.method_5578(),
                        factor);
            } else {
                int duration = (int) (factor * (double) effectinstance.method_5584() + 0.5D);
                if (duration > 0) {
                    focusEntity.method_6092(new class_1293(holder, duration, effectinstance.method_5578(),
                            effectinstance.method_5591(), effectinstance.method_5581()));
                }
            }
        }
    }

    public void setDamage(double damageIn) {
        this.damage = damageIn;
    }

    @Override
    public double getDamage() {
        return this.damage;
    }

    @Nullable
    public class_3966 getRayTrace(class_243 p_213866_1_, class_243 p_213866_2_) {
        return class_1675.method_18077(this.method_37908(), this, p_213866_1_, p_213866_2_,
                this.method_5829().method_18804(this.method_18798()).method_1014(1.0D), (p_213871_1_) -> {
                    return !p_213871_1_.method_7325() && p_213871_1_.method_5805() && p_213871_1_.method_5863()
                            && (p_213871_1_ != this.getShooter());
                });
    }
}
