package mods.flammpfeil.slashblade.recipe;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.init.SBItems;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_6885;
import net.minecraft.class_6898;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.List;
import java.util.Set;

public record SlashBladeIngredient(class_6885<class_1792> items, RequestDefinition request) implements CustomIngredient {
    public static final Codec<class_6885<class_1792>> ITEM_HOLDER_SET_CODEC = class_6898.method_40388(class_7924.field_41197, class_7923.field_41178.method_40294(), false);

    public static final MapCodec<SlashBladeIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group(
            ITEM_HOLDER_SET_CODEC.fieldOf("items").forGetter(ingredient -> ingredient.items),
            RequestDefinition.CODEC.fieldOf("request").forGetter(ingredient -> ingredient.request)
    ).apply(builder, SlashBladeIngredient::new));

    public static final class_9139<class_9129, SlashBladeIngredient> STREAM_CODEC = class_9139.method_56435(
            class_9135.method_56896(ITEM_HOLDER_SET_CODEC),
            ingredient -> ingredient.items,
            RequestDefinition.STREAM_CODEC,
            ingredient -> ingredient.request,
            SlashBladeIngredient::new
    );


    public SlashBladeIngredient {
        if (items.method_40247() <= 0) {
            throw new IllegalArgumentException("Cannot create a SlashBladeIngredient with no items");
        }
    }

    private SlashBladeIngredient(Set<class_1792> items, RequestDefinition request) {
        this(class_6885.method_40242(items.stream().map(class_1792::method_40131).toList()), request);
    }

    public static SlashBladeIngredient of(class_1935 item, RequestDefinition request) {
        return new SlashBladeIngredient(Set.of(item.method_8389()), request);
    }

    public static SlashBladeIngredient of(RequestDefinition request) {
        return new SlashBladeIngredient(Set.of(SBItems.slashblade), request);
    }

    public static SlashBladeIngredient of(class_1935 item, class_2960 request) {
        return new SlashBladeIngredient(Set.of(item.method_8389()),
                RequestDefinition.Builder.newInstance().name(request).build());
    }

    public static SlashBladeIngredient of(class_2960 request) {
        return new SlashBladeIngredient(Set.of(SBItems.slashblade),
                RequestDefinition.Builder.newInstance().name(request).build());
    }

    public static SlashBladeIngredient blankNameless() {
        return of(RequestDefinition.Builder.newInstance().build());
    }

    @Override
    public boolean test(class_1799 input) {
        if (input == null)
            return false;
        return items.method_40241(input.method_41409()) && this.request.test(input);
    }

    @Override
    public List<class_1799> getMatchingStacks() {
        return items.method_40239().map(item -> {
            class_1799 stack = new class_1799(item);
            // copy NBT to prevent the stack from modifying the original, as capabilities or
            // vanilla item durability will modify the tag
            request.initItemStack(stack);
            // return new Ingredient.ItemValue(stack);
            return stack;
        }).toList();
    }

    @Override
    public boolean requiresTesting() {
        return true;
    }

    @Override
    public CustomIngredientSerializer<? extends CustomIngredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer implements CustomIngredientSerializer<SlashBladeIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final class_2960 RES = SlashBlade.prefix("blade");

        @Override
        public class_2960 getIdentifier() {
            return RES;
        }

        @Override
        public MapCodec<SlashBladeIngredient> getCodec(boolean b) {
            return SlashBladeIngredient.CODEC;
        }

        @Override
        public class_9139<class_9129, SlashBladeIngredient> getPacketCodec() {
            return SlashBladeIngredient.STREAM_CODEC;
        }
    }
}
