package mods.flammpfeil.slashblade.recipe;

import mods.flammpfeil.slashblade.SlashBladeConfig;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.slashblade.SlashBladeDefinition;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import net.minecraft.class_8957;
import net.minecraft.class_9694;
import net.minecraft.world.item.crafting.*;
import org.jetbrains.annotations.NotNull;

public class SlashBladeShapedRecipe extends class_1869 {
    public static final class_1865<SlashBladeShapedRecipe> SERIALIZER = new SlashBladeShapedRecipeSerializer();

    final class_8957 pattern;
    final class_1799 result;
    final String group;
    final class_7710 category;
    final boolean showNotification;
    final class_2960 outputBlade;

    public SlashBladeShapedRecipe(String group, class_7710 craftingBookCategory, class_8957 shapedRecipePattern, class_1799 itemStack, boolean bl, class_2960 blade) {
        super(group, craftingBookCategory, shapedRecipePattern, itemStack, bl);
        this.group = group;
        this.category = craftingBookCategory;
        this.pattern = shapedRecipePattern;
        this.result = itemStack;
        this.showNotification = bl;
        this.outputBlade = blade;
    }

    public String method_8112() {
        return this.group;
    }

    public class_7710 method_45441() {
        return this.category;
    }

    public class_2371<class_1856> method_8117() {
        return this.pattern.method_59997();
    }

    public boolean method_49188() {
        return this.showNotification;
    }

    public static class_1799 getResultBlade(class_2960 outputBlade) {
        class_1792 bladeItem = class_7923.field_41178.method_10250(outputBlade) ? class_7923.field_41178.method_10223(outputBlade)
                : SBItems.slashblade;

        return bladeItem.method_7854();
    }

    public class_2960 getOutputBlade() {
        return outputBlade;
    }

    private class_5321<SlashBladeDefinition> getOutputBladeKey() {
        return class_5321.method_29179(SlashBladeDefinition.REGISTRY_KEY, outputBlade);
    }

    public class_8957 getPattern() {
        return pattern;
    }

    @Override
    public @NotNull class_1799 method_8110(class_7225.@NotNull class_7874 provider) {
        class_1799 result = SlashBladeShapedRecipe.getResultBlade(this.getOutputBlade());

        if (!class_7923.field_41178.method_10221(result.method_7909()).equals(getOutputBlade())) {
            result = provider.method_46762(SlashBladeDefinition.REGISTRY_KEY).method_46747(getOutputBladeKey())
                    .comp_349().getBlade(provider);
        }

        return result;
    }

    @Override
    public @NotNull class_1799 method_17727(@NotNull class_9694 container, class_7225.@NotNull class_7874 provider) {
        var result = this.method_8110(provider);
        if (!(result.method_7909() instanceof ItemSlashBlade)) {
            result = new class_1799(SBItems.slashblade);
        }

        var resultState = CapabilitySlashBlade.getBladeState(result).orElseThrow(NullPointerException::new);
        boolean sumRefine = SlashBladeConfig.DO_CRAFTING_SUM_REFINE.get();
        int proudSoul = resultState.getProudSoulCount();
        int killCount = resultState.getKillCount();
        int refine = resultState.getRefine();
        for (var stack : container.method_59989()) {
            if (!(stack.method_7909() instanceof ItemSlashBlade))
                continue;
            var ingredientState = CapabilitySlashBlade.getBladeState(stack).orElseThrow(NullPointerException::new);

            proudSoul += ingredientState.getProudSoulCount();
            killCount += ingredientState.getKillCount();
            if (sumRefine) {
                refine += ingredientState.getRefine();
            } else {
                refine = Math.max(refine, ingredientState.getRefine());
            }
            updateEnchantment(result, stack);
        }

        resultState.setProudSoulCount(proudSoul);
        resultState.setKillCount(killCount);
        resultState.setRefine(refine);

        return result;
    }

    private void updateEnchantment(class_1799 result, class_1799 ingredient) {
        var newItemEnchants = class_1890.method_57532(result);
        var oldItemEnchants = class_1890.method_57532(ingredient);
        for (class_6880<class_1887> enchantIndex : oldItemEnchants.method_57534()) {
            class_1887 enchantment = enchantIndex.comp_349();

            int destLevel = newItemEnchants.method_57536(enchantIndex);
            int srcLevel = oldItemEnchants.method_57536(enchantIndex);

            srcLevel = Math.max(srcLevel, destLevel);
            srcLevel = Math.min(srcLevel, enchantment.method_8183());

            boolean canApplyFlag = result.canBeEnchantedWith(enchantIndex, EnchantingContext.ACCEPTABLE);
            if (canApplyFlag) {
                for (class_6880<class_1887> curEnchantIndex : newItemEnchants.method_57534()) {
                    if (curEnchantIndex.comp_349() != enchantment
                            && !class_1887.method_60033(enchantIndex, curEnchantIndex)) {
                        canApplyFlag = false;
                        break;
                    }
                }
                if (canApplyFlag) {
                    int finalSrcLevel = srcLevel;
                    class_1890.method_57531(result, mutable -> mutable.method_57547(enchantIndex, finalSrcLevel));
                }
            }
        }
    }

    @Override
    public class_1865<?> method_8119() {
        return SERIALIZER;
    }
}
