package mods.flammpfeil.slashblade.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import mods.flammpfeil.slashblade.init.SBItems;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import net.minecraft.class_8957;
import javax.annotation.Nullable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SlashBladeShapedRecipeBuilder implements class_5797 {
    private final class_7800 category = class_7800.field_40639;
    private final class_1792 result;
    private final int count;
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, class_1856> key = Maps.newLinkedHashMap();
    private final Map<String, class_175<?>> criteria = new LinkedHashMap<>();
    @Nullable
    private String group;
    private boolean showNotification = true;
    private class_2960 blade = null;

    public SlashBladeShapedRecipeBuilder(class_1935 item, int count) {
        this.result = item.method_8389();
        this.count = count;
    }

    public static SlashBladeShapedRecipeBuilder shaped(class_2960 blade) {
        return shaped(SBItems.slashblade, 1).blade(blade);
    }

    public static SlashBladeShapedRecipeBuilder shaped(class_1935 result) {
        return shaped(class_7923.field_41178.method_10221(result.method_8389()));
    }

    public static SlashBladeShapedRecipeBuilder shaped(class_1935 result, int count) {
        return new SlashBladeShapedRecipeBuilder(result, count);
    }

    public SlashBladeShapedRecipeBuilder define(Character key, class_6862<class_1792> tag) {
        return this.define(key, class_1856.method_8106(tag));
    }

    public SlashBladeShapedRecipeBuilder define(Character key, class_1935 tag) {
        return this.define(key, class_1856.method_8091(tag));
    }

    public SlashBladeShapedRecipeBuilder blade(class_2960 blade) {
        this.blade = blade;
        return this;
    }

    public SlashBladeShapedRecipeBuilder define(Character key, class_1856 ingredient) {
        if (this.key.containsKey(key)) {
            throw new IllegalArgumentException("Symbol '" + key + "' is already defined!");
        } else if (key == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        } else {
            this.key.put(key, ingredient);
            return this;
        }
    }

    public SlashBladeShapedRecipeBuilder pattern(String pattern) {
        if (!this.rows.isEmpty() && pattern.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        } else {
            this.rows.add(pattern);
            return this;
        }
    }

    @Override
    public SlashBladeShapedRecipeBuilder method_33530(String key, class_175<?> trigger) {
        this.criteria.put(key, trigger);
        return this;
    }

    public SlashBladeShapedRecipeBuilder method_33529(@Nullable String group) {
        this.group = group;
        return this;
    }

    public SlashBladeShapedRecipeBuilder showNotification(boolean show) {
        this.showNotification = show;
        return this;
    }

    public class_1792 method_36441() {
        return this.result;
    }

    @Override
    public void method_10431(class_8790 consumer) {
        this.method_17972(consumer, this.blade != null ? this.blade : class_7923.field_41178.method_10221(this.method_36441()));
    }

    public void method_17972(class_8790 consumer, class_2960 id) {
        class_8957 pattern = this.ensureValid(id);
        class_161.class_162 builder = consumer.method_53818().method_705("has_the_recipe", class_2119.method_27847(id))
                .method_703(class_170.class_171.method_753(id)).method_704(class_8782.class_8797.field_1257);
        this.criteria.forEach(builder::method_705);
        SlashBladeShapedRecipe recipe = new SlashBladeShapedRecipe(this.group == null ? "" : this.group, class_5797.method_55308(this.category), pattern,
                new class_1799(this.result, this.count), this.showNotification, this.blade);
        consumer.method_53819(id, recipe, builder.method_695(id.method_45138("recipes/" + this.category.method_46203() + "/")));
    }

    private class_8957 ensureValid(class_2960 id) {
        if (this.rows.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + id + "!");
        } else {
            Set<Character> set = Sets.newHashSet(this.key.keySet());
            set.remove(' ');

            for (String s : this.rows) {
                for (int i = 0; i < s.length(); ++i) {
                    char c0 = s.charAt(i);
                    if (!this.key.containsKey(c0) && c0 != ' ') {
                        throw new IllegalStateException(
                                "Pattern in recipe " + id + " uses undefined symbol '" + c0 + "'");
                    }

                    set.remove(c0);
                }
            }

            if (!set.isEmpty()) {
                throw new IllegalStateException(
                        "Ingredients are defined but not used in pattern for recipe " + id);
            } else if (this.rows.size() == 1 && this.rows.get(0).length() == 1) {
                throw new IllegalStateException("Shaped recipe " + id
                        + " only takes in a single item - should it be a shapeless recipe instead?");
            } else if (this.criteria.isEmpty()) {
                throw new IllegalStateException("No way of obtaining recipe " + id);
            }
        }
        return class_8957.method_55085(this.key, this.rows);
    }
}
