package mods.flammpfeil.slashblade.util;

import com.google.common.collect.Lists;
import mods.flammpfeil.slashblade.ability.ArrowReflector;
import mods.flammpfeil.slashblade.ability.TNTExtinguisher;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.entity.EntityAbstractSummonedSword;
import mods.flammpfeil.slashblade.entity.EntitySlashEffect;
import mods.flammpfeil.slashblade.entity.IShootable;
import mods.flammpfeil.slashblade.event.SlashBladeEvent;
import mods.flammpfeil.slashblade.init.SBEntityTypes;
import mods.flammpfeil.slashblade.registry.ModAttributes;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.function.Consumer;

import static mods.flammpfeil.slashblade.SlashBladeConfig.SLASHBLADE_DAMAGE_MULTIPLIER;

public class AttackManager {
    public static boolean isPowered(class_1309 entity) {
        class_1799 blade = entity.method_6047();
        boolean result = entity.method_6059(class_1294.field_5910) || entity.method_6059(class_1294.field_5903);
        if (CapabilitySlashBlade.getBladeState(blade).isPresent()) {
            var state = CapabilitySlashBlade.getBladeState(blade).orElseThrow(NullPointerException::new);
            var event = new SlashBladeEvent.PowerBladeEvent(blade, state, entity, result);
            SlashBladeEvent.POWER_BLADE.invoker().onPower(event);
            result = event.isPowered();
        }

        return result;
    }

    public static void areaAttack(class_1309 playerIn, Consumer<class_1309> beforeHit) {
        areaAttack(playerIn, beforeHit, 1.0f, true, true, false);
    }

    public static EntitySlashEffect doSlash(class_1309 playerIn, float roll) {
        return doSlash(playerIn, roll, false);
    }

    public static EntitySlashEffect doSlash(class_1309 playerIn, float roll, boolean mute) {
        return doSlash(playerIn, roll, mute, false);
    }

    public static EntitySlashEffect doSlash(class_1309 playerIn, float roll, boolean mute, boolean critical) {
        return doSlash(playerIn, roll, mute, critical, 1.0);
    }

    public static EntitySlashEffect doSlash(class_1309 playerIn, float roll, boolean mute, boolean critical,
                                            double comboRatio) {
        return doSlash(playerIn, roll, class_243.field_1353, mute, critical, comboRatio);
    }

    public static EntitySlashEffect doSlash(class_1309 playerIn, float roll, class_243 centerOffset, boolean mute,
                                            boolean critical, double comboRatio) {
        return doSlash(playerIn, roll, centerOffset, mute, critical, comboRatio, KnockBacks.cancel);
    }

    public static EntitySlashEffect doSlash(class_1309 playerIn, float roll, class_243 centerOffset, boolean mute,
                                            boolean critical, double comboRatio, KnockBacks knockback) {

        int colorCode = CapabilitySlashBlade.getBladeState(playerIn.method_6047())
                .map(ISlashBladeState::getColorCode).orElse(0xFFFFFF);

        return doSlash(playerIn, roll, colorCode, centerOffset, mute, critical, comboRatio, knockback);
    }

    public static EntitySlashEffect doSlash(class_1309 playerIn, float roll, int colorCode, class_243 centerOffset,
                                            boolean mute, boolean critical, double comboRatio, KnockBacks knockback) {

        if (playerIn.method_37908().method_8608()) {
            return null;
        }
        class_1799 blade = playerIn.method_6047();
        if (CapabilitySlashBlade.getBladeState(blade).isEmpty())
            return null;
        SlashBladeEvent.DoSlashEvent event = new SlashBladeEvent.DoSlashEvent(blade, CapabilitySlashBlade.getBladeState(blade).orElseThrow(NullPointerException::new),
                playerIn, roll, critical, comboRatio, knockback);
        SlashBladeEvent.DO_SLASH.invoker().onDoSlash(event);
        if (event.isCanceled())
            return null;
        class_243 pos = playerIn.method_19538().method_1031(0.0D, (double) playerIn.method_5751() * 0.75D, 0.0D)
                .method_1019(playerIn.method_5720().method_1021(0.3f));

        pos = pos.method_1019(VectorHelper.getVectorForRotation(-90.0F, playerIn.method_5705(0)).method_1021(centerOffset.field_1351))
                .method_1019(VectorHelper.getVectorForRotation(0, playerIn.method_5705(0) + 90).method_1021(centerOffset.field_1350))
                .method_1019(playerIn.method_5720().method_1021(centerOffset.field_1350));

        EntitySlashEffect jc = new EntitySlashEffect(SBEntityTypes.SlashEffect, playerIn.method_37908());
        jc.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
        jc.method_7432(event.getUser());
        jc.setRotationRoll(event.getRoll());
        jc.method_36456(playerIn.method_36454());
        jc.method_36457(0);

        jc.setColor(colorCode);

        jc.setMute(mute);
        jc.setIsCritical(event.isCritical());

        jc.setDamage(event.getDamage());

        jc.setKnockBack(event.getKnockback());

        CapabilityConcentrationRank.RANK_POINT.maybeGet(playerIn)
                .ifPresent(rank -> jc.setRank(rank.getRankLevel(playerIn.method_37908().method_8510())));

        playerIn.method_37908().method_8649(jc);

        return jc;
    }

    public static void doVoidSlashAttack(class_1309 living) {
        if (living.method_37908().method_8608()) {
            return;
        }

        class_243 pos = living.method_19538().method_1031(0.0D, (double) living.method_5751() * 0.75D, 0.0D)
                .method_1019(living.method_5720().method_1021(0.3f));

        pos = pos.method_1019(VectorHelper.getVectorForRotation(-90.0F, living.method_5705(0)).method_1021(class_243.field_1353.field_1351))
                .method_1019(VectorHelper.getVectorForRotation(0, living.method_5705(0) + 90).method_1021(class_243.field_1353.field_1350))
                .method_1019(living.method_5720().method_1021(class_243.field_1353.field_1350));

        EntitySlashEffect jc = newVoidSlashEffect(living, pos);

        jc.setDamage(0D);

        jc.setKnockBack(KnockBacks.cancel);

        CapabilityConcentrationRank.RANK_POINT.maybeGet(living)
                .ifPresent(rank -> jc.setRank(rank.getRankLevel(living.method_37908().method_8510())));

        jc.setLifetime(36);

        living.method_37908().method_8649(jc);
    }

    public static @NotNull EntitySlashEffect newVoidSlashEffect(class_1309 living, class_243 pos) {
        EntitySlashEffect jc = new EntitySlashEffect(SBEntityTypes.SlashEffect, living.method_37908()) {

            @Override
            public double getDamage() {
                return 0;
            }

            @Override
            public class_3414 getSlashSound() {
                return class_3417.field_14842;
            }

            @Override
            protected void tryDespawn() {
                if (!this.method_37908().method_8608()) {
                    if (this.getLifetime() < this.field_6012) {
                        this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(),
                                class_3417.field_15081, class_3419.field_15248, 1.0F,
                                0.625F + 0.1f * this.field_5974.method_43057());
                        ((class_3218) this.method_37908()).method_14199(class_2398.field_11208, this.method_23317(),
                                this.method_23318(), this.method_23321(), 16, 0.7, 0.7, 0.7, 0.02);
                        this.getAlreadyHits().forEach(entity -> {

                            if (entity.method_5805()) {
                                float yRot = this.method_24921() != null ? this.method_24921().method_36454() : 0;
                                entity.method_45319(new class_243(
                                        -Math.sin(yRot * (float) Math.PI / 180.0F) * 0.5,
                                        0.05D,
                                        Math.cos(yRot * (float) Math.PI / 180.0F) * 0.5));
                                double baseAmount = living.method_45325(class_5134.field_23721);
                                var holder = living.method_56673().method_46762(class_7924.field_41265).method_46747(class_1893.field_9103);
                                int powerLevel = class_1890.method_8225(holder, living.method_6047());
                                baseAmount *= 1 + powerLevel * 0.1;
                                baseAmount += AttackHelper.getRankBonus(living);
                                if (this.getShooter() instanceof class_1309 shooter) {
                                    baseAmount *= getSlashBladeDamageScale(shooter) * SLASHBLADE_DAMAGE_MULTIPLIER.get();
                                }
                                doAttackWith(this.method_48923().method_48815(this, this.getShooter()),
                                        ((float) (baseAmount) * 5.1f), entity, true, true);
                            }
                        });
                        this.method_5650(class_5529.field_26999);
                    }
                }
            }
        };
        jc.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
        jc.method_7432(living);

        jc.setRotationRoll(180);
        jc.method_36456(living.method_36454() - 22.5F);
        jc.method_36457(0);

        int colorCode = CapabilitySlashBlade.getBladeState(living.method_6047())
                .map(ISlashBladeState::getColorCode).orElse(0xFFFFFF);
        jc.setColor(colorCode);

        jc.setMute(false);
        jc.setIsCritical(false);

        return jc;
    }

    public static List<class_1297> areaAttack(class_1309 playerIn, Consumer<class_1309> beforeHit, float comboRatio,
                                          boolean forceHit, boolean resetHit, boolean mute) {
        return areaAttack(playerIn, beforeHit, comboRatio, forceHit, resetHit, mute, null);
    }

    public static List<class_1297> areaAttack(class_1309 playerIn, Consumer<class_1309> beforeHit, float comboRatio,
                                          boolean forceHit, boolean resetHit, boolean mute, List<class_1297> exclude) {
        List<class_1297> founds = Lists.newArrayList();

        if (!playerIn.method_37908().method_8608()) {
            founds = TargetSelector.getTargettableEntitiesWithinAABB(playerIn.method_37908(), playerIn);

            if (exclude != null) {
                founds.removeAll(exclude);
            }

            for (class_1297 entity : founds) {
                if (entity instanceof class_1309 living) {
                    beforeHit.accept(living);
                }
                doMeleeAttack(playerIn, entity, forceHit, resetHit, comboRatio);
            }
        }

        if (!mute) {
            playerIn.method_37908().method_43128(null, playerIn.method_23317(), playerIn.method_23318(), playerIn.method_23321(),
                    class_3417.field_14706, class_3419.field_15248, 0.5F,
                    0.4F / (playerIn.method_59922().method_43057() * 0.4F + 0.8F));
        }
        return founds;
    }

    public static <E extends class_1297 & IShootable> List<class_1297> areaAttack(E owner, Consumer<class_1309> beforeHit,
                                                                          double reach, boolean forceHit, boolean resetHit) {
        return areaAttack(owner, beforeHit, reach, forceHit, resetHit, null);
    }

    public static <E extends class_1297 & IShootable> List<class_1297> areaAttack(E owner, Consumer<class_1309> beforeHit,
                                                                          double reach, boolean forceHit, boolean resetHit, List<class_1297> exclude) {

        return areaAttack(owner, beforeHit, reach, forceHit, resetHit, 1.0F, exclude);
    }

    public static <E extends class_1297 & IShootable> List<class_1297> areaAttack(E owner, Consumer<class_1309> beforeHit,
                                                                          double reach, boolean forceHit, boolean resetHit, float comboRatio, List<class_1297> exclude) {
        List<class_1297> founds = Lists.newArrayList();

        if (!owner.method_37908().method_8608()) {
            founds = TargetSelector.getTargettableEntitiesWithinAABB(owner.method_37908(), reach, owner);

            if (exclude != null) {
                founds.removeAll(exclude);
            }

            for (class_1297 entity : founds) {

                if (entity instanceof class_1309 living) {
                    beforeHit.accept(living);
                }

                double baseAmount = owner.getDamage();
                if (owner.getShooter() instanceof class_1309 living) {
                    if (!(owner instanceof EntitySlashEffect)) {
                        var holder = living.method_56673().method_46762(class_7924.field_41265).method_46747(class_1893.field_9103);
                        int powerLevel = class_1890.method_8225(holder, living.method_6047());
                        baseAmount += powerLevel * 0.1;
                    }
                    baseAmount *= living.method_45325(class_5134.field_23721);
                    baseAmount += AttackHelper.getRankBonus(living);

                    baseAmount *= comboRatio * getSlashBladeDamageScale(living) * SLASHBLADE_DAMAGE_MULTIPLIER.get();

                }

                doAttackWith(owner.method_48923().method_48815(owner, owner.getShooter()), (float) baseAmount, entity,
                        forceHit, resetHit);
            }
        }

        return founds;
    }

    public static void doManagedAttack(Consumer<class_1297> attack, class_1297 target, boolean forceHit, boolean resetHit) {
        if (forceHit) {
            target.field_6008 = 0;
        }

        attack.accept(target);

        if (resetHit) {
            target.field_6008 = 0;
        }
    }

    public static void doAttackWith(class_1282 src, float amount, class_1297 target, boolean forceHit, boolean resetHit) {
        if (target instanceof EntityAbstractSummonedSword) {
            return;
        }

        doManagedAttack((t) -> t.method_5643(src, amount), target, forceHit, resetHit);
    }

    public static void doMeleeAttack(class_1309 attacker, class_1297 target, boolean forceHit, boolean resetHit) {
        doMeleeAttack(attacker, target, forceHit, resetHit, 1.0f);
    }

    public static void doMeleeAttack(class_1309 attacker, class_1297 target, boolean forceHit, boolean resetHit, float comboRatio) {
        doManagedAttack((t) -> CapabilitySlashBlade.getBladeState(attacker.method_6047()).ifPresent((state) -> {
            try {
                state.setOnClick(true);
                AttackHelper.attack(attacker, t, comboRatio);
            } finally {
                state.setOnClick(false);
            }
        }), target, forceHit, resetHit);

        ArrowReflector.doReflect(target, attacker);
        TNTExtinguisher.doExtinguishing(target, attacker);
    }

    public static void playQuickSheathSoundAction(class_1309 entity) {
        if (entity.method_37908().method_8608()) {
            return;
        }
        entity.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(),
                class_3417.field_24062, class_3419.field_15248, 1.0F, 1.0F);
    }

    public static void playPiercingSoundAction(class_1309 entity) {
        if (entity.method_37908().method_8608()) {
            return;
        }
        entity.method_37908().method_60511(null, entity.method_23317(), entity.method_23318(), entity.method_23321(),
                class_3417.field_15001, class_3419.field_15248, 1.0F, 1.0F);
    }

    public static class_243 genRushOffset(class_1309 entityIn) {
        return new class_243(entityIn.method_59922().method_43057() - 0.5f, entityIn.method_59922().method_43057() - 0.5f, 0).method_1021(2.0);
    }

    public static float getSlashBladeDamageScale(class_1309 entity) {
        class_1324 attributeInstance = entity.method_5996(class_7923.field_41190.method_47983(ModAttributes.getSlashBladeDamage()));
        if (attributeInstance != null) {
            return (float) attributeInstance.method_6194();
        }
        return 1.0f;
    }

}