package mods.flammpfeil.slashblade;

import cn.sh1rocu.slashblade.api.event.LivingKnockBackEvent;
import cn.sh1rocu.slashblade.util.ItemPredicateRegistry;
import com.google.common.base.CaseFormat;
import fuzs.forgeconfigapiport.api.config.v2.ForgeConfigRegistry;
import mods.flammpfeil.slashblade.ability.*;
import mods.flammpfeil.slashblade.advancement.SlashBladeItemPredicate;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.entity.*;
import mods.flammpfeil.slashblade.event.BladeMotionEventBroadcaster;
import mods.flammpfeil.slashblade.event.handler.*;
import mods.flammpfeil.slashblade.init.SBEntityTypes;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.init.SBStatTypes;
import mods.flammpfeil.slashblade.network.NetworkManager;
import mods.flammpfeil.slashblade.recipe.RecipeSerializerRegistry;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.ModAttributes;
import mods.flammpfeil.slashblade.registry.SlashArtsRegistry;
import mods.flammpfeil.slashblade.registry.SpecialEffectsRegistry;
import mods.flammpfeil.slashblade.registry.combo.ComboCommands;
import mods.flammpfeil.slashblade.registry.slashblade.SlashBladeDefinition;
import mods.flammpfeil.slashblade.util.TargetSelector;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SlashBlade {
    public static final String MODID = "slashblade";

    public static class_2960 prefix(String path) {
        return new class_2960(SlashBlade.MODID, path);
    }

    // Directly reference a log4j logger.
    public static final Logger LOGGER = LogManager.getLogger();

    public static void init() {
        ForgeConfigRegistry.INSTANCE.register(MODID, ModConfig.Type.COMMON, SlashBladeConfig.COMMON_CONFIG);

        SBItems.init();
        SBEntityTypes.init();
        SBStatTypes.init();

        setup();

        ModAttributes.init();
        NetworkManager.registerC2SPackets();

        ComboStateRegistry.init();
        SlashArtsRegistry.init();
        SlashBladeCreativeGroup.init();
        RecipeSerializerRegistry.init();

        SpecialEffectsRegistry.init();

        ItemPredicateRegistry.register(SlashBlade.prefix("slashblade"), SlashBladeItemPredicate::new);
    }

    private static void setup() {

        LivingKnockBackEvent.CALLBACK.register(KnockBackHandler::onLivingKnockBack);

        FallHandler.getInstance().register();
        LockOnManager.getInstance().register();
        Guard.getInstance().register();

        StunManager.init();

        RefineHandler.getInstance().register();
        KillCounter.getInstance().register();
        RankPointHandler.getInstance().register();
        AllowFlightOverrwrite.getInstance().register();
        BladeMotionEventBroadcaster.getInstance().register();

        InputCommandEvent.CALLBACK.register(TargetSelector::onInputChange);
        SummonedSwordArts.getInstance().register();
        SlayerStyleArts.getInstance().register();
        Untouchable.getInstance().register();
        EnemyStep.getInstance().register();
        KickJump.getInstance().register();
        SuperSlashArts.getInstance().register();

        ComboCommands.initDefaultStandByCommands();
    }

    public static class RegistryEvents {

        public static final class_2960 BladeItemEntityLoc = new class_2960(SlashBlade.MODID,
                classToString(BladeItemEntity.class));

        public static final class_2960 BladeStandEntityLoc = new class_2960(SlashBlade.MODID,
                classToString(BladeStandEntity.class));

        public static final class_2960 SummonedSwordLoc = new class_2960(SlashBlade.MODID,
                classToString(EntityAbstractSummonedSword.class));

        public static final class_2960 SpiralSwordsLoc = new class_2960(SlashBlade.MODID,
                classToString(EntitySpiralSwords.class));

        public static final class_2960 StormSwordsLoc = new class_2960(SlashBlade.MODID,
                classToString(EntityStormSwords.class));

        public static final class_2960 BlisteringSwordsLoc = new class_2960(SlashBlade.MODID,
                classToString(EntityBlisteringSwords.class));

        public static final class_2960 HeavyRainSwordsLoc = new class_2960(SlashBlade.MODID,
                classToString(EntityHeavyRainSwords.class));

        public static final class_2960 JudgementCutLoc = new class_2960(SlashBlade.MODID,
                classToString(EntityJudgementCut.class));

        public static final class_2960 SlashEffectLoc = new class_2960(SlashBlade.MODID,
                classToString(EntitySlashEffect.class));

        public static final class_2960 DriveLoc = new class_2960(SlashBlade.MODID,
                classToString(EntityDrive.class));

        private static String classToString(Class<? extends class_1297> entityClass) {
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, entityClass.getSimpleName())
                    .replace("entity_", "");
        }

        /**
         * /scoreboard objectives add stat minecraft.custom:slashblade.sword_summoned
         * /scoreboard objectives setdisplay sidebar stat
         */
    }

    public static class_2378<SlashBladeDefinition> getSlashBladeDefinitionRegistry(class_1937 level) {
        if (level.method_8608())
            return BladeModelManager.getClientSlashBladeRegistry();
        return level.method_30349().method_30530(SlashBladeDefinition.REGISTRY_KEY);
    }

    public static class_7225.class_7226<SlashBladeDefinition> getSlashBladeDefinitionRegistry(class_7225.class_7874 access) {
        return access.method_46762(SlashBladeDefinition.REGISTRY_KEY);
    }
}
