package mods.flammpfeil.slashblade.client.renderer.layers;

import cn.sh1rocu.slashblade.util.LazyOptional;
import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import jp.nyatla.nymmd.MmdException;
import jp.nyatla.nymmd.MmdMotionPlayerGL2;
import jp.nyatla.nymmd.MmdPmdModelMc;
import jp.nyatla.nymmd.MmdVmdMotionMc;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.BladeMotionManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import mods.flammpfeil.slashblade.data.tag.SlashBladeEntityTypeTagProvider;
import mods.flammpfeil.slashblade.event.client.UserPoseOverrider;
import mods.flammpfeil.slashblade.init.DefaultResources;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.combo.ComboState;
import mods.flammpfeil.slashblade.util.TimeValueHelper;
import mods.flammpfeil.slashblade.util.VectorHelper;
import net.minecraft.class_1268;
import net.minecraft.class_1292;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5498;
import net.minecraft.class_583;
import net.minecraft.class_742;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

import java.io.IOException;
import java.util.Optional;

public class LayerMainBlade<T extends class_1309, M extends class_583<T>> extends class_3887<T, M> {
    public LayerMainBlade(class_3883<T, M> entityRendererIn) {
        super(entityRendererIn);
    }

    final LazyOptional<MmdPmdModelMc> bladeholder = LazyOptional.of(() -> {
        try {
            return new MmdPmdModelMc(new class_2960(SlashBlade.MODID, "model/bladeholder.pmd"));
        } catch (MmdException | IOException e) {
            e.printStackTrace();
        }
        return null;
    });

    final LazyOptional<MmdMotionPlayerGL2> motionPlayer = LazyOptional.of(() -> {
        MmdMotionPlayerGL2 mmp = new MmdMotionPlayerGL2();

        bladeholder.ifPresent(pmd -> {
            try {
                mmp.setPmd(pmd);
            } catch (MmdException e) {
                e.printStackTrace();
            }
        });

        return mmp;
    });

    public float modifiedSpeed(float baseSpeed, class_1309 entity) {
        float modif = 6.0f;
        if (class_1292.method_5576(entity)) {
            modif = 6 - (1 + class_1292.method_5575(entity));
        } else if (entity.method_6059(class_1294.field_5901)) {
            modif = 6 + (1 + entity.method_6112(class_1294.field_5901).method_5578()) * 2;
        }

        modif /= 6.0f;

        return baseSpeed / modif;
    }

    public void renderOffhandItem(class_4587 matrixStack, class_4597 bufferIn, int lightIn, T entity) {

        class_1799 offhandStack = entity.method_5998(class_1268.field_5810);
        if (offhandStack.method_7960() || CapabilitySlashBlade.BLADESTATE.maybeGet(offhandStack).isEmpty()) {
            renderHotbarItem(matrixStack, bufferIn, lightIn, entity);
            return;
        }

        renderStandbyBlade(matrixStack, bufferIn, lightIn, offhandStack, entity);
    }

    public void renderHotbarItem(class_4587 matrixStack, class_4597 bufferIn, int lightIn, T entity) {
        if (entity instanceof class_1657 player) {
            if (player.method_31548().field_7545 == 0)
                return;

            class_1799 blade = player.method_31548().method_5438(0);
            if (blade.method_7960())
                return;

            renderStandbyBlade(matrixStack, bufferIn, lightIn, blade, entity);
        }
    }

    public void renderStandbyBlade(class_4587 matrixStack, class_4597 bufferIn, int lightIn, class_1799 blade, T entity) {
        Optional<ISlashBladeState> state = CapabilitySlashBlade.BLADESTATE.maybeGet(blade);
        state.ifPresent(s -> {
            double modelScaleBase = 0.0078125F; // 0.5^7
            double motionScale = 1.5 / 12.0;
            class_2960 textureLocation = s.getTexture().orElse(DefaultResources.resourceDefaultTexture);

            WavefrontObject obj = BladeModelManager.getInstance()
                    .getModel(s.getModel().orElse(DefaultResources.resourceDefaultModel));
            String part;
            try (MSAutoCloser msacA = MSAutoCloser.pushMatrix(matrixStack)) {
                // minecraft model neckPoint height = 1.5f
                // mmd model neckPoint height = 12.0f
                matrixStack.method_46416(0, 1.5f, 0);
                var carrytype = s.getCarryType();
                final class_310 mcinstance = class_310.method_1551();
                switch (carrytype) {
                    case PSO2:
                        matrixStack.method_46416(1F, -1.125f, 0.20f);
                        matrixStack.method_22907(new Quaternionf().rotateZYX(-0.122173F, 0, 0));
                        if (mcinstance.field_1690.method_31044() == class_5498.field_26664
                                && entity == mcinstance.field_1724) return;
                        break;

                    case KATANA:
                        matrixStack.method_46416(0.25F, -0.875f, -0.55f);
                        matrixStack.method_22907(new Quaternionf().rotateZYX(3.1415927F, 1.570796f, 0.261799F));
                        break;

                    case DEFAULT:
                        matrixStack.method_46416(0.25F, -0.875f, -0.55f);
                        matrixStack.method_22907(new Quaternionf().rotateZYX(0F, 1.570796f, 0.261799F));
                        break;

                    case NINJA:
                        matrixStack.method_46416(-0.5F, -2f, 0.20f);
                        matrixStack.method_22907(new Quaternionf().rotateZYX(-2.094395F, 0f, 3.1415927F));
                        if (mcinstance.field_1690.method_31044() == class_5498.field_26664
                                && entity == mcinstance.field_1724) return;
                        break;

                    case RNINJA:
                        matrixStack.method_46416(0.5F, -2f, 0.20f);
                        matrixStack.method_22907(new Quaternionf().rotateZYX(-1.047198F, 0, 0));
                        if (mcinstance.field_1690.method_31044() == class_5498.field_26664
                                && entity == mcinstance.field_1724) return;
                        break;

                    default:
                        return;
                }

                float modelScale = (float) (modelScaleBase * (1.0f / motionScale));
                matrixStack.method_22905((float) motionScale, (float) motionScale, (float) motionScale);
                matrixStack.method_22905(modelScale, modelScale, modelScale);

                try (MSAutoCloser msac = MSAutoCloser.pushMatrix(matrixStack)) {
                    if (s.isBroken()) {
                        part = "blade_damaged";
                    } else {
                        part = "blade";
                    }

                    BladeRenderState.renderOverrided(blade, obj, part, textureLocation, matrixStack, bufferIn,
                            lightIn);
                    BladeRenderState.renderOverridedLuminous(blade, obj, part + "_luminous", textureLocation,
                            matrixStack, bufferIn, lightIn);
                    BladeRenderState.renderOverrided(blade, obj, "sheath", textureLocation, matrixStack, bufferIn,
                            lightIn);
                    BladeRenderState.renderOverridedLuminous(blade, obj, "sheath_luminous", textureLocation,
                            matrixStack, bufferIn, lightIn);
                }
            }
        });
    }

    @Override
    public void render(class_4587 matrixStack, class_4597 bufferIn, int lightIn, T entity, float limbSwing,
                       float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {

        this.renderOffhandItem(matrixStack, bufferIn, lightIn, entity);

        float motionYOffset = 1.5f;
        double motionScale = 1.5 / 12.0;
        double modelScaleBase = 0.0078125F; // 0.5^7

        class_1799 stack = entity.method_5998(class_1268.field_5808);

        if (stack.method_7960())
            return;

        if (entity.method_5864().method_20210(SlashBladeEntityTypeTagProvider.EntityTypeTags.RENDER_LAYER_BLACKLIST))
            return;

        Optional<ISlashBladeState> state = CapabilitySlashBlade.BLADESTATE.maybeGet(stack);
        state.ifPresent(s -> {

            motionPlayer.ifPresent(mmp -> {
                ComboState combo = ComboStateRegistry.COMBO_STATE.method_10223(s.getComboSeq()) != null
                        ? ComboStateRegistry.COMBO_STATE.method_10223(s.getComboSeq())
                        : ComboStateRegistry.NONE;
                // tick to msec
                double time = TimeValueHelper.getMSecFromTicks(
                        Math.max(0, entity.method_37908().method_8510() - s.getLastActionTime()) + partialTicks);

                while (combo != ComboStateRegistry.NONE && combo.getTimeoutMS() < time) {
                    time -= combo.getTimeoutMS();

                    combo = ComboStateRegistry.COMBO_STATE.method_10223(combo.getNextOfTimeout(entity)) != null
                            ? ComboStateRegistry.COMBO_STATE.method_10223(combo.getNextOfTimeout(entity))
                            : ComboStateRegistry.NONE;
                }
                if (combo == ComboStateRegistry.NONE) {
                    combo = ComboStateRegistry.COMBO_STATE.method_10223(s.getComboRoot()) != null
                            ? ComboStateRegistry.COMBO_STATE.method_10223(s.getComboRoot())
                            : ComboStateRegistry.STANDBY;
                }

                MmdVmdMotionMc motion = BladeMotionManager.getInstance().getMotion(combo.getMotionLoc());

                double maxSeconds = 0;
                try {
                    mmp.setVmd(motion);
                    maxSeconds = TimeValueHelper.getMSecFromFrames(motion.getMaxFrame());
                } catch (Exception e) {
                    e.printStackTrace();
                }

                double start = TimeValueHelper.getMSecFromFrames(combo.getStartFrame());
                double end = TimeValueHelper.getMSecFromFrames(combo.getEndFrame());
                double span = Math.abs(end - start);

                span = Math.min(maxSeconds, span);

                if (combo.getLoop()) {
                    time = time % span;
                }
                time = Math.min(span, time);

                time = start + time;

                try {
                    mmp.updateMotion((float) time);
                } catch (MmdException e) {
                    e.printStackTrace();
                }

                try (MSAutoCloser msacA = MSAutoCloser.pushMatrix(matrixStack)) {

                    setUserPose(matrixStack, entity, partialTicks);

                    // minecraft model neckPoint height = 1.5f
                    // mmd model neckPoint height = 12.0f
                    matrixStack.method_46416(0, motionYOffset, 0);

                    matrixStack.method_22905((float) motionScale, (float) motionScale, (float) motionScale);

                    // transpoze mmd to mc
                    matrixStack.method_22907(class_7833.field_40718.rotationDegrees(180));

                    class_2960 textureLocation = s.getTexture().orElse(DefaultResources.resourceDefaultTexture);

                    WavefrontObject obj = BladeModelManager.getInstance()
                            .getModel(s.getModel().orElse(DefaultResources.resourceDefaultModel));

                    try (MSAutoCloser msac = MSAutoCloser.pushMatrix(matrixStack)) {
                        int idx = mmp.getBoneIndexByName("hardpointA");

                        if (0 <= idx) {
                            float[] buf = new float[16];
                            mmp._skinning_mat[idx].getValue(buf);

                            Matrix4f mat = VectorHelper.matrix4fFromArray(buf);

                            matrixStack.method_22905(-1, 1, 1);
                            class_4587.class_4665 entry = matrixStack.method_23760();
                            entry.method_23761().mul(mat);
                            matrixStack.method_22905(-1, 1, 1);
                        }

                        float modelScale = (float) (modelScaleBase * (1.0f / motionScale));
                        matrixStack.method_22905(modelScale, modelScale, modelScale);

                        String part;
                        if (s.isBroken()) {
                            part = "blade_damaged";
                        } else {
                            part = "blade";
                        }

                        BladeRenderState.renderOverrided(stack, obj, part, textureLocation, matrixStack, bufferIn,
                                lightIn);
                        BladeRenderState.renderOverridedLuminous(stack, obj, part + "_luminous", textureLocation,
                                matrixStack, bufferIn, lightIn);
                    }

                    try (MSAutoCloser msac = MSAutoCloser.pushMatrix(matrixStack)) {
                        int idx = mmp.getBoneIndexByName("hardpointB");

                        if (0 <= idx) {
                            float[] buf = new float[16];
                            mmp._skinning_mat[idx].getValue(buf);

                            Matrix4f mat = VectorHelper.matrix4fFromArray(buf);

                            matrixStack.method_22905(-1, 1, 1);
                            class_4587.class_4665 entry = matrixStack.method_23760();
                            entry.method_23761().mul(mat);
                            matrixStack.method_22905(-1, 1, 1);
                        }

                        float modelScale = (float) (modelScaleBase * (1.0f / motionScale));
                        matrixStack.method_22905(modelScale, modelScale, modelScale);
                        BladeRenderState.renderOverrided(stack, obj, "sheath", textureLocation, matrixStack, bufferIn,
                                lightIn);
                        BladeRenderState.renderOverridedLuminous(stack, obj, "sheath_luminous", textureLocation,
                                matrixStack, bufferIn, lightIn);

                        if (s.isCharged(entity)) {
                            float f = (float) entity.field_6012 + partialTicks;
                            BladeRenderState.renderChargeEffect(stack, f, obj, "effect",
                                    new class_2960("textures/entity/creeper/creeper_armor.png"), matrixStack,
                                    bufferIn, lightIn);
                        }

                    }

                }
            });
        });
    }

    public void setUserPose(class_4587 matrixStack, T entity, float partialTicks) {
        if (!UserPoseOverrider.UsePoseOverrider && entity instanceof class_742) {
            var animationPlayer = ((IAnimatedPlayer) entity).playerAnimator_getAnimation();
            animationPlayer.setTickDelta(partialTicks);
            if (animationPlayer.isActive()) {
                Vec3f vec3d = animationPlayer.get3DTransform("body", TransformType.POSITION, Vec3f.ZERO);
                matrixStack.method_22904(-vec3d.getX(), (vec3d.getY() + 0.7), -vec3d.getZ());
                // These are additive properties
                Vec3f vec3f = animationPlayer.get3DTransform("body", TransformType.ROTATION, Vec3f.ZERO);
                matrixStack.method_22907(class_7833.field_40718.rotation(vec3f.getZ())); // roll
                matrixStack.method_22907(class_7833.field_40716.rotation(vec3f.getY())); // pitch
                matrixStack.method_22907(class_7833.field_40714.rotation(vec3f.getX())); // yaw
                matrixStack.method_22904(0, -0.7d, 0);
            }
        } else {
            UserPoseOverrider.invertRot(matrixStack, entity, partialTicks);
        }
    }
}
