package mods.flammpfeil.slashblade.registry.combo;

import com.google.common.collect.Maps;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.ability.ArrowReflector;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.init.DefaultResources;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.slasharts.SlashArts;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import mods.flammpfeil.slashblade.util.TimeValueHelper;
import net.minecraft.class_1309;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import javax.annotation.Nonnull;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class ComboState {
    public static final class_5321<class_2378<ComboState>> REGISTRY_KEY = class_5321
            .method_29180(new class_2960(SlashBlade.MODID, "combo_state"));

    private class_2960 motionLoc;

    // frame
    private int start;
    // frame
    private int end;

    private float speed;
    private boolean loop;

    // Next input acceptance period *ms
    public int timeout;

    private Function<class_1309, class_2960> next;
    private Function<class_1309, class_2960> nextOfTimeout;

    private Consumer<class_1309> holdAction;

    private Consumer<class_1309> tickAction;

    private BiConsumer<class_1309, class_1309> hitEffect;

    private Consumer<class_1309> clickAction;

    private BiFunction<class_1309, Integer, SlashArts.ArtsType> releaseAction;

    private boolean isAerial;

    private int priority;

    public class_2960 getMotionLoc() {
        return motionLoc;
    }

    public int getStartFrame() {
        return start;
    }

    public int getEndFrame() {
        return end;
    }

    public float getSpeed() {
        return speed;
    }

    public boolean getLoop() {
        return loop;
    }

    public int getTimeoutMS() {
        return (int) (TimeValueHelper.getMSecFromFrames(Math.abs(getEndFrame() - getStartFrame())) / getSpeed())
                + timeout;
    }

    public void holdAction(class_1309 user) {
        holdAction.accept(user);
    }

    public void tickAction(class_1309 user) {
        tickAction.accept(user);
    }

    public void hitEffect(class_1309 target, class_1309 attacker) {
        hitEffect.accept(target, attacker);
    }

    public void clickAction(class_1309 user) {
        clickAction.accept(user);
    }

    public SlashArts.ArtsType releaseAction(class_1309 user, int elapsed) {
        return this.releaseAction.apply(user, elapsed);
    }

    public static class_2960 getRegistryKey(ComboState state) {
        return ComboStateRegistry.COMBO_STATE.method_10221(state);
    }

    private ComboState(Builder builder) {
        this.start = builder.start;
        this.end = builder.end;

        this.speed = builder.speed;
        this.timeout = builder.timeout;
        this.loop = builder.loop;

        this.motionLoc = builder.motionLoc;

        this.next = builder.next;
        this.nextOfTimeout = builder.nextOfTimeout;

        this.holdAction = builder.holdAction;

        this.tickAction = builder.tickAction;

        this.hitEffect = builder.hitEffect;

        this.clickAction = builder.clickAction;

        this.releaseAction = builder.releaseAction;

        this.isAerial = builder.aerial;

        this.priority = builder.priority;
    }

    public class_2960 getNext(class_1309 living) {
        return this.next.apply(living);
    }

    public class_2960 getNextOfTimeout(class_1309 living) {
        return this.nextOfTimeout.apply(living);
    }

    @Nonnull
    public ComboState checkTimeOut(class_1309 living, float msec) {
        return this.getTimeoutMS() < msec ? ComboStateRegistry.COMBO_STATE.method_10223(this.nextOfTimeout.apply(living))
                : this;
    }

    public boolean isAerial() {
        return this.isAerial;
    }

    public int getPriority() {
        return priority;
    }

    public static SlashArts.ArtsType releaseActionQuickCharge(class_1309 user, Integer elapsed) {
        int level = class_1890.method_8203(class_1893.field_23071, user);
        if (elapsed <= 3 + level) {
            AdvancementHelper.grantedIf(class_1893.field_23071, user);
            AdvancementHelper.grantCriterion(user, AdvancementHelper.ADVANCEMENT_QUICK_CHARGE);
            return SlashArts.ArtsType.Jackpot;
        } else
            return SlashArts.ArtsType.Fail;
    }

    public static class TimeoutNext implements Function<class_1309, class_2960> {

        long timeout;
        Function<class_1309, class_2960> next;

        public static TimeoutNext buildFromFrame(int timeoutFrame, Function<class_1309, class_2960> next) {
            return new TimeoutNext((int) TimeValueHelper.getTicksFromFrames(timeoutFrame), next);
        }

        public TimeoutNext(long timeout, Function<class_1309, class_2960> next) {
            this.timeout = timeout;
            this.next = next;
        }

        @Override
        public class_2960 apply(class_1309 livingEntity) {

            long elapsed = ComboState.getElapsed(livingEntity);

            if (timeout <= elapsed) {
                return next.apply(livingEntity);
            } else {

                return CapabilitySlashBlade.BLADESTATE.maybeGet(livingEntity.method_6047())
                        .map(ISlashBladeState::getComboSeq).orElse(SlashBlade.prefix("none"));
            }
        }
    }

    public static class TimeLineTickAction implements Consumer<class_1309> {
        long offset = -1;

        public static TimeLineTickActionBuilder getBuilder() {
            return new TimeLineTickActionBuilder();
        }

        public static class TimeLineTickActionBuilder {
            Map<Integer, Consumer<class_1309>> timeLine = Maps.newHashMap();

            public TimeLineTickActionBuilder put(int ticks, Consumer<class_1309> action) {
                timeLine.put(ticks, action);
                return this;
            }

            public TimeLineTickAction build() {
                return new TimeLineTickAction(timeLine);
            }
        }

        Map<Integer, Consumer<class_1309>> timeLine = Maps.newHashMap();

        TimeLineTickAction(Map<Integer, Consumer<class_1309>> timeLine) {
            this.timeLine.putAll(timeLine);

        }

        @Override
        public void accept(class_1309 livingEntity) {
            long elapsed = getElapsed(livingEntity);

            if (offset < 0) {
                offset = elapsed;
            }
            long adjustElapsed = elapsed -= offset;
            if (adjustElapsed < 0) {
                offset = elapsed;
                adjustElapsed = 0;
            }

            Consumer<class_1309> action = timeLine.getOrDefault((int) adjustElapsed, this::defaultConsumer);

            action.accept(livingEntity);
        }

        void defaultConsumer(class_1309 entityIn) {
        }
    }

    public static long getElapsed(class_1309 livingEntity) {
        return CapabilitySlashBlade.BLADESTATE.maybeGet(livingEntity.method_6047())
                .map((state) -> state.getElapsedTime(livingEntity)).orElse(0L);
    }

    public static class Builder {
        private int priority;
        private int start;
        private int end;
        private float speed;
        private boolean loop;
        private int timeout;
        private class_2960 motionLoc;
        private Function<class_1309, class_2960> next;
        private Function<class_1309, class_2960> nextOfTimeout;

        private boolean aerial;

        private Consumer<class_1309> holdAction;
        private Consumer<class_1309> tickAction;
        private BiConsumer<class_1309, class_1309> hitEffect;
        private Consumer<class_1309> clickAction;
        private BiFunction<class_1309, Integer, SlashArts.ArtsType> releaseAction;

        private Builder() {
            this.motionLoc = DefaultResources.ExMotionLocation;
            this.priority = 1000;
            this.timeout = 0;
            this.speed = 1.0F;
            this.loop = false;
            this.aerial = false;
            this.next = entity -> SlashBlade.prefix("none");
            this.tickAction = ArrowReflector::doTicks;
            this.releaseAction = (u, e) -> SlashArts.ArtsType.Fail;
            this.holdAction = (a) -> {
            };
            this.hitEffect = (a, b) -> {
            };
            this.clickAction = (user) -> {
            };
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public ComboState build() {
            return new ComboState(this);
        }

        public Builder startAndEnd(int start, int end) {
            this.start = start;
            this.end = end;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder speed(float speed) {
            this.speed = speed;
            return this;
        }

        public Builder loop() {
            this.loop = true;
            return this;
        }

        public Builder aerial() {
            this.aerial = true;
            return this;
        }

        public Builder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder motionLoc(class_2960 motionLoc) {
            this.motionLoc = motionLoc;
            return this;
        }

        public Builder next(Function<class_1309, class_2960> next) {
            this.next = next;
            return this;
        }

        public Builder nextOfTimeout(Function<class_1309, class_2960> nextOfTimeout) {
            this.nextOfTimeout = nextOfTimeout;
            return this;
        }

        public Builder addHoldAction(Consumer<class_1309> holdAction) {
            this.holdAction = this.holdAction.andThen(holdAction);
            return this;
        }

        public Builder addTickAction(Consumer<class_1309> tickAction) {
            this.tickAction = this.tickAction.andThen(tickAction);
            return this;
        }

        public Builder addHitEffect(BiConsumer<class_1309, class_1309> hitEffect) {
            this.hitEffect = this.hitEffect.andThen(hitEffect);
            return this;
        }

        public Builder clickAction(Consumer<class_1309> clickAction) {
            this.clickAction = clickAction;
            return this;
        }

        public Builder releaseAction(BiFunction<class_1309, Integer, SlashArts.ArtsType> clickAction) {
            this.releaseAction = clickAction;
            return this;
        }

    }
}
