/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.entity;

import java.awt.Color;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import mods.flammpfeil.slashblade.entity.EntityJudgementCut;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;

@Environment(value=EnvType.CLIENT)
public class JudgementCutRenderer<T extends EntityJudgementCut>
extends class_897<T> {
    private static final class_2960 modelLocation = new class_2960("slashblade", "model/util/slashdim.obj");
    private static final class_2960 textureLocation = new class_2960("slashblade", "model/util/slashdim.png");

    @Nullable
    public class_2960 getTextureLocation(T entity) {
        return textureLocation;
    }

    public JudgementCutRenderer(class_5617.class_5618 context) {
        super(context);
    }

    public void render(T entity, float entityYaw, float partialTicks, class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn) {
        try (MSAutoCloser msac = MSAutoCloser.pushMatrix(matrixStackIn);){
            int l;
            matrixStackIn.method_22907(class_7833.field_40716.rotationDegrees(class_3532.method_16439((float)partialTicks, (float)((EntityJudgementCut)entity).field_5982, (float)entity.method_36454()) - 90.0f));
            matrixStackIn.method_22907(class_7833.field_40718.rotationDegrees(class_3532.method_16439((float)partialTicks, (float)((EntityJudgementCut)entity).field_6004, (float)entity.method_36455())));
            WavefrontObject model = BladeModelManager.getInstance().getModel(modelLocation);
            int lifetime = ((EntityJudgementCut)entity).getLifetime();
            double deathTime = lifetime;
            double baseAlpha = Math.min(deathTime, (double)Math.max(0.0f, (float)(lifetime - ((EntityJudgementCut)entity).field_6012) - partialTicks)) / deathTime;
            baseAlpha = -Math.pow(baseAlpha - 1.0, 4.0) + 1.0;
            int seed = ((EntityJudgementCut)entity).getSeed();
            matrixStackIn.method_22907(class_7833.field_40716.rotationDegrees((float)seed));
            float scale = 0.01f;
            matrixStackIn.method_22905(scale, scale, scale);
            int color = ((EntityJudgementCut)entity).getColor() & 0xFFFFFF;
            Color col = new Color(color);
            float[] hsb = Color.RGBtoHSB(col.getRed(), col.getGreen(), col.getBlue(), null);
            int baseColor = Color.HSBtoRGB(0.5f + hsb[0], hsb[1], 0.2f) & 0xFFFFFF;
            try (MSAutoCloser msacB = MSAutoCloser.pushMatrix(matrixStackIn);){
                for (l = 0; l < 5; ++l) {
                    matrixStackIn.method_22905(0.95f, 0.95f, 0.95f);
                    BladeRenderState.setCol(baseColor | (0xFF & (int)(102.0 * baseAlpha)) << 24);
                    BladeRenderState.renderOverridedReverseLuminous(class_1799.field_8037, model, "base", this.getTextureLocation(entity), matrixStackIn, bufferIn, packedLightIn);
                }
            }
            int loop = 3;
            for (l = 0; l < loop; ++l) {
                try (MSAutoCloser msacB = MSAutoCloser.pushMatrix(matrixStackIn);){
                    float cycleTicks = 15.0f;
                    float wave = ((float)((EntityJudgementCut)entity).field_6012 + cycleTicks / (float)loop * (float)l + partialTicks) % cycleTicks;
                    float waveScale = 1.0f + 0.03f * wave;
                    matrixStackIn.method_22905(waveScale, waveScale, waveScale);
                    BladeRenderState.setCol(baseColor | (int)((double)(136.0f * ((cycleTicks - wave) / cycleTicks)) * baseAlpha) << 24);
                    BladeRenderState.renderOverridedReverseLuminous(class_1799.field_8037, model, "base", this.getTextureLocation(entity), matrixStackIn, bufferIn, packedLightIn);
                    continue;
                }
            }
            int windCount = 5;
            for (int l2 = 0; l2 < windCount; ++l2) {
                try (MSAutoCloser msacB = MSAutoCloser.pushMatrix(matrixStackIn);){
                    matrixStackIn.method_22907(class_7833.field_40714.rotationDegrees(360.0f / (float)windCount * (float)l2));
                    matrixStackIn.method_22907(class_7833.field_40716.rotationDegrees(30.0f));
                    double rotWind = 18.0;
                    double offsetBase = 7.0;
                    double offset = (double)l2 * offsetBase;
                    double motionLen = offsetBase * (double)(windCount - 1);
                    double ticks = (float)((EntityJudgementCut)entity).field_6012 + partialTicks + (float)seed;
                    double offsetTicks = ticks + offset;
                    double progress = offsetTicks % motionLen / motionLen;
                    double rad = Math.PI * 2;
                    float windScale = (float)(0.4 + progress);
                    matrixStackIn.method_22905(windScale, windScale, windScale);
                    matrixStackIn.method_22907(class_7833.field_40718.rotationDegrees((float)(rotWind * offsetTicks)));
                    Color cc = new Color(col.getRed(), col.getGreen(), col.getBlue(), 0xFF & (int)Math.min(0.0, 255.0 * Math.sin(rad *= progress) * baseAlpha));
                    BladeRenderState.setCol(cc);
                    BladeRenderState.renderOverridedColorWrite(class_1799.field_8037, model, "wind", this.getTextureLocation(entity), matrixStackIn, bufferIn, 0xF000E0);
                    continue;
                }
            }
        }
    }
}

