/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import cn.sh1rocu.slashblade.api.extension.EntityExtension;
import cn.sh1rocu.slashblade.api.extension.IEntityAdditionalSpawnData;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.entity.EntitySlashEffect;
import mods.flammpfeil.slashblade.entity.IShootable;
import mods.flammpfeil.slashblade.entity.Projectile;
import mods.flammpfeil.slashblade.init.SBEntityTypes;
import mods.flammpfeil.slashblade.util.AttackManager;
import mods.flammpfeil.slashblade.util.EnumSetConverter;
import mods.flammpfeil.slashblade.util.KnockBacks;
import mods.flammpfeil.slashblade.util.NBTHelper;
import mods.flammpfeil.slashblade.util.TargetSelector;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1675;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3966;

public class EntityJudgementCut
extends Projectile
implements IShootable {
    private static final class_2940<Integer> COLOR = class_2945.method_12791(EntityJudgementCut.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> FLAGS = class_2945.method_12791(EntityJudgementCut.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> RANK = class_2945.method_12791(EntityJudgementCut.class, (class_2941)class_2943.field_13320);
    private int lifetime = 10;
    private int seed = -1;
    private double damage = 1.0;
    private boolean cycleHit = false;
    private final class_3414 livingEntitySound = class_3417.field_14688;
    EnumSet<FlagsState> flags = EnumSet.noneOf(FlagsState.class);
    int intFlags = 0;

    public int getSeed() {
        return this.seed;
    }

    public boolean doCycleHit() {
        return this.cycleHit;
    }

    public void setCycleHit(boolean cycleHit) {
        this.cycleHit = cycleHit;
    }

    protected class_3414 getHitEntitySound() {
        return this.livingEntitySound;
    }

    public EntityJudgementCut(class_1299<? extends Projectile> entityTypeIn, class_1937 worldIn) {
        super(entityTypeIn, worldIn);
        this.method_5875(true);
        this.seed = this.field_5974.method_43048(360);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(COLOR, (Object)0x3333FF);
        this.field_6011.method_12784(FLAGS, (Object)0);
        this.field_6011.method_12784(RANK, (Object)Float.valueOf(0.0f));
    }

    protected void method_5652(class_2487 compound) {
        super.method_5652(compound);
        NBTHelper.getNBTCoupler(compound).put("Color", this.getColor()).put("Rank", Float.valueOf(this.getRank())).put("damage", this.damage).put("crit", this.getIsCritical()).put("clip", this.isNoClip()).put("Lifetime", this.getLifetime());
    }

    protected void method_5749(class_2487 compound) {
        super.method_5749(compound);
        NBTHelper.getNBTCoupler(compound).get("Color", this::setColor, new Integer[0]).get("Rank", this::setRank, new Float[0]).get("damage", v -> {
            this.damage = v;
        }, this.damage).get("crit", this::setIsCritical, new Boolean[0]).get("clip", this::setNoClip, new Boolean[0]).get("Lifetime", this::setLifetime, new Integer[0]);
    }

    public class_2596<class_2602> method_18002() {
        return IEntityAdditionalSpawnData.getEntitySpawningPacket((class_1297)this);
    }

    @Override
    public void method_7485(double x, double y, double z, float velocity, float inaccuracy) {
        this.method_18800(0.0, 0.0, 0.0);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_5640(double distance) {
        double d0 = this.method_5829().method_995() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntityJudgementCut.method_5824()) * d0;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_5759(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.method_5814(x, y, z);
        this.method_5710(yaw, pitch);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_5750(double x, double y, double z) {
        this.method_18800(0.0, 0.0, 0.0);
    }

    private void setFlags(FlagsState value) {
        this.flags.add(value);
        this.refreshFlags();
    }

    private void removeFlags(FlagsState value) {
        this.flags.remove((Object)value);
        this.refreshFlags();
    }

    private void refreshFlags() {
        if (this.method_37908().method_8608()) {
            int newValue = (Integer)this.field_6011.method_12789(FLAGS);
            if (this.intFlags != newValue) {
                this.intFlags = newValue;
                this.flags = EnumSetConverter.convertToEnumSet(FlagsState.class, this.intFlags);
            }
        } else {
            int newValue = EnumSetConverter.convertToInt(this.flags);
            if (this.intFlags != newValue) {
                this.field_6011.method_12778(FLAGS, (Object)newValue);
                this.intFlags = newValue;
            }
        }
    }

    public void setIsCritical(boolean value) {
        if (value) {
            this.setFlags(FlagsState.Critical);
        } else {
            this.removeFlags(FlagsState.Critical);
        }
    }

    public boolean getIsCritical() {
        this.refreshFlags();
        return this.flags.contains((Object)FlagsState.Critical);
    }

    public void setNoClip(boolean value) {
        this.field_5960 = value;
        if (value) {
            this.setFlags(FlagsState.NoClip);
        } else {
            this.removeFlags(FlagsState.NoClip);
        }
    }

    public boolean isNoClip() {
        if (!this.method_37908().method_8608()) {
            return this.field_5960;
        }
        this.refreshFlags();
        return this.flags.contains((Object)FlagsState.NoClip);
    }

    public void method_5773() {
        super.method_5773();
        if (this.field_6012 < 8 && this.field_6012 % 2 == 0) {
            this.method_5783(this.getHitEntitySound(), 0.2f, 0.5f + 0.25f * this.field_5974.method_43057());
        }
        if (this.getShooter() != null) {
            if (this.field_6012 % 2 == 0) {
                KnockBacks knockBackType = this.getIsCritical() ? KnockBacks.toss : KnockBacks.cancel;
                AttackManager.areaAttack(this, knockBackType.action, 4.0, true, false, 0.16f, null);
            }
            int count = 3;
            if (this.getIsCritical() && 0 < this.field_6012 && this.field_6012 <= 3) {
                EntitySlashEffect jc = new EntitySlashEffect((class_1299<? extends Projectile>)SBEntityTypes.SlashEffect, this.method_37908());
                jc.method_5641(this.method_23317(), this.method_23318(), this.method_23321(), 120.0f * (float)this.field_6012 + (float)this.seed, 0.0f);
                jc.setRotationRoll(30.0f);
                jc.method_7432(this.getShooter());
                jc.setMute(false);
                jc.setIsCritical(true);
                jc.setDamage(0.1f);
                jc.setColor(this.getColor());
                jc.setBaseSize(0.5f);
                jc.setKnockBack(KnockBacks.cancel);
                jc.setIndirect(true);
                jc.setRank(this.getRank());
                this.method_37908().method_8649((class_1297)jc);
            }
        }
        this.tryDespawn();
    }

    protected void tryDespawn() {
        if (!this.method_37908().method_8608() && this.getLifetime() < this.field_6012) {
            this.burst();
        }
    }

    public int getColor() {
        return (Integer)this.method_5841().method_12789(COLOR);
    }

    public void setColor(int value) {
        this.method_5841().method_12778(COLOR, (Object)value);
    }

    public float getRank() {
        return ((Float)this.method_5841().method_12789(RANK)).floatValue();
    }

    public void setRank(float value) {
        this.method_5841().method_12778(RANK, (Object)Float.valueOf(value));
    }

    public int getLifetime() {
        return Math.min(this.lifetime, 1000);
    }

    public void setLifetime(int value) {
        this.lifetime = value;
    }

    @Override
    @Nullable
    public class_1297 getShooter() {
        return this.method_24921();
    }

    @Override
    public void setShooter(class_1297 shooter) {
        this.method_7432(shooter);
    }

    public List<class_1293> getPotionEffects() {
        List effects = class_1844.method_8066((class_2487)((EntityExtension)((Object)this)).sb$getPersistentData());
        if (effects.isEmpty()) {
            effects.add(new class_1293(class_1294.field_5899, 1, 1));
        }
        return effects;
    }

    public void burst() {
        if (!this.method_37908().method_8608()) {
            if (this.method_37908() instanceof class_3218) {
                ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11205, this.method_23317(), this.method_23318(), this.method_23321(), 16, 0.5, 0.5, 0.5, 0.25);
            }
            this.burst(this.getPotionEffects(), null);
        }
        super.method_5650(class_1297.class_5529.field_26999);
    }

    public void burst(List<class_1293> effects, @Nullable class_1297 focusEntity) {
        List<class_1297> list = TargetSelector.getTargettableEntitiesWithinAABB(this.method_37908(), 2.0, this);
        list.stream().filter(e -> e instanceof class_1309).map(e -> (class_1309)e).forEach(e -> {
            double distanceSq = this.method_5858((class_1297)e);
            if (distanceSq < 9.0) {
                double factor = 1.0 - Math.sqrt(distanceSq) / 4.0;
                if (e == focusEntity) {
                    factor = 1.0;
                }
                this.affectEntity((class_1309)e, effects, factor);
            }
        });
    }

    public void affectEntity(class_1309 focusEntity, List<class_1293> effects, double factor) {
        for (class_1293 effectinstance : this.getPotionEffects()) {
            class_1291 effect = effectinstance.method_5579();
            if (effect.method_5561()) {
                effect.method_5564((class_1297)this, this.getShooter(), focusEntity, effectinstance.method_5578(), factor);
                continue;
            }
            int duration = (int)(factor * (double)effectinstance.method_5584() + 0.5);
            if (duration <= 0) continue;
            focusEntity.method_6092(new class_1293(effect, duration, effectinstance.method_5578(), effectinstance.method_5591(), effectinstance.method_5581()));
        }
    }

    public void setDamage(double damageIn) {
        this.damage = damageIn;
    }

    @Override
    public double getDamage() {
        return this.damage;
    }

    @Nullable
    public class_3966 getRayTrace(class_243 p_213866_1_, class_243 p_213866_2_) {
        return class_1675.method_18077((class_1937)this.method_37908(), (class_1297)this, (class_243)p_213866_1_, (class_243)p_213866_2_, (class_238)this.method_5829().method_18804(this.method_18798()).method_1014(1.0), p_213871_1_ -> !p_213871_1_.method_7325() && p_213871_1_.method_5805() && p_213871_1_.method_5863() && p_213871_1_ != this.getShooter());
    }

    static enum FlagsState {
        Critical,
        NoClip;

    }
}

