package cn.sh1rocu.slashblade.api.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1007;
import net.minecraft.class_1657;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

// From Porting_Lib
public class RenderPlayerEvents {
    public static final Event<Pre> PRE = EventFactory.createArrayBacked(Pre.class, callbacks -> (player, renderer, partialTick, poseStack, buffer, packedLight) -> {
        for (Pre callback : callbacks)
            if (callback.onPreRenderPlayer(player, renderer, partialTick, poseStack, buffer, packedLight))
                return true;
        return false;
    });

    public static final Event<Post> POST = EventFactory.createArrayBacked(Post.class, callbacks -> (player, renderer, partialTick, poseStack, buffer, packedLight) -> {
        for (Post callback : callbacks)
            callback.onPostRenderPlayer(player, renderer, partialTick, poseStack, buffer, packedLight);
    });


    public interface Pre {
        boolean onPreRenderPlayer(class_1657 player, class_1007 renderer, float partialTick, class_4587 poseStack, class_4597 buffer, int packedLight);
    }

    public interface Post {
        void onPostRenderPlayer(class_1657 player, class_1007 renderer, float partialTick, class_4587 poseStack, class_4597 buffer, int packedLight);
    }
}