package mods.flammpfeil.slashblade.client.renderer.entity;

import mods.flammpfeil.slashblade.client.renderer.util.MSAutoCloser;
import mods.flammpfeil.slashblade.entity.BladeStandEntity;
import mods.flammpfeil.slashblade.init.SBItems;
import net.minecraft.class_1087;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_915;
import net.minecraft.class_918;

public class BladeStandEntityRenderer extends class_915<BladeStandEntity> {
    private final class_918 itemRenderer;

    public BladeStandEntityRenderer(class_5617.class_5618 context) {
        super(context);

        this.itemRenderer = class_310.method_1551().method_1480();
    }

    @Override
    public void render(BladeStandEntity entity, float entityYaw, float partialTicks, class_4587 matrixStackIn,
                       class_4597 bufferIn, int packedLightIn) {
        doRender(entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public void doRender(BladeStandEntity entity, float entityYaw, float partialTicks, class_4587 matrixStackIn,
                         class_4597 bufferIn, int packedLightIn) {

        if (entity.currentTypeStack.method_7960()) {
            if (entity.currentType == null || entity.currentType == class_1802.field_8162) {
                entity.currentTypeStack = new class_1799(class_1802.field_8143);
            } else {
                entity.currentTypeStack = new class_1799(entity.currentType);
            }
            entity.currentTypeStack.method_27320(entity);
        }

        try (MSAutoCloser msac = MSAutoCloser.pushMatrix(matrixStackIn)) {
            class_2338 blockpos = entity.method_59940();
            class_243 vec = class_243.method_26410(blockpos, 0.75).method_1020(entity.method_19538());
            matrixStackIn.method_22904(vec.field_1352, vec.field_1351, vec.field_1350);
            matrixStackIn.method_22907(class_7833.field_40714.rotationDegrees(entity.method_36455()));
            matrixStackIn.method_22907(class_7833.field_40716.rotationDegrees(180.0F - entity.method_36454()));

            try (MSAutoCloser msacB = MSAutoCloser.pushMatrix(matrixStackIn)) {
                int i = entity.method_6934();
                matrixStackIn.method_22907(class_7833.field_40718.rotationDegrees((float) i * 360.0F / 8.0F));

                matrixStackIn.method_22905(2, 2, 2);
                class_1792 type = entity.currentType;
                if (type == SBItems.BLADESTAND_1) {
                    matrixStackIn.method_22907(class_7833.field_40714.rotationDegrees(-90f));
                } else if (type == SBItems.BLADESTAND_2) {
                    matrixStackIn.method_22907(class_7833.field_40714.rotationDegrees(-90f));
                } else if (type == SBItems.BLADESTAND_V) {
                    matrixStackIn.method_22907(class_7833.field_40714.rotationDegrees(-90f));
                } else if (type == SBItems.BLADESTAND_S) {
                    matrixStackIn.method_22907(class_7833.field_40714.rotationDegrees(-90f));
                } else if (type == SBItems.BLADESTAND_1_W) {
                    matrixStackIn.method_22907(class_7833.field_40716.rotationDegrees(180f));
                    matrixStackIn.method_46416(0, 0, -0.15f);
                } else if (type == SBItems.BLADESTAND_2_W) {
                    matrixStackIn.method_22907(class_7833.field_40716.rotationDegrees(180f));
                    matrixStackIn.method_46416(0, 0, -0.15f);
                }

                // stand render
                matrixStackIn.method_22903();
                matrixStackIn.method_22907(class_7833.field_40714.rotationDegrees(90));
                matrixStackIn.method_22905(0.5f, 0.5f, 0.5f);
                matrixStackIn.method_22904(0, 0, 0.44);
                this.renderItem(entity, entity.currentTypeStack, matrixStackIn, bufferIn, packedLightIn);
                matrixStackIn.method_22909();

                if (entity.currentType == SBItems.BLADESTAND_1_W || type == SBItems.BLADESTAND_2_W) {
                    matrixStackIn.method_46416(0, 0, -0.19f);
                } else if (entity.currentType == SBItems.BLADESTAND_1) {
                }
                // blade render
                matrixStackIn.method_22907(class_7833.field_40716.rotationDegrees(-180f));
                this.renderItem(entity, entity.method_6940(), matrixStackIn, bufferIn, packedLightIn);

            }
        }

        // net.minecraftforge.client.event.RenderNameTagEvent renderNameplateEvent = new net.minecraftforge.client.event.RenderNameTagEvent(
        //        entity, entity.getDisplayName(), this, matrixStackIn, bufferIn, packedLightIn, partialTicks);
        // net.minecraftforge.client.event.RenderNameplateEvent renderNameplateEvent =
        // new net.minecraftforge.client.event.RenderNameplateEvent(entity,
        // entity.getDisplayName().getFormatedText(), this, matrixStackIn, bufferIn,
        // packedLightIn);
        // net.minecraftforge.common.MinecraftForge.EVENT_BUS.post(renderNameplateEvent);
        // if (renderNameplateEvent.getResult() != net.minecraftforge.eventbus.api.Event.Result.DENY
        //        && (renderNameplateEvent.getResult() == net.minecraftforge.eventbus.api.Event.Result.ALLOW
        //                || this.shouldShowName(entity))) {
        if (this.method_23176(entity)) {
            this.method_23175(entity, /*renderNameplateEvent.getContent()*/entity.method_5476(), matrixStackIn, bufferIn, packedLightIn, partialTicks);
        }
    }

    private void renderItem(BladeStandEntity entity, class_1799 itemstack, class_4587 matrixStackIn,
                            class_4597 bufferIn, int packedLightIn) {
        if (!itemstack.method_7960()) {
            class_1087 ibakedmodel = this.itemRenderer.method_4019(itemstack, entity.method_37908(), null, 0);
            this.itemRenderer.method_23179(itemstack, class_811.field_4319, false, matrixStackIn, bufferIn, packedLightIn,
                    class_4608.field_21444, ibakedmodel);
        }
    }

}
