package mods.flammpfeil.slashblade.entity;

import cn.sh1rocu.slashblade.api.extension.EntityExtension;
import cn.sh1rocu.slashblade.util.PotionUtils;
import com.google.common.collect.Lists;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import mods.flammpfeil.slashblade.event.handler.FallHandler;
import mods.flammpfeil.slashblade.util.AttackManager;
import mods.flammpfeil.slashblade.util.EnumSetConverter;
import mods.flammpfeil.slashblade.util.KnockBacks;
import mods.flammpfeil.slashblade.util.NBTHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1675;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_7833;
import org.joml.Vector4f;

import javax.annotation.Nullable;
import java.util.EnumSet;
import java.util.List;

public class EntitySlashEffect extends Projectile implements IShootable {
    private static final class_2940<Integer> COLOR = class_2945
            .method_12791(EntitySlashEffect.class, class_2943.field_13327);
    private static final class_2940<Integer> FLAGS = class_2945
            .method_12791(EntitySlashEffect.class, class_2943.field_13327);
    private static final class_2940<Float> RANK = class_2945.method_12791(EntitySlashEffect.class,
            class_2943.field_13320);
    private static final class_2940<Float> ROTATION_OFFSET = class_2945
            .method_12791(EntitySlashEffect.class, class_2943.field_13320);
    private static final class_2940<Float> ROTATION_ROLL = class_2945
            .method_12791(EntitySlashEffect.class, class_2943.field_13320);
    private static final class_2940<Float> BASESIZE = class_2945.method_12791(EntitySlashEffect.class,
            class_2943.field_13320);

    private int lifetime = 10;
    private KnockBacks action = KnockBacks.cancel;

    private double damage = 1.0D;

    private boolean cycleHit = false;

    private final List<class_1297> alreadyHits = Lists.newArrayList();

    public KnockBacks getKnockBack() {
        return action;
    }

    public void setKnockBack(KnockBacks action) {
        this.action = action == null ? KnockBacks.cancel : action;
    }

    public void setKnockBackOrdinal(int ordinal) {
        if (0 <= ordinal && ordinal < KnockBacks.values().length)
            this.action = KnockBacks.values()[ordinal];
        else
            this.action = KnockBacks.cancel;
    }

    public boolean doCycleHit() {
        return cycleHit;
    }

    public void setCycleHit(boolean cycleHit) {
        this.cycleHit = cycleHit;
    }

    private final class_3414 livingEntitySound = class_3417.field_14688;

    protected class_3414 getHitEntitySound() {
        return this.livingEntitySound;
    }

    public EntitySlashEffect(class_1299<? extends Projectile> entityTypeIn, class_1937 worldIn) {
        super(entityTypeIn, worldIn);
        this.method_5875(true);
        // this.setGlowing(true);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(COLOR, 0x3333FF);
        builder.method_56912(FLAGS, 0);
        builder.method_56912(RANK, 0.0f);

        builder.method_56912(ROTATION_OFFSET, 0.0f);
        builder.method_56912(ROTATION_ROLL, 0.0f);
        builder.method_56912(BASESIZE, 1.0f);
    }

    @Override
    protected void method_5652(class_2487 compound) {
        super.method_5652(compound);

        NBTHelper.getNBTCoupler(compound).put("RotationOffset", this.getRotationOffset())
                .put("RotationRoll", this.getRotationRoll()).put("BaseSize", this.getBaseSize())
                .put("Color", this.getColor()).put("Rank", this.getRank()).put("damage", this.damage)
                .put("crit", this.getIsCritical()).put("clip", this.isNoClip()).put("Lifetime", this.getLifetime())
                .put("Knockback", this.getKnockBack().ordinal());
    }

    @Override
    protected void method_5749(class_2487 compound) {
        super.method_5749(compound);

        NBTHelper.getNBTCoupler(compound).get("RotationOffset", this::setRotationOffset)
                .get("RotationRoll", this::setRotationRoll).get("BaseSize", this::setBaseSize)
                .get("Color", this::setColor).get("Rank", this::setRank)
                .get("damage", ((Double v) -> this.damage = v), this.damage).get("crit", this::setIsCritical)
                .get("clip", this::setNoClip).get("Lifetime", this::setLifetime)
                .get("Knockback", this::setKnockBackOrdinal);
    }

    public boolean isWave() {
        return false;
    }

    @Override
    public void method_7485(double x, double y, double z, float velocity, float inaccuracy) {
        if (!this.isWave())
            this.method_18800(0, 0, 0);
    }

    @Override
    @Environment(EnvType.CLIENT)
    public boolean method_5640(double distance) {
        double d0 = this.method_5829().method_995() * 10.0D;
        if (Double.isNaN(d0)) {
            d0 = 1.0D;
        }

        d0 = d0 * 64.0D * method_5824();
        return distance < d0 * d0;
    }

    @Override
    @Environment(EnvType.CLIENT)
    public void method_5759(double x, double y, double z, float yaw, float pitch, int i) {
        this.method_5814(x, y, z);
        this.method_5710(yaw, pitch);
    }

    @Override
    @Environment(EnvType.CLIENT)
    public void method_5750(double x, double y, double z) {
        this.method_18800(0, 0, 0);
    }

    enum FlagsState {
        Critical, NoClip, Mute, Indirect,
    }

    EnumSet<FlagsState> flags = EnumSet.noneOf(FlagsState.class);
    int intFlags = 0;

    private void setFlags(FlagsState value) {
        this.flags.add(value);
        refreshFlags();
    }

    private void removeFlags(FlagsState value) {
        this.flags.remove(value);
        refreshFlags();
    }

    private void refreshFlags() {
        if (this.method_37908().method_8608()) {
            int newValue = this.field_6011.method_12789(FLAGS);
            if (intFlags != newValue) {
                intFlags = newValue;
                flags = EnumSetConverter.convertToEnumSet(FlagsState.class, intFlags);
            }
        } else {
            int newValue = EnumSetConverter.convertToInt(this.flags);
            if (this.intFlags != newValue) {
                this.field_6011.method_12778(FLAGS, newValue);
                this.intFlags = newValue;
            }
        }
    }

    public void setIndirect(boolean value) {
        if (value)
            setFlags(FlagsState.Indirect);
        else
            removeFlags(FlagsState.Indirect);
    }

    public boolean getIndirect() {
        refreshFlags();
        return flags.contains(FlagsState.Indirect);
    }

    public void setMute(boolean value) {
        if (value)
            setFlags(FlagsState.Mute);
        else
            removeFlags(FlagsState.Mute);
    }

    public boolean getMute() {
        refreshFlags();
        return flags.contains(FlagsState.Mute);
    }

    public void setIsCritical(boolean value) {
        if (value)
            setFlags(FlagsState.Critical);
        else
            removeFlags(FlagsState.Critical);
    }

    public boolean getIsCritical() {
        refreshFlags();
        return flags.contains(FlagsState.Critical);
    }

    public void setNoClip(boolean value) {
        this.field_5960 = value;
        if (value)
            setFlags(FlagsState.NoClip);
        else
            removeFlags(FlagsState.NoClip);
    }

    // disallowedHitBlock
    public boolean isNoClip() {
        if (!this.method_37908().method_8608()) {
            return this.field_5960;
        } else {
            refreshFlags();
            return flags.contains(FlagsState.NoClip);
        }
    }

    public class_3414 getSlashSound() {
        return class_3417.field_15001.comp_349();
    }

    @Override
    public void method_5773() {
        super.method_5773();

        if (field_6012 == 2) {

            if (!getMute())
                this.method_5783(this.getSlashSound(), 0.80F, 0.625F + 0.1f * this.field_5974.method_43057());
            else
                this.method_5783(class_3417.field_14706, 0.5F, 0.4F / (this.field_5974.method_43057() * 0.4F + 0.8F));

            if (getIsCritical())
                this.method_5783(getHitEntitySound(), 0.2F, 0.4F + 0.25f * this.field_5974.method_43057());
        }

        if (field_6012 % 2 == 0 || field_6012 < 5) {
            class_243 start = this.method_19538();
            Vector4f normal = new Vector4f(1, 0, 0, 1);
            Vector4f dir = new Vector4f(0, 0, 1, 1);

            float progress = this.field_6012 / (float) lifetime;

            class_7833.field_40716.rotationDegrees(60 + this.getRotationOffset() - 200.0F * progress).transform(normal);
            class_7833.field_40718.rotationDegrees(this.getRotationRoll()).transform(normal);
            class_7833.field_40714.rotationDegrees(this.method_36455()).transform(normal);
            class_7833.field_40716.rotationDegrees(-this.method_36454()).transform(normal);

            class_7833.field_40716.rotationDegrees(60 + this.getRotationOffset() - 200.0F * progress).transform(dir);
            class_7833.field_40718.rotationDegrees(this.getRotationRoll()).transform(dir);
            class_7833.field_40714.rotationDegrees(this.method_36455()).transform(dir);
            class_7833.field_40716.rotationDegrees(-this.method_36454()).transform(dir);

            class_243 normal3d = new class_243(normal.x(), normal.y(), normal.z());

            class_3965 rayResult = this.method_5770().method_17742(new class_3959(start.method_1019(normal3d.method_1021(1.5)),
                    start.method_1019(normal3d.method_1021(3)), class_3959.class_3960.field_17558, class_3959.class_242.field_1347, class_3726.method_16194()));

            if (getShooter() != null && !getShooter().method_5721()
                    && rayResult.method_17783() == class_239.class_240.field_1332) {
                FallHandler.spawnLandingParticle(this, rayResult.method_17784(), normal3d, 3);
            }

            if (IConcentrationRank.ConcentrationRanks.S.level < getRankCode().level) {
                class_243 vec3 = start.method_1019(normal3d.method_1021(this.getBaseSize() * 2.5));
                this.method_37908().method_8406(class_2398.field_11205, vec3.method_10216(), vec3.method_10214(), vec3.method_10215(), dir.x() + normal.x(),
                        dir.y() + normal.y(), dir.z() + normal.z());
                float randScale = field_5974.method_43057() + 0.5f;
                vec3 = vec3.method_1031(dir.x() * randScale, dir.y() * randScale, dir.z() * randScale);
                this.method_37908().method_8406(class_2398.field_11205, vec3.method_10216(), vec3.method_10214(), vec3.method_10215(), dir.x() + normal.x(),
                        dir.y() + normal.y(), dir.z() + normal.z());
            }
        }

        if (this.getShooter() != null) {
            // no cyclehit
            if (this.field_6012 % 2 == 0) {
                boolean forceHit = true;

                // todo: isCritical = hp direct attack & magic damage & melee damage & armor
                // piercing & event override force hit

                // this::onHitEntity ro KnockBackHandler::setCancel
                List<class_1297> hits;
                if (!getIndirect() && getShooter() instanceof class_1309 shooter) {
                    float ratio = (float) damage * (getIsCritical() ? 1.1f : 1.0f);
                    hits = AttackManager.areaAttack(shooter, this.action.action, ratio, forceHit, false, true,
                            alreadyHits);
                } else {
                    hits = AttackManager.areaAttack(this, this.action.action, 4.0, forceHit, false, alreadyHits);
                }

                if (!this.doCycleHit())
                    alreadyHits.addAll(hits);
            }
        }

        tryDespawn();

    }

    public List<class_1297> getAlreadyHits() {
        return alreadyHits;
    }

    protected void tryDespawn() {
        if (!this.method_37908().method_8608()) {
            if (getLifetime() < this.field_6012)
                this.method_5650(class_5529.field_26999);
        }
    }

    public int getColor() {
        return this.method_5841().method_12789(COLOR);
    }

    public void setColor(int value) {
        this.method_5841().method_12778(COLOR, value);
    }

    public float getRank() {
        return this.method_5841().method_12789(RANK);
    }

    public void setRank(float value) {
        this.method_5841().method_12778(RANK, value);
    }

    public IConcentrationRank.ConcentrationRanks getRankCode() {
        return IConcentrationRank.ConcentrationRanks.getRankFromLevel(getRank());
    }

    public int getLifetime() {
        return Math.min(this.lifetime, 1000);
    }

    public void setLifetime(int value) {
        this.lifetime = value;
    }

    public float getRotationOffset() {
        return this.method_5841().method_12789(ROTATION_OFFSET);
    }

    public void setRotationOffset(float value) {
        this.method_5841().method_12778(ROTATION_OFFSET, value);
    }

    public float getRotationRoll() {
        return this.method_5841().method_12789(ROTATION_ROLL);
    }

    public void setRotationRoll(float value) {
        this.method_5841().method_12778(ROTATION_ROLL, value);
    }

    public float getBaseSize() {
        return this.method_5841().method_12789(BASESIZE);
    }

    public void setBaseSize(float value) {
        this.method_5841().method_12778(BASESIZE, value);
    }

    @Nullable
    @Override
    public class_1297 getShooter() {
        return this.method_24921();
    }

    @Override
    public void setShooter(class_1297 shooter) {
        method_7432(shooter);
    }

    public List<class_1293> getPotionEffects() {
        List<class_1293> effects = PotionUtils.getAllEffects(((EntityExtension) this).sb$getPersistentData());

        if (effects.isEmpty())
            effects.add(new class_1293(class_1294.field_5899, 1, 1));

        return effects;
    }

    public void setDamage(double damageIn) {
        this.damage = damageIn;
    }

    @Override
    public double getDamage() {
        return this.damage;
    }

    @Nullable
    public class_3966 getRayTrace(class_243 p_213866_1_, class_243 p_213866_2_) {
        return class_1675.method_18077(this.method_37908(), this, p_213866_1_, p_213866_2_,
                this.method_5829().method_18804(this.method_18798()).method_1014(1.0D), (entity) -> {
                    return !entity.method_7325() && entity.method_5805() && entity.method_5863()
                            && (entity != this.getShooter());
                });
    }
}
