package mods.flammpfeil.slashblade.event.handler;

import io.github.fabricators_of_create.porting_lib.entity.events.living.LivingHurtEvent;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import net.minecraft.class_1297;
import net.minecraft.class_1309;

public class RankPointHandler {
    private static final class SingletonHolder {
        private static final RankPointHandler instance = new RankPointHandler();
    }

    public static RankPointHandler getInstance() {
        return SingletonHolder.instance;
    }

    private RankPointHandler() {
    }

    public void register() {
        LivingHurtEvent.EVENT.register(this::onLivingDeathEvent);
    }

    /**
     * Not reached if canceled.
     */
    public void onLivingDeathEvent(LivingHurtEvent event) {

        class_1309 victim = event.getEntity();
        if (victim != null)
            CapabilityConcentrationRank.RANK_POINT.maybeGet(victim)
                    .ifPresent(cr -> cr.addRankPoint(victim, -cr.getUnitCapacity()));

        class_1297 trueSource = event.getSource().method_5529();
        if (!(trueSource instanceof class_1309 sourceEntity))
            return;

        if (CapabilitySlashBlade.getBladeState(sourceEntity.method_6047()).isEmpty())
            return;

        CapabilityConcentrationRank.RANK_POINT.maybeGet(trueSource)
                .ifPresent(cr -> cr.addRankPoint(event.getSource()));
    }
}
