/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.util;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import mods.flammpfeil.slashblade.SlashBladeConfig;
import mods.flammpfeil.slashblade.ability.ArrowReflector;
import mods.flammpfeil.slashblade.ability.TNTExtinguisher;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.entity.EntityAbstractSummonedSword;
import mods.flammpfeil.slashblade.entity.EntitySlashEffect;
import mods.flammpfeil.slashblade.entity.IShootable;
import mods.flammpfeil.slashblade.entity.Projectile;
import mods.flammpfeil.slashblade.event.SlashBladeEvent;
import mods.flammpfeil.slashblade.init.SBEntityTypes;
import mods.flammpfeil.slashblade.registry.ModAttributes;
import mods.flammpfeil.slashblade.util.AttackHelper;
import mods.flammpfeil.slashblade.util.KnockBacks;
import mods.flammpfeil.slashblade.util.TargetSelector;
import mods.flammpfeil.slashblade.util.VectorHelper;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class AttackManager {
    public static boolean isPowered(class_1309 entity) {
        boolean result;
        class_1799 blade = entity.method_6047();
        boolean bl = result = entity.method_6059(class_1294.field_5910) || entity.method_6059(class_1294.field_5903);
        if (CapabilitySlashBlade.getBladeState(blade).isPresent()) {
            ISlashBladeState state = CapabilitySlashBlade.getBladeState(blade).orElseThrow(NullPointerException::new);
            SlashBladeEvent.PowerBladeEvent event = new SlashBladeEvent.PowerBladeEvent(blade, state, entity, result);
            ((SlashBladeEvent.PowerBlade)SlashBladeEvent.POWER_BLADE.invoker()).onPower(event);
            result = event.isPowered();
        }
        return result;
    }

    public static void areaAttack(class_1309 playerIn, Consumer<class_1309> beforeHit) {
        AttackManager.areaAttack(playerIn, beforeHit, 1.0f, true, true, false);
    }

    public static EntitySlashEffect doSlash(class_1309 playerIn, float roll) {
        return AttackManager.doSlash(playerIn, roll, false);
    }

    public static EntitySlashEffect doSlash(class_1309 playerIn, float roll, boolean mute) {
        return AttackManager.doSlash(playerIn, roll, mute, false);
    }

    public static EntitySlashEffect doSlash(class_1309 playerIn, float roll, boolean mute, boolean critical) {
        return AttackManager.doSlash(playerIn, roll, mute, critical, 1.0);
    }

    public static EntitySlashEffect doSlash(class_1309 playerIn, float roll, boolean mute, boolean critical, double comboRatio) {
        return AttackManager.doSlash(playerIn, roll, class_243.field_1353, mute, critical, comboRatio);
    }

    public static EntitySlashEffect doSlash(class_1309 playerIn, float roll, class_243 centerOffset, boolean mute, boolean critical, double comboRatio) {
        return AttackManager.doSlash(playerIn, roll, centerOffset, mute, critical, comboRatio, KnockBacks.cancel);
    }

    public static EntitySlashEffect doSlash(class_1309 playerIn, float roll, class_243 centerOffset, boolean mute, boolean critical, double comboRatio, KnockBacks knockback) {
        int colorCode = CapabilitySlashBlade.getBladeState(playerIn.method_6047()).map(ISlashBladeState::getColorCode).orElse(0xFFFFFF);
        return AttackManager.doSlash(playerIn, roll, colorCode, centerOffset, mute, critical, comboRatio, knockback);
    }

    public static EntitySlashEffect doSlash(class_1309 playerIn, float roll, int colorCode, class_243 centerOffset, boolean mute, boolean critical, double comboRatio, KnockBacks knockback) {
        if (playerIn.method_37908().method_8608()) {
            return null;
        }
        class_1799 blade = playerIn.method_6047();
        if (CapabilitySlashBlade.getBladeState(blade).isEmpty()) {
            return null;
        }
        SlashBladeEvent.DoSlashEvent event = new SlashBladeEvent.DoSlashEvent(blade, CapabilitySlashBlade.getBladeState(blade).orElseThrow(NullPointerException::new), playerIn, roll, critical, comboRatio, knockback);
        ((SlashBladeEvent.DoSlash)SlashBladeEvent.DO_SLASH.invoker()).onDoSlash(event);
        if (event.isCanceled()) {
            return null;
        }
        class_243 pos = playerIn.method_19538().method_1031(0.0, (double)playerIn.method_5751() * 0.75, 0.0).method_1019(playerIn.method_5720().method_1021((double)0.3f));
        pos = pos.method_1019(VectorHelper.getVectorForRotation(-90.0f, playerIn.method_5705(0.0f)).method_1021(centerOffset.field_1351)).method_1019(VectorHelper.getVectorForRotation(0.0f, playerIn.method_5705(0.0f) + 90.0f).method_1021(centerOffset.field_1350)).method_1019(playerIn.method_5720().method_1021(centerOffset.field_1350));
        EntitySlashEffect jc = new EntitySlashEffect((class_1299<? extends Projectile>)SBEntityTypes.SLASH_EFFECT, playerIn.method_37908());
        jc.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
        jc.method_7432((class_1297)event.getUser());
        jc.setRotationRoll(event.getRoll());
        jc.method_36456(playerIn.method_36454());
        jc.method_36457(0.0f);
        jc.setColor(colorCode);
        jc.setMute(mute);
        jc.setIsCritical(event.isCritical());
        jc.setDamage(event.getDamage());
        jc.setKnockBack(event.getKnockback());
        CapabilityConcentrationRank.RANK_POINT.maybeGet((Object)playerIn).ifPresent(rank -> jc.setRank(rank.getRankLevel(playerIn.method_37908().method_8510())));
        playerIn.method_37908().method_8649((class_1297)jc);
        return jc;
    }

    public static void doVoidSlashAttack(class_1309 living) {
        if (living.method_37908().method_8608()) {
            return;
        }
        class_243 pos = living.method_19538().method_1031(0.0, (double)living.method_5751() * 0.75, 0.0).method_1019(living.method_5720().method_1021((double)0.3f));
        pos = pos.method_1019(VectorHelper.getVectorForRotation(-90.0f, living.method_5705(0.0f)).method_1021(class_243.field_1353.field_1351)).method_1019(VectorHelper.getVectorForRotation(0.0f, living.method_5705(0.0f) + 90.0f).method_1021(class_243.field_1353.field_1350)).method_1019(living.method_5720().method_1021(class_243.field_1353.field_1350));
        EntitySlashEffect jc = AttackManager.newVoidSlashEffect(living, pos);
        jc.setDamage(0.0);
        jc.setKnockBack(KnockBacks.cancel);
        CapabilityConcentrationRank.RANK_POINT.maybeGet((Object)living).ifPresent(rank -> jc.setRank(rank.getRankLevel(living.method_37908().method_8510())));
        jc.setLifetime(36);
        living.method_37908().method_8649((class_1297)jc);
    }

    @NotNull
    public static EntitySlashEffect newVoidSlashEffect(final class_1309 living, class_243 pos) {
        EntitySlashEffect jc = new EntitySlashEffect(SBEntityTypes.SLASH_EFFECT, living.method_37908()){

            @Override
            public double getDamage() {
                return 0.0;
            }

            @Override
            public class_3414 getSlashSound() {
                return class_3417.field_14842;
            }

            @Override
            protected void tryDespawn() {
                if (!this.method_37908().method_8608() && this.getLifetime() < this.field_6012) {
                    this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15081, class_3419.field_15248, 1.0f, 0.625f + 0.1f * this.field_5974.method_43057());
                    ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11208, this.method_23317(), this.method_23318(), this.method_23321(), 16, 0.7, 0.7, 0.7, 0.02);
                    this.getAlreadyHits().forEach(entity -> {
                        if (entity.method_5805()) {
                            float yRot = this.method_24921() != null ? this.method_24921().method_36454() : 0.0f;
                            entity.method_45319(new class_243(-Math.sin(yRot * (float)Math.PI / 180.0f) * 0.5, 0.05, Math.cos(yRot * (float)Math.PI / 180.0f) * 0.5));
                            double baseAmount = living.method_45325(class_5134.field_23721);
                            class_6880.class_6883 holder = living.method_56673().method_46762(class_7924.field_41265).method_46747(class_1893.field_9103);
                            int powerLevel = class_1890.method_8225((class_6880)holder, (class_1799)living.method_6047());
                            baseAmount *= 1.0 + (double)powerLevel * 0.1;
                            baseAmount += (double)AttackHelper.getRankBonus(living);
                            class_1297 patt0$temp = this.getShooter();
                            if (patt0$temp instanceof class_1309) {
                                class_1309 shooter = (class_1309)patt0$temp;
                                baseAmount *= (double)AttackManager.getSlashBladeDamageScale(shooter) * (Double)SlashBladeConfig.SLASHBLADE_DAMAGE_MULTIPLIER.get();
                            }
                            AttackManager.doAttackWith(this.method_48923().method_48815((class_1297)this, this.getShooter()), (float)baseAmount * 5.1f, entity, true, true);
                        }
                    });
                    this.method_5650(class_1297.class_5529.field_26999);
                }
            }
        };
        jc.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
        jc.method_7432((class_1297)living);
        jc.setRotationRoll(180.0f);
        jc.method_36456(living.method_36454() - 22.5f);
        jc.method_36457(0.0f);
        int colorCode = CapabilitySlashBlade.getBladeState(living.method_6047()).map(ISlashBladeState::getColorCode).orElse(0xFFFFFF);
        jc.setColor(colorCode);
        jc.setMute(false);
        jc.setIsCritical(false);
        return jc;
    }

    public static List<class_1297> areaAttack(class_1309 playerIn, Consumer<class_1309> beforeHit, float comboRatio, boolean forceHit, boolean resetHit, boolean mute) {
        return AttackManager.areaAttack(playerIn, beforeHit, comboRatio, forceHit, resetHit, mute, null);
    }

    public static List<class_1297> areaAttack(class_1309 playerIn, Consumer<class_1309> beforeHit, float comboRatio, boolean forceHit, boolean resetHit, boolean mute, List<class_1297> exclude) {
        List<Object> founds = Lists.newArrayList();
        if (!playerIn.method_37908().method_8608()) {
            founds = TargetSelector.getTargettableEntitiesWithinAABB(playerIn.method_37908(), playerIn);
            if (exclude != null) {
                founds.removeAll(exclude);
            }
            for (class_1297 class_12972 : founds) {
                if (class_12972 instanceof class_1309) {
                    class_1309 living = (class_1309)class_12972;
                    beforeHit.accept(living);
                }
                AttackManager.doMeleeAttack(playerIn, class_12972, forceHit, resetHit, comboRatio);
            }
        }
        if (!mute) {
            playerIn.method_37908().method_43128(null, playerIn.method_23317(), playerIn.method_23318(), playerIn.method_23321(), class_3417.field_14706, class_3419.field_15248, 0.5f, 0.4f / (playerIn.method_59922().method_43057() * 0.4f + 0.8f));
        }
        return founds;
    }

    public static <E extends class_1297> List<class_1297> areaAttack(E owner, Consumer<class_1309> beforeHit, double reach, boolean forceHit, boolean resetHit) {
        return AttackManager.areaAttack(owner, beforeHit, reach, forceHit, resetHit, null);
    }

    public static <E extends class_1297> List<class_1297> areaAttack(E owner, Consumer<class_1309> beforeHit, double reach, boolean forceHit, boolean resetHit, List<class_1297> exclude) {
        return AttackManager.areaAttack(owner, beforeHit, reach, forceHit, resetHit, 1.0f, exclude);
    }

    public static <E extends class_1297> List<class_1297> areaAttack(E owner, Consumer<class_1309> beforeHit, double reach, boolean forceHit, boolean resetHit, float comboRatio, List<class_1297> exclude) {
        List<Object> founds = Lists.newArrayList();
        if (!owner.method_37908().method_8608()) {
            founds = TargetSelector.getTargettableEntitiesWithinAABB(owner.method_37908(), reach, owner);
            if (exclude != null) {
                founds.removeAll(exclude);
            }
            for (class_1297 class_12972 : founds) {
                if (class_12972 instanceof class_1309) {
                    class_1309 living = (class_1309)class_12972;
                    beforeHit.accept(living);
                }
                double baseAmount = ((IShootable)owner).getDamage();
                class_1297 class_129722 = ((IShootable)owner).getShooter();
                if (class_129722 instanceof class_1309) {
                    class_1309 living = (class_1309)class_129722;
                    if (!(owner instanceof EntitySlashEffect)) {
                        class_6880.class_6883 holder = living.method_56673().method_46762(class_7924.field_41265).method_46747(class_1893.field_9103);
                        int powerLevel = class_1890.method_8225((class_6880)holder, (class_1799)living.method_6047());
                        baseAmount += (double)powerLevel * 0.1;
                    }
                    baseAmount *= living.method_45325(class_5134.field_23721);
                    baseAmount += (double)AttackHelper.getRankBonus(living);
                    baseAmount *= (double)(comboRatio * AttackManager.getSlashBladeDamageScale(living)) * (Double)SlashBladeConfig.SLASHBLADE_DAMAGE_MULTIPLIER.get();
                }
                AttackManager.doAttackWith(owner.method_48923().method_48815(owner, ((IShootable)owner).getShooter()), (float)baseAmount, class_12972, forceHit, resetHit);
            }
        }
        return founds;
    }

    public static void doManagedAttack(Consumer<class_1297> attack, class_1297 target, boolean forceHit, boolean resetHit) {
        if (forceHit) {
            target.field_6008 = 0;
        }
        attack.accept(target);
        if (resetHit) {
            target.field_6008 = 0;
        }
    }

    public static void doAttackWith(class_1282 src, float amount, class_1297 target, boolean forceHit, boolean resetHit) {
        if (target instanceof EntityAbstractSummonedSword) {
            return;
        }
        AttackManager.doManagedAttack(t -> t.method_5643(src, amount), target, forceHit, resetHit);
    }

    public static void doMeleeAttack(class_1309 attacker, class_1297 target, boolean forceHit, boolean resetHit) {
        AttackManager.doMeleeAttack(attacker, target, forceHit, resetHit, 1.0f);
    }

    public static void doMeleeAttack(class_1309 attacker, class_1297 target, boolean forceHit, boolean resetHit, float comboRatio) {
        AttackManager.doManagedAttack(t -> CapabilitySlashBlade.getBladeState(attacker.method_6047()).ifPresent(state -> {
            try {
                state.setOnClick(true);
                AttackHelper.attack(attacker, t, comboRatio);
            }
            finally {
                state.setOnClick(false);
            }
        }), target, forceHit, resetHit);
        ArrowReflector.doReflect(target, (class_1297)attacker);
        TNTExtinguisher.doExtinguishing(target, attacker);
    }

    public static void playQuickSheathSoundAction(class_1309 entity) {
        if (entity.method_37908().method_8608()) {
            return;
        }
        entity.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_24062, class_3419.field_15248, 1.0f, 1.0f);
    }

    public static void playPiercingSoundAction(class_1309 entity) {
        if (entity.method_37908().method_8608()) {
            return;
        }
        entity.method_37908().method_60511(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_15001, class_3419.field_15248, 1.0f, 1.0f);
    }

    public static class_243 genRushOffset(class_1309 entityIn) {
        return new class_243((double)(entityIn.method_59922().method_43057() - 0.5f), (double)(entityIn.method_59922().method_43057() - 0.5f), 0.0).method_1021(2.0);
    }

    public static float getSlashBladeDamageScale(class_1309 entity) {
        class_1324 attributeInstance = entity.method_5996(class_7923.field_41190.method_47983((Object)ModAttributes.getSlashBladeDamage()));
        if (attributeInstance != null) {
            return (float)attributeInstance.method_6194();
        }
        return 1.0f;
    }
}

