package cn.sh1rocu.slashblade.api.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

public class AnvilUpdateEvent extends BaseEvent implements ICancellableEvent {
    private final class_1799 left;
    private final class_1799 right;
    private final String name;
    private class_1799 output;
    private int cost;
    private int materialCost;
    private final class_1657 player;
    public static final Event<Callback> CALLBACK = EventFactory.createArrayBacked(Callback.class, callbacks -> event -> {
        for (Callback callback : callbacks) {
            callback.onAnvilUpdate(event);
        }
    });

    public AnvilUpdateEvent(class_1799 left, class_1799 right, String name, int cost, class_1657 player) {
        this.left = left;
        this.right = right;
        this.output = class_1799.field_8037;
        this.name = name;
        this.player = player;
        this.setCost(cost);
        this.setMaterialCost(0);
    }

    public class_1799 getLeft() {
        return left;
    }

    public class_1799 getRight() {
        return right;
    }

    @Nullable
    public String getName() {
        return name;
    }

    public class_1799 getOutput() {
        return output;
    }

    public void setOutput(class_1799 output) {
        this.output = output;
    }

    public int getCost() {
        return cost;
    }

    public void setCost(int cost) {
        this.cost = cost;
    }

    public int getMaterialCost() {
        return materialCost;
    }

    public void setMaterialCost(int materialCost) {
        this.materialCost = materialCost;
    }

    public class_1657 getPlayer() {
        return this.player;
    }

    public interface Callback {
        void onAnvilUpdate(AnvilUpdateEvent event);
    }
}
