package cn.sh1rocu.slashblade.api.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1268;
import net.minecraft.class_304;

public abstract class InputEvent extends BaseEvent {
    public static final Event<ClickInput> CLICK_INPUT_CALLBACK = EventFactory.createArrayBacked(ClickInput.class, callbacks -> event -> {
        for (ClickInput callback : callbacks) {
            callback.onClickInput(event);
        }
    });

    public interface ClickInput {
        void onClickInput(InteractionKeyMappingTriggered event);
    }

    public static class InteractionKeyMappingTriggered extends InputEvent implements ICancellableEvent {
        private final int button;
        private final class_304 keyMapping;
        private final class_1268 hand;
        private boolean handSwing = true;

        public InteractionKeyMappingTriggered(int button, class_304 keyMapping, class_1268 hand) {
            this.button = button;
            this.keyMapping = keyMapping;
            this.hand = hand;
        }

        public void setSwingHand(boolean value) {
            handSwing = value;
        }

        public boolean shouldSwingHand() {
            return handSwing;
        }

        public class_1268 getHand() {
            return hand;
        }

        public boolean isAttack() {
            return button == 0;
        }

        public boolean isUseItem() {
            return button == 1;
        }

        public boolean isPickBlock() {
            return button == 2;
        }

        public class_304 getKeyMapping() {
            return keyMapping;
        }
    }
}
