package cn.sh1rocu.slashblade.api.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1309;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_922;

// From Porting_Lib
public interface LivingEntityRenderEvents {

    Event<Pre> PRE = EventFactory.createArrayBacked(Pre.class, callbacks -> (entity, renderer, partialRenderTick, matrixStack, buffers, light) -> {
        for (Pre pre : callbacks)
            if (pre.beforeRender(entity, renderer, partialRenderTick, matrixStack, buffers, light))
                return true;
        return false;
    });

    Event<Post> POST = EventFactory.createArrayBacked(Post.class, callbacks -> (entity, renderer, partialRenderTick, matrixStack, buffers, light) -> {
        for (Post post : callbacks)
            post.afterRender(entity, renderer, partialRenderTick, matrixStack, buffers, light);
    });


    @FunctionalInterface
    interface Pre {
        boolean beforeRender(class_1309 entity, class_922<?, ?> renderer, float partialRenderTick, class_4587 matrixStack, class_4597 buffers, int light);
    }

    @FunctionalInterface
    interface Post {
        void afterRender(class_1309 entity, class_922<?, ?> renderer, float partialRenderTick, class_4587 matrixStack, class_4597 buffers, int light);
    }
}