package mods.flammpfeil.slashblade.ability;

import mods.flammpfeil.slashblade.capability.inputstate.CapabilityInputState;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.event.handler.InputCommandEvent;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.item.SwordType;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.combo.ComboState;
import mods.flammpfeil.slashblade.slasharts.SlashArts;
import mods.flammpfeil.slashblade.util.InputCommand;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_234;
import net.minecraft.class_236;
import net.minecraft.class_2398;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5819;
import java.util.EnumSet;
import java.util.Map;

public class SuperSlashArts {
    private static final class SingletonHolder {
        private static final SuperSlashArts instance = new SuperSlashArts();
    }

    public static SuperSlashArts getInstance() {
        return SingletonHolder.instance;
    }

    private SuperSlashArts() {
    }

    public void register() {
        InputCommandEvent.CALLBACK.register(this::onInputChange);
    }

    public void onInputChange(InputCommandEvent event) {

        EnumSet<InputCommand> old = event.getOld();
        EnumSet<InputCommand> current = event.getCurrent();
        class_3222 sender = event.getEntity();

        InputCommand targetCommnad = InputCommand.SPRINT;

        boolean onDown = !old.contains(targetCommnad) && current.contains(targetCommnad);
        class_5819 random = sender.method_59922();
        final Long pressTime = event.getState().getLastPressTime(targetCommnad);
        if (onDown) {

            CapabilityInputState.INPUT_STATE.maybeGet(sender).ifPresent(input -> {
                input.getScheduler().schedule("sendPartical", pressTime + 5, (rawEntity, queue, now) -> {

                    if (!(rawEntity instanceof class_3222))
                        return;
                    class_3222 entity = (class_3222) rawEntity;

                    InputCommand targetCommnad1 = InputCommand.SPRINT;
                    boolean inputSucceed = CapabilityInputState.INPUT_STATE.maybeGet(entity)
                            .filter(input1 -> input1.getCommands().contains(targetCommnad1)
                                    && (!InputCommand.anyMatch(input1.getCommands(), InputCommand.move)
                                    || !input1.getCommands().contains(InputCommand.SNEAK))
                                    && input1.getLastPressTime(targetCommnad1) == pressTime)
                            .isPresent();
                    if (!inputSucceed)
                        return;
                    class_1799 mainHandItem = entity.method_6047();
                    CapabilitySlashBlade.getBladeState(mainHandItem).ifPresent((state) -> {
                        if (state.isBroken() || state.getDamage() > 0 || state.isSealed()
                                || !SwordType.from(mainHandItem).contains(SwordType.BEWITCHED)
                                || !SwordType.from(mainHandItem).contains(SwordType.FIERCEREDGE))
                            return;

                        if (!entity.method_24828())
                            return;
                        for (int i = 0; i < 32; ++i) {
                            double xDist = (random.method_43057() * 2.0F - 1.0F);
                            double yDist = (random.method_43057() * 2.0F - 1.0F);
                            double zDist = (random.method_43057() * 2.0F - 1.0F);
                            if (!(xDist * xDist + yDist * yDist + zDist * zDist > 1.0D)) {
                                double x = sender.method_23316(xDist / 4.0D);
                                double y = sender.method_23323(0.5D + yDist / 4.0D);
                                double z = sender.method_23324(zDist / 4.0D);
                                ((class_3218) event.getEntity().method_37908()).method_14199(
                                        class_2398.field_23190, x, y, z, 0, xDist, yDist + 0.2D, zDist, 1);
                            }
                        }
                    });
                });
                input.getScheduler().schedule("chargeSuperSA", pressTime + 20, new class_234<class_1309>() {

                    @Override
                    public void handle(class_1309 rawEntity, class_236<class_1309> queue, long now) {
                        if (!(rawEntity instanceof class_3222))
                            return;
                        class_3222 entity = (class_3222) rawEntity;

                        InputCommand targetCommnad = InputCommand.SPRINT;
                        boolean inputSucceed = CapabilityInputState.INPUT_STATE.maybeGet(entity)
                                .filter(input -> input.getCommands().contains(targetCommnad)
                                        && (!InputCommand.anyMatch(input.getCommands(), InputCommand.move)
                                        || !input.getCommands().contains(InputCommand.SNEAK))
                                        && input.getLastPressTime(targetCommnad) == pressTime)
                                .isPresent();
                        if (!inputSucceed)
                            return;

                        releaseSSA(entity);
                    }

                });
            });
        }
    }

    public static void releaseSSA(class_3222 entity) {
        class_1799 mainHandItem = entity.method_6047();
        CapabilitySlashBlade.getBladeState(mainHandItem).ifPresent((state) -> {
            if (state.isBroken() || state.getDamage() > 0 || state.isSealed()
                    || !SwordType.from(mainHandItem).contains(SwordType.BEWITCHED)
                    || !SwordType.from(mainHandItem).contains(SwordType.FIERCEREDGE))
                return;

            if (!entity.method_24828())
                return;

            mainHandItem.method_7956(mainHandItem.method_7936() / 2, entity.method_51469(), entity,
                    ItemSlashBlade.getOnBroken(mainHandItem, entity));

            Map.Entry<Integer, class_2960> currentloc = state.resolvCurrentComboStateTicks(entity);

            ComboState currentCS = ComboStateRegistry.COMBO_STATE.method_10223(currentloc.getValue());

            class_2960 csloc = state.getSlashArts().doArts(SlashArts.ArtsType.Super, entity);
            ComboState cs = ComboStateRegistry.COMBO_STATE.method_10223(csloc);
            if (csloc != ComboStateRegistry.getId(ComboStateRegistry.NONE) && !currentloc.getValue().equals(csloc)) {

                if (currentCS.getPriority() > cs.getPriority()) {
                    state.updateComboSeq(entity, csloc);
                }
            }
        });
    }
}
