package mods.flammpfeil.slashblade.emi.mixin;

import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.ItemEmiStack;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.class_1799;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static mods.flammpfeil.slashblade.compat.emi.EMIUtils.SLASHBLADE_COMPARISON;

@Mixin(ItemEmiStack.class)
public abstract class MixinItemEmiStack extends EmiStack {
    @Unique
    public class_1799 slashBlade_Resharped$origionalStack;

    @Inject(method = "<init>(Lnet/minecraft/world/item/ItemStack;)V", at = @At("TAIL"))
    private void onConstructor(class_1799 stack, CallbackInfo ci) {
        if (stack.method_7909() instanceof ItemSlashBlade) {
            this.slashBlade_Resharped$origionalStack = stack.method_7972();
            this.slashBlade_Resharped$origionalStack.method_7974(0);
            this.comparison = SLASHBLADE_COMPARISON;
        }
    }

    @Inject(method = "getItemStack()Lnet/minecraft/world/item/ItemStack;", at = @At("TAIL"), cancellable = true)
    public void getItemStack(CallbackInfoReturnable<class_1799> cir) {
        if (this.slashBlade_Resharped$origionalStack != null)
            cir.setReturnValue(this.slashBlade_Resharped$origionalStack.method_7972());

    }

    @Inject(remap = false, method = "copy()Ldev/emi/emi/api/stack/EmiStack;", at = @At("TAIL"), cancellable = true)
    public void copy(CallbackInfoReturnable<EmiStack> cir) {
        if (this.slashBlade_Resharped$origionalStack != null) {
            EmiStack origin = cir.getReturnValue();
            EmiStack stack = new ItemEmiStack(this.slashBlade_Resharped$origionalStack);
            stack.setChance(origin.getChance())
                    .setRemainder(origin.getRemainder().copy())
                    .comparison(SLASHBLADE_COMPARISON);

            cir.setReturnValue(stack);
        }
    }

}