package mods.flammpfeil.slashblade.init;

import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.item.*;
import mods.flammpfeil.slashblade.registry.SlashArtsRegistry;
import mods.flammpfeil.slashblade.registry.SpecialEffectsRegistry;
import mods.flammpfeil.slashblade.registry.specialeffects.SpecialEffect;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.Objects;

import static mods.flammpfeil.slashblade.SlashBladeConfig.TRAPEZOHEDRON_MAX_REFINE;

public class SBItems {
    public static void init() {

    }

    public static final class_1792 proudsoul = register("proudsoul", new ItemProudSoul(new class_1792.class_1793()) {
        @Override
        public int getEnchantmentValue(class_1799 stack) {
            return 50;
        }
    });
    public static final class_1792 proudsoul_ingot = register("proudsoul_ingot", new ItemProudSoul(new class_1792.class_1793()) {
        @Override
        public int getEnchantmentValue(class_1799 stack) {
            return 100;
        }
    });
    public static final class_1792 proudsoul_tiny = register("proudsoul_tiny", new ItemProudSoul(new class_1792.class_1793()) {
        @Override
        public int getEnchantmentValue(class_1799 stack) {
            return 10;
        }
    });
    public static final class_1792 proudsoul_sphere = register("proudsoul_sphere", new ItemProudSoul(new class_1792.class_1793().method_7894(class_1814.field_8907)) {
        @Override
        public int getEnchantmentValue(class_1799 stack) {
            return 150;
        }

        @Override
        public void method_7851(@NotNull class_1799 stack, @NotNull class_9635 context, @NotNull List<class_2561> components, @NotNull class_1836 flag) {
            class_9279 data = stack.method_57824(class_9334.field_49628);
            if (data != null) {
                class_2487 tag = data.method_57461();
                if (tag.method_10545("SpecialAttackType")) {
                    class_2960 SA = class_2960.method_60654(tag.method_10558("SpecialAttackType"));
                    if (SlashArtsRegistry.SLASH_ARTS.method_10250(SA) && !Objects.equals(SlashArtsRegistry.SLASH_ARTS.method_10223(SA), SlashArtsRegistry.NONE)) {
                        components.add(class_2561.method_43469("slashblade.tooltip.slash_art", SlashArtsRegistry.SLASH_ARTS.method_10223(SA).getDescription()).method_27692(class_124.field_1080));
                    }
                }
            }
            super.method_7851(stack, context, components, flag);
        }
    });
    public static final class_1792 proudsoul_crystal = register("proudsoul_crystal", new ItemProudSoul(new class_1792.class_1793().method_7894(class_1814.field_8903)) {
        @Override
        public int getEnchantmentValue(class_1799 stack) {
            return 200;
        }

        @Override
        @Environment(EnvType.CLIENT)
        public void method_7851(@NotNull class_1799 stack, @NotNull class_9635 context, @NotNull List<class_2561> components, @NotNull class_1836 flag) {
            class_9279 data = stack.method_57824(class_9334.field_49628);
            if (data != null) {
                class_2487 tag = data.method_57461();
                if (tag.method_10545("SpecialEffectType")) {
                    class_310 mcinstance = class_310.method_1551();
                    class_1657 player = mcinstance.field_1724;
                    class_2960 se = class_2960.method_60654(tag.method_10558("SpecialEffectType"));
                    if (SpecialEffectsRegistry.SPECIAL_EFFECT.method_10250(se)) {
                        components.add(class_2561.method_43469("slashblade.tooltip.special_effect", SpecialEffect.getDescription(se),
                                        class_2561.method_43470(String.valueOf(SpecialEffect.getRequestLevel(se)))
                                                .method_27692(SpecialEffect.isEffective(se, player.field_7520) ? class_124.field_1061
                                                        : class_124.field_1063))
                                .method_27692(class_124.field_1080));
                    }
                }
            }
            super.method_7851(stack, context, components, flag);
        }
    });
    public static final class_1792 proudsoul_trapezohedron = register("proudsoul_trapezohedron", new ItemProudSoul(new class_1792.class_1793().method_7894(class_1814.field_8904)) {
        @Override
        public int getEnchantmentValue(class_1799 stack) {
            return TRAPEZOHEDRON_MAX_REFINE.get();
        }
    });

    public static final class_1792 slashblade_wood = register("slashblade_wood", new ItemSlashBladeDetune(new ItemTierSlashBlade(60, 2F), 2, 0.0F,
            new class_1792.class_1793()).setDestructable()
            .setTexture(SlashBlade.prefix("model/wood.png")));
    public static final class_1792 slashblade_bamboo = register("slashblade_bamboo", new ItemSlashBladeDetune(new ItemTierSlashBlade(70, 3F), 3, 0.0F,
            new class_1792.class_1793()).setDestructable()
            .setTexture(SlashBlade.prefix("model/bamboo.png")));
    public static final class_1792 slashblade_silverbamboo = register("slashblade_silverbamboo", new ItemSlashBladeDetune(new ItemTierSlashBlade(40, 3F), 3, 0.0F,
            new class_1792.class_1793()).setTexture(SlashBlade.prefix("model/silverbamboo.png")));
    public static final class_1792 slashblade_white = register("slashblade_white", new ItemSlashBladeDetune(new ItemTierSlashBlade(70, 4F), 4, 0.0F,
            new class_1792.class_1793()).setTexture(SlashBlade.prefix("model/white.png")));

    public static final class_1792 slashblade = register("slashblade", new ItemSlashBlade(new ItemTierSlashBlade(40, 4F), 4, 0.0F, new class_1792.class_1793()));

    public static final class_1792 bladestand_1 = register("bladestand_1", new BladeStandItem((new class_1792.class_1793()).method_7894(class_1814.field_8906)));
    public static final class_1792 bladestand_2 = register("bladestand_2", new BladeStandItem((new class_1792.class_1793()).method_7894(class_1814.field_8906)));
    public static final class_1792 bladestand_v = register("bladestand_v", new BladeStandItem((new class_1792.class_1793()).method_7894(class_1814.field_8906)));
    public static final class_1792 bladestand_s = register("bladestand_s", new BladeStandItem((new class_1792.class_1793()).method_7894(class_1814.field_8906)));
    public static final class_1792 bladestand_1w = register("bladestand_1w", new BladeStandItem((new class_1792.class_1793()).method_7894(class_1814.field_8906), true));
    public static final class_1792 bladestand_2w = register("bladestand_2w", new BladeStandItem((new class_1792.class_1793()).method_7894(class_1814.field_8906), true));

    private static class_1792 register(String name, class_1792 item) {
        return class_2378.method_10230(class_7923.field_41178, SlashBlade.prefix(name), item);
    }
}
