package mods.flammpfeil.slashblade.item;

import cn.sh1rocu.slashblade.api.extension.EntityExtension;
import cn.sh1rocu.slashblade.api.extension.ISlashBladeCapabilityProvider;
import cn.sh1rocu.slashblade.api.extension.ItemSlashBladeExtension;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.SlashBladeConfig;
import mods.flammpfeil.slashblade.capability.inputstate.CapabilityInputState;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.capability.slashblade.SlashBladeState;
import mods.flammpfeil.slashblade.client.renderer.SlashBladeTEISR;
import mods.flammpfeil.slashblade.data.tag.SlashBladeItemTags;
import mods.flammpfeil.slashblade.entity.BladeItemEntity;
import mods.flammpfeil.slashblade.event.SlashBladeEvent;
import mods.flammpfeil.slashblade.init.DefaultResources;
import mods.flammpfeil.slashblade.init.SBEntityTypes;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.combo.ComboState;
import mods.flammpfeil.slashblade.registry.specialeffects.SpecialEffect;
import mods.flammpfeil.slashblade.util.InputCommand;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1856;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3489;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_756;
import net.minecraft.class_7924;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.world.item.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class ItemSlashBlade extends class_1829 implements ItemSlashBladeExtension, ISlashBladeCapabilityProvider {
    protected static final class_2960 PLAYER_REACH_AMPLIFIER = SlashBlade.prefix("player_reach_amplifier");

    public static final List<class_5321<class_1887>> exEnchantment = List.of(class_1893.field_23071, class_1893.field_9103,
            class_1893.field_9129, class_1893.field_9095, class_1893.field_9097);

    protected int attackDamageIn;
    protected float attackSpeedIn;

    public ItemSlashBlade(class_1832 tier, int attackDamageIn, float attackSpeedIn, class_1793 builder) {
        super(tier, builder);
        this.attackDamageIn = attackDamageIn;
        this.attackSpeedIn = attackSpeedIn;
    }

    @Override
    public boolean canBeEnchantedWith(class_1799 stack, class_6880<class_1887> enchantment, EnchantingContext context) {
        if (enchantment.method_40230().isPresent() && exEnchantment.contains(enchantment.method_40230().get()))
            return true;
        return super.canBeEnchantedWith(stack, enchantment, context);
    }

    @Override
    public @Nullable String getCreatorNamespace(class_1799 itemStack) {
        // TODO Auto-generated method stub
        return super.getCreatorNamespace(itemStack);
    }

    @Override
    public @NotNull class_9285 getDefaultAttributeModifiers(@NotNull class_1799 stack) {
        var builder = class_9285.method_57480();

        builder.method_57487(class_5134.field_23723, new class_1322(field_8001, attackSpeedIn, class_1322.class_1323.field_6328), class_9274.field_49217);

        AtomicReference<Double> finalDamage = new AtomicReference<>((double) ((float) attackDamageIn + this.method_8022().method_8028()));

        Optional<ISlashBladeState> state = CapabilitySlashBlade.getBladeState(stack);
        state.ifPresent(s -> {
            // 刀的状态
            var swordType = SwordType.from(stack);
            // 获得基础攻击力
            float baseAttackModifier = s.getBaseAttackModifier();
            // 锻造数
            int refine = s.getRefine();

            float attackAmplifier = s.getAttackAmplifier();
            if (s.isBroken()) {
                // 断刀-0.5伤害
                attackAmplifier = -0.5F - baseAttackModifier;
            } else {
                float refineFactor = swordType.contains(SwordType.FIERCEREDGE) ? 0.1F : 0.05F;
                // 锻造伤害面板增加计算，非线性，收益递减。(理论最大值为额外100%基础攻击)
                attackAmplifier = (1.0F - (1.0F / (1.0F + (refineFactor * refine)))) * baseAttackModifier;
            }

            double damage = (double) baseAttackModifier + attackAmplifier - 1F;

            var event = new SlashBladeEvent.UpdateAttackEvent(stack, s, damage);
            SlashBladeEvent.UPDATE_ATTACK.invoker().onUpdateAttack(event);

            finalDamage.set(event.getNewDamage());

            builder.method_57487(class_5134.field_47759,
                    new class_1322(PLAYER_REACH_AMPLIFIER,
                            s.isBroken() ? ReachModifier.BrokendReach() : ReachModifier.BladeReach(),
                            class_1322.class_1323.field_6328),
                    class_9274.field_49217);

        });

        class_1322 attack = new class_1322(field_8006, finalDamage.get(), class_1322.class_1323.field_6328);
        builder.method_57487(class_5134.field_23721, attack, class_9274.field_49217);

        return builder.method_57486();
    }

    @Override
    public @NotNull class_1814 getRarity(class_1799 stack) {
        EnumSet<SwordType> type = SwordType.from(stack);
        if (type.contains(SwordType.BEWITCHED))
            return class_1814.field_8904;
        if (type.contains(SwordType.ENCHANTED))
            return class_1814.field_8903;
        return class_1814.field_8906;
    }

    @Override
    public int method_7881(class_1799 stack, class_1309 user) {
        return 72000;
    }

    public @NotNull class_1271<class_1799> method_7836(class_1937 worldIn, class_1657 playerIn, class_1268 handIn) {
        class_1799 itemstack = playerIn.method_5998(handIn);
        if (handIn == class_1268.field_5810 && !(playerIn.method_6047().method_7909() instanceof ItemSlashBlade)) {
            return class_1271.method_22430(itemstack);
        }
        boolean result = CapabilitySlashBlade.getBladeState(itemstack).map((state) -> {

            CapabilityInputState.INPUT_STATE.maybeGet(playerIn).ifPresent((s) -> s.getCommands().add(InputCommand.R_CLICK));

            class_2960 combo = state.progressCombo(playerIn);

            CapabilityInputState.INPUT_STATE.maybeGet(playerIn).ifPresent((s) -> s.getCommands().remove(InputCommand.R_CLICK));

            if (!combo.equals(ComboStateRegistry.getId(ComboStateRegistry.NONE)))
                playerIn.method_6104(handIn);

            return true;
        }).orElse(false);

        playerIn.method_6019(handIn);
        return new class_1271<>(result ? class_1269.field_5812 : class_1269.field_5814, itemstack);
    }

    @Override
    public boolean onLeftClickEntity(class_1799 itemstack, class_1657 playerIn, class_1297 entity) {
        Optional<ISlashBladeState> stateHolder = CapabilitySlashBlade.getBladeState(itemstack)
                .filter((state) -> !state.onClick());

        stateHolder.ifPresent((state) -> {
            CapabilityInputState.INPUT_STATE.maybeGet(playerIn).ifPresent((s) -> s.getCommands().add(InputCommand.L_CLICK));

            state.progressCombo(playerIn);

            CapabilityInputState.INPUT_STATE.maybeGet(playerIn).ifPresent((s) -> s.getCommands().remove(InputCommand.L_CLICK));
        });

        return stateHolder.isPresent();
    }

    public static final String BREAK_ACTION_TIMEOUT = "BreakActionTimeout";

    @Override
    public void setDamage(class_1799 stack, int damage) {
        int maxDamage = stack.method_7936();
        if (maxDamage < 0)
            return;
        var state = CapabilitySlashBlade.getBladeState(stack).orElseThrow(NullPointerException::new);
        if (state.isBroken()) {
            if (damage <= 0 && !state.isSealed()) {
                state.setBroken(false);
            } else if (maxDamage < damage) {
                damage = Math.min(damage, maxDamage - 1);
            }
        }
        state.setDamage(damage);
    }

    @Override
    public <T extends class_1309> int damageItem(class_1799 stack, int amount, @Nullable T entity, Consumer<class_1792> onBroken) {
        if (stack.method_7936() <= 0)
            return 0;

        if (amount <= 0)
            return 0;

        var cap = CapabilitySlashBlade.getBladeState(stack).orElseThrow(NullPointerException::new);
        boolean current = cap.isBroken();

        if (stack.method_7919() + amount >= stack.method_7936()) {
            amount = 0;
            stack.method_7974(stack.method_7936() - 1);
            SlashBladeEvent.BreakEvent event = new SlashBladeEvent.BreakEvent(stack, cap);
            SlashBladeEvent.BREAK.invoker().onBreak(event);
            cap.setBroken(!event.isCanceled());
        }

        if (current != cap.isBroken()) {
            onBroken.accept(stack.method_7909());
            if (entity instanceof class_3222 player) {
                // stack.getShareTag();
                class_174.field_1198.method_8821(player, stack);
            }

            if (entity instanceof class_1657 player)
                player.method_7259(class_3468.field_15383.method_14956(stack.method_7909()));
        }

        if (cap.isBroken() && this.isDestructable(stack))
            stack.method_7934(1);

        return amount;
    }

    public static Consumer<class_1792> getOnBroken(class_1799 stack, class_1309 user) {
        return (item) -> {
            user.method_20235(item, class_1304.field_6173);

            var state = CapabilitySlashBlade.getBladeState(stack).orElseThrow(NullPointerException::new);
            if (stack.method_7942()) {
                int count = state.getProudSoulCount() >= SlashBladeConfig.MAX_ENCHANTED_PROUDSOUL_DROP.get() * 100 ?
                        SlashBladeConfig.MAX_ENCHANTED_PROUDSOUL_DROP.get() : Math.max(1, state.getProudSoulCount() / 100);
                List<class_5321<class_1887>> enchantments = user.method_56673().method_46762(class_7924.field_41265).method_46754()
                        .filter(enchantment ->
                                stack.canBeEnchantedWith(user.method_56673().method_46762(class_7924.field_41265).method_46747(enchantment), EnchantingContext.ACCEPTABLE))
                        .filter(enchantment -> !SlashBladeConfig.NON_DROPPABLE_ENCHANTMENT.get()
                                .contains(enchantment.method_29177().toString()))
                        .toList();
                for (int i = 0; i < count; i += 1) {
                    class_1799 enchanted_soul = new class_1799(SBItems.proudsoul_tiny);
                    var enchant = user.method_56673().method_46762(class_7924.field_41265).method_46746(enchantments.get(user.method_59922().method_43051(0, enchantments.size())));
                    if (enchant.isPresent()) {
                        enchanted_soul.method_7978(enchant.get(), 1);
                        class_1542 itemEntity = new class_1542(user.method_37908(), user.method_23317(), user.method_23318(), user.method_23321(),
                                enchanted_soul);
                        itemEntity.method_6988();
                        user.method_37908().method_8649(itemEntity);
                    }
                    state.setProudSoulCount(state.getProudSoulCount() - 100);
                }
            }
            class_1799 soul = new class_1799(SBItems.proudsoul_tiny);

            int count = state.getProudSoulCount() >= SlashBladeConfig.MAX_PROUDSOUL_DROP.get() * 100 ?
                    SlashBladeConfig.MAX_PROUDSOUL_DROP.get() : Math.max(1, state.getProudSoulCount() / 100);

            soul.method_7939(count);
            state.setProudSoulCount(state.getProudSoulCount() - (count * 100));

            class_1542 itementity = new class_1542(user.method_37908(), user.method_23317(), user.method_23318(), user.method_23321(), soul);
            BladeItemEntity e = new BladeItemEntity(SBEntityTypes.BladeItem, user.method_37908()) {
                static final String isReleased = "isReleased";

                @Override
                public boolean method_5747(float distance, float damageMultiplier, class_1282 ds) {

                    class_2487 tag = this.sb$getPersistentData();

                    if (!tag.method_10577(isReleased)) {
                        this.sb$getPersistentData().method_10556(isReleased, true);

                        if (this.method_37908() instanceof class_3218) {
                            class_1297 thrower = method_24921();

                            if (thrower != null) {
                                ((EntityExtension) thrower).sb$getPersistentData().method_10551(BREAK_ACTION_TIMEOUT);
                            }
                        }
                    }

                    return super.method_5747(distance, damageMultiplier, ds);
                }
            };

            e.method_5878(itementity);
            e.init();
            e.method_5762(0, 0.4, 0);

            e.setModel(state.getModel().orElse(DefaultResources.resourceDefaultModel));
            e.setTexture(state.getTexture().orElse(DefaultResources.resourceDefaultTexture));

            e.method_6982(20 * 2);
            e.method_5834(true);

            e.method_5855(-1);

            e.method_6981(user);

            user.method_37908().method_8649(e);

            ((EntityExtension) user).sb$getPersistentData().method_10544(BREAK_ACTION_TIMEOUT, user.method_37908().method_8510() + 20 * 5);
        };
    }

    @Override
    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {

        CapabilitySlashBlade.getBladeState(stack).ifPresent((state) -> {
            class_2960 loc = state.resolvCurrentComboState(attacker);
            ComboState cs = ComboStateRegistry.COMBO_STATE.method_10223(loc) != null
                    ? ComboStateRegistry.COMBO_STATE.method_10223(loc)
                    : ComboStateRegistry.NONE;

            SlashBladeEvent.HitEvent event = new SlashBladeEvent.HitEvent(stack, state, target, attacker);
            SlashBladeEvent.HIT.invoker().onHit(event);
            if (event.isCanceled())
                return;

            cs.hitEffect(target, attacker);
            if (attacker.method_37908() instanceof class_3218 serverLevel) {
                var serverPlayer = attacker instanceof class_3222 sp ? sp : null;
                stack.method_7956(1, serverLevel, serverPlayer, ItemSlashBlade.getOnBroken(stack, attacker));
            }
        });

        return true;
    }

    public boolean method_7879(class_1799 stack, class_1937 worldIn, class_2680 state, class_2338 pos,
                             class_1309 entityLiving) {

        if (state.method_26214(worldIn, pos) != 0.0F) {
            CapabilitySlashBlade.getBladeState(stack).ifPresent((s) -> {
                if (entityLiving.method_37908() instanceof class_3218 serverLevel) {
                    var serverPlayer = entityLiving instanceof class_3222 sp ? sp : null;
                    stack.method_7956(1, serverLevel, serverPlayer, ItemSlashBlade.getOnBroken(stack, entityLiving));
                }
            });
        }

        return true;
    }

    @Override
    public void method_7840(class_1799 stack, class_1937 worldIn, class_1309 entityLiving, int timeLeft) {
        int elapsed = this.method_7881(stack, entityLiving) - timeLeft;

        if (!worldIn.method_8608()) {

            CapabilitySlashBlade.getBladeState(stack).ifPresent((state) -> {

                var swordType = SwordType.from(stack);
                if (state.isBroken() || state.isSealed() || !(swordType.contains(SwordType.ENCHANTED)))
                    return;

                class_2960 sa = state.doChargeAction(entityLiving, elapsed);
                boolean isCreative = false;
                // sa.tickAction(entityLiving);
                if (!sa.equals(ComboStateRegistry.getId(ComboStateRegistry.NONE))) {
                    if (entityLiving instanceof class_1657 player) {
                        isCreative = player.method_31549().field_7477;
                    }
                    if (!isCreative) {
                        var cost = state.getSlashArts().getProudSoulCost();
                        if (state.getProudSoulCount() >= cost)
                            state.setProudSoulCount(state.getProudSoulCount() - cost);
                        else {
                            if (entityLiving.method_37908() instanceof class_3218 serverLevel) {
                                var serverPlayer = entityLiving instanceof class_3222 sp ? sp : null;
                                stack.method_7956(1, serverLevel, serverPlayer, ItemSlashBlade.getOnBroken(stack, entityLiving));
                            }
                        }
                    }
                    entityLiving.method_6104(class_1268.field_5808);
                }
            });
        }
    }

    @Override
    public void method_7852(class_1937 level, class_1309 player, class_1799 stack, int count) {

        CapabilitySlashBlade.getBladeState(stack).ifPresent((state) -> {

            (ComboStateRegistry.COMBO_STATE.method_10223(state.getComboSeq()) != null
                    ? ComboStateRegistry.COMBO_STATE.method_10223(state.getComboSeq())
                    : ComboStateRegistry.NONE).holdAction(player);
            var swordType = SwordType.from(stack);
            if (state.isBroken() || state.isSealed() || !(swordType.contains(SwordType.ENCHANTED)))
                return;
            if (!player.method_37908().method_8608()) {
                int ticks = player.method_6048();
                int fullChargeTicks = state.getFullChargeTicks(player);
                if (0 < ticks) {
                    if (ticks == fullChargeTicks) {// state.getFullChargeTicks(player)){
                        class_243 pos = player.method_5836(1.0f).method_1019(player.method_5720());
                        ((class_3218) player.method_37908()).method_14199(class_2398.field_11214, pos.field_1352, pos.field_1351, pos.field_1350, 7, 0.7,
                                0.7, 0.7, 0.02);
                    }
                }
            }
        });
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 worldIn, class_1297 entityIn, int itemSlot, boolean isSelected) {
        super.method_7888(stack, worldIn, entityIn, itemSlot, isSelected);

        if (stack == null)
            return;
        if (entityIn == null)
            return;

        CapabilitySlashBlade.getBladeState(stack).ifPresent((state) -> {
            SlashBladeEvent.UpdateEvent event = new SlashBladeEvent.UpdateEvent(stack, state, worldIn, entityIn, itemSlot, isSelected);
            SlashBladeEvent.UPDATE.invoker().onUpdate(event);
            if (event.isCanceled())
                return;

            if (!isSelected) {
                var swordType = SwordType.from(stack);
                if (entityIn instanceof class_1657 player) {
                    if (!SlashBladeConfig.SELF_REPAIR_ENABLE.get())
                        return;
                    boolean hasHunger = player.method_6059(class_1294.field_5903) && SlashBladeConfig.HUNGER_CAN_REPAIR.get();
                    if (swordType.contains(SwordType.BEWITCHED) || hasHunger) {
                        if (stack.method_7919() > 0 && player.method_7344().method_7586() > 0) {
                            int hungerAmplifier = hasHunger ? player.method_6112(class_1294.field_5903).method_5578() : 0;
                            int level = 1 + hungerAmplifier;
                            Boolean expCostFlag = SlashBladeConfig.SELF_REPAIR_COST_EXP.get();
                            int expCost = SlashBladeConfig.BEWITCHED_EXP_COST.get() * level;

                            if (expCostFlag && player.field_7520 < expCost)
                                return;

                            player.method_7255(expCostFlag ? -expCost : 0);
                            player.method_7322(
                                    SlashBladeConfig.BEWITCHED_HUNGER_EXHAUSTION.get().floatValue() * level);
                            stack.method_7974(stack.method_7919() - level);
                        }
                    }
                }
            }
            if (entityIn instanceof class_1309 living) {
                CapabilityInputState.INPUT_STATE.maybeGet(entityIn).ifPresent(mInput -> {
                    mInput.getScheduler().onTick(living);
                });

                /*
                 * if(0.5f > state.getDamage()) state.setDamage(0.99f);
                 */
                class_2960 loc = state.resolvCurrentComboState(living);
                ComboState cs = ComboStateRegistry.COMBO_STATE.method_10223(loc) != null
                        ? ComboStateRegistry.COMBO_STATE.method_10223(loc)
                        : ComboStateRegistry.NONE;

                if (isInMainhand(stack, isSelected, living))
                    cs.tickAction(living);
                else if (!loc.equals(state.getComboRoot()))
                    state.setComboSeq(state.getComboRoot());
            }
        });
    }

    public static boolean isInMainhand(class_1799 stack, boolean isSelected, class_1309 living) {
        return isSelected && stack.equals(living.method_6047()/*, false*/);
    }

//    @Nullable
//    @Override
//    public CompoundTag getShareTag(ItemStack stack) {
//        var tag = stack.getOrCreateTag();
//        CapabilitySlashBlade.BLADESTATE.maybeGet(stack).ifPresent(state -> {
//            if (!state.isEmpty())
//                tag.put("bladeState", state.serializeNBT());
//        });
//        return tag;
//    }
//
//    @Override
//    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
//        if (nbt != null) {
//            if (nbt.contains("bladeState"))
//                CapabilitySlashBlade.BLADESTATE.maybeGet(stack).ifPresent(state -> state.deserializeNBT(nbt.getCompound("bladeState")));
//        }
//        super.readShareTag(stack, nbt);
//    }

    // damage ----------------------------------------------------------

    @Override
    public int getDamage(class_1799 stack) {
        return CapabilitySlashBlade.getBladeState(stack).filter(s -> !s.isEmpty()).map(ISlashBladeState::getDamage).orElse(0);
    }

    @Override
    public int getMaxDamage(class_1799 stack) {
        return CapabilitySlashBlade.getBladeState(stack).filter(s -> !s.isEmpty()).map(ISlashBladeState::getMaxDamage).orElse(this.method_8022().method_8025());
    }

    @Override
    public boolean method_31567(class_1799 stack) {
        return false;
    }

    @Override
    public String method_7866(class_1799 stack) {
        return CapabilitySlashBlade.getBladeState(stack).filter((s) -> !s.getTranslationKey().isBlank())
                .map(ISlashBladeState::getTranslationKey).orElseGet(() -> stackDefaultDescriptionId(stack));
    }

    private String stackDefaultDescriptionId(class_1799 stack) {
        var cap = CapabilitySlashBlade.getBladeState(stack);
        if (cap.isEmpty())
            return super.method_7866(stack);
        String key = cap.get().getTranslationKey();
        return !key.isBlank() ? key : super.method_7866(stack);
    }

    public boolean isDestructable(class_1799 stack) {
        return false;
    }

    @Override
    public boolean method_7878(class_1799 toRepair, class_1799 repair) {

        if (class_1856.method_8106(class_3489.field_23802).method_8093(repair)) {
            return true;
        }

        /*
         * Tag<Item> tags = ItemTags.getCollection().get(new
         * ResourceLocation("slashblade","proudsouls"));
         *
         * if(tags != null){ boolean result = Ingredient.fromTag(tags).test(repair); }
         */

        // todo: repair custom material
        if (repair.method_31573(SlashBladeItemTags.PROUD_SOULS))
            return true;
        return super.method_7878(toRepair, repair);
    }

    RangeMap<Comparable<?>, Object> refineColor = ImmutableRangeMap.builder()
            .put(Range.lessThan(10), class_124.field_1080).put(Range.closedOpen(10, 50), class_124.field_1054)
            .put(Range.closedOpen(50, 100), class_124.field_1060).put(Range.closedOpen(100, 150), class_124.field_1075)
            .put(Range.closedOpen(150, 200), class_124.field_1078).put(Range.atLeast(200), class_124.field_1076)
            .build();

    @Environment(EnvType.CLIENT)
    @Override
    public void method_7851(@NotNull class_1799 stack, @NotNull class_9635 context, @NotNull List<class_2561> tooltip, @NotNull class_1836 flagIn) {
        CapabilitySlashBlade.getBladeState(stack).ifPresent(s -> {
            this.appendSwordType(stack, context, tooltip, flagIn); // √
            this.appendProudSoulCount(tooltip, stack, s);
            this.appendKillCount(tooltip, stack, s);
            this.appendSlashArt(stack, tooltip, s); // √
            this.appendRefineCount(tooltip, stack, s);
            this.appendSpecialEffects(tooltip, s); // √
        });

        super.method_7851(stack, context, tooltip, flagIn);
    }

    @Environment(EnvType.CLIENT)
    public void appendSlashArt(class_1799 stack, List<class_2561> tooltip, @NotNull ISlashBladeState s) {
        var swordType = SwordType.from(stack);
        if (swordType.contains(SwordType.BEWITCHED) && !swordType.contains(SwordType.SEALED)) {
            tooltip.add(class_2561.method_43469("slashblade.tooltip.slash_art", s.getSlashArts().getDescription())
                    .method_27692(class_124.field_1080));
        }
    }

    @Environment(EnvType.CLIENT)
    public void appendRefineCount(List<class_2561> tooltip, @NotNull class_1799 stack, @NotNull ISlashBladeState s) {
        int refine = s.getRefine();
        if (refine > 0) {
            tooltip.add(class_2561.method_43469("slashblade.tooltip.refine", refine)
                    .method_27692((class_124) refineColor.get(refine)));
        }
    }

    @Environment(EnvType.CLIENT)
    public void appendProudSoulCount(List<class_2561> tooltip, @NotNull class_1799 stack, @NotNull ISlashBladeState s) {
        int proudsoul = s.getProudSoulCount();
        if (proudsoul > 0) {
            class_5250 countComponent = class_2561.method_43469("slashblade.tooltip.proud_soul", proudsoul)
                    .method_27692(class_124.field_1080);
            if (proudsoul > 10000)
                countComponent = countComponent.method_27692(class_124.field_1064);
            tooltip.add(countComponent);
        }
    }

    @Environment(EnvType.CLIENT)
    public void appendKillCount(List<class_2561> tooltip, @NotNull class_1799 stack, @NotNull ISlashBladeState s) {
        int killCount = s.getKillCount();
        if (killCount > 0) {
            class_5250 killCountComponent = class_2561.method_43469("slashblade.tooltip.killcount", killCount)
                    .method_27692(class_124.field_1080);
            if (killCount > 1000)
                killCountComponent = killCountComponent.method_27692(class_124.field_1064);
            tooltip.add(killCountComponent);
        }
    }

    @Environment(EnvType.CLIENT)
    public void appendSpecialEffects(List<class_2561> tooltip, @NotNull ISlashBladeState s) {
        if (s.getSpecialEffects().isEmpty())
            return;

        class_310 mcinstance = class_310.method_1551();
        class_1657 player = mcinstance.field_1724;

        s.getSpecialEffects().forEach(se -> {

            boolean showingLevel = SpecialEffect.getRequestLevel(se) > 0;

            tooltip.add(class_2561.method_43469("slashblade.tooltip.special_effect", SpecialEffect.getDescription(se),
                            class_2561.method_43470(showingLevel ? String.valueOf(SpecialEffect.getRequestLevel(se)) : "")
                                    .method_27692(SpecialEffect.isEffective(se, player.field_7520) ? class_124.field_1061
                                            : class_124.field_1063))
                    .method_27692(class_124.field_1080));
        });
    }

    @Environment(EnvType.CLIENT)
    public void appendSwordType(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 flagIn) {
        var swordType = SwordType.from(stack);
        boolean goldenFlag = swordType.containsAll(List.of(SwordType.SOULEATER, SwordType.FIERCEREDGE));
        if (swordType.contains(SwordType.SEALED)) return;
        if (swordType.contains(SwordType.BEWITCHED)) {
            tooltip.add(
                    class_2561.method_43471("slashblade.sword_type.bewitched")
                            .method_27692(goldenFlag ? class_124.field_1065 : class_124.field_1064));
        } else if (swordType.contains(SwordType.ENCHANTED)) {
            tooltip.add(class_2561.method_43471("slashblade.sword_type.enchanted").method_27692(class_124.field_1062));
        } else {
            tooltip.add(class_2561.method_43471("slashblade.sword_type.noname").method_27692(class_124.field_1063));
        }
    }

    /**
     * @return true = cancel : false = swing
     */
    @Override
    public boolean onEntitySwing(class_1799 stack, class_1309 entity) {
        return CapabilitySlashBlade.getBladeState(stack).filter(s -> s.getLastActionTime() == entity.method_37908().method_8510())
                .isEmpty();
    }

    @Override
    public boolean hasCustomEntity(class_1799 stack) {
        return true;
    }

    /**
     * 原来的方法替换掉落实体时无法Copy假物品实体相关的NBT，因为获取物品指令是先生成的物品实体再设置的假物品
     */
    @Override
    public boolean onEntityItemUpdate(class_1799 stack, class_1542 entity) {
        if (!(entity instanceof BladeItemEntity)) {
            class_1937 world = entity.method_37908();
            BladeItemEntity e = new BladeItemEntity(SBEntityTypes.BladeItem, world);
            e.method_5878(entity);
            e.init();
            entity.method_31472();
            world.method_8649(e);
        }
        return false;
    }

/*    @Override
    public int getEntityLifespan(ItemStack itemStack, Level world) {
        return super.getEntityLifespan(itemStack, world);// Short.MAX_VALUE;
    }*/

    @Environment(EnvType.CLIENT)
    @Override
    public class_756 getCustomRenderer() {
        return SlashBladeTEISR.INSTANCE;
    }

    @Override
    public SlashBladeState initCapability(class_1799 stack) {
        return new SlashBladeState(stack);
    }
}
