package mods.flammpfeil.slashblade.network;

import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.event.BladeMotionEvent;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4844;
import net.minecraft.class_742;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.UUID;

public record MotionBroadcastPacket(UUID playerId, String combo) implements class_8710 {
    private static final class_2960 ID = SlashBlade.prefix("s2c_motion_broadcast");
    public static final class_9154<MotionBroadcastPacket> TYPE = new class_9154<>(ID);

    public static final class_9139<class_9129, MotionBroadcastPacket> STREAM_CODEC = class_9139.method_56435(
            class_4844.field_48453,
            MotionBroadcastPacket::playerId,
            class_9135.field_48554,
            MotionBroadcastPacket::combo,
            MotionBroadcastPacket::new
    );

    @Environment(EnvType.CLIENT)
    public static void handle(MotionBroadcastPacket payload, ClientPlayNetworking.Context context) {
        context.client().execute(() -> setPoint(payload.playerId, payload.combo));
    }

    @Environment(EnvType.CLIENT)
    public static void setPoint(UUID playerId, String combo) {
        if (class_310.method_1551().field_1687 == null) return;
        class_1657 target = class_310.method_1551().field_1687.method_18470(playerId);

        if (target == null)
            return;
        if (!(target instanceof class_742))
            return;

        class_2960 state = class_2960.method_12829(combo);
        if (state == null || !ComboStateRegistry.COMBO_STATE.method_10250(state))
            return;

        BladeMotionEvent.CALLBACK.invoker().onBladeMotion(new BladeMotionEvent(target, state));
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}