/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.capability.concentrationrank;

import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import java.util.Optional;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.network.RankSyncPacket;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;

public interface IConcentrationRank
extends AutoSyncedComponent {
    public long getRawRankPoint();

    public void setRawRankPoint(long var1);

    public long getLastUpdate();

    public void setLastUpdate(long var1);

    public long getLastRankRise();

    public void setLastRankRise(long var1);

    public long getUnitCapacity();

    default public long getMaxCapacity() {
        return (long)(ConcentrationRanks.MAX_LEVEL * (float)this.getUnitCapacity()) - 1L;
    }

    default public ConcentrationRanks getRank(long time) {
        return ConcentrationRanks.getRankFromLevel(this.getRankLevel(time));
    }

    default public long reductionLimitter(long reduction) {
        long limit = this.getRawRankPoint() % this.getUnitCapacity();
        return Math.min(reduction, limit);
    }

    default public float getRankLevel(long currentTime) {
        return (float)this.getRankPoint(currentTime) / (float)this.getUnitCapacity();
    }

    default public float getRankProgress(long currentTime) {
        float level = this.getRankLevel(currentTime);
        Range<Float> range = this.getRank((long)currentTime).pointRange;
        double bottom = range.hasLowerBound() ? (double)((Float)range.lowerEndpoint()).floatValue() : 0.0;
        double top = range.hasUpperBound() ? (double)((Float)range.upperEndpoint()).floatValue() : Math.floor(bottom + 1.0);
        double len = top - bottom;
        return (float)(((double)level - bottom) / len);
    }

    default public long getRankPoint(long time) {
        long reduction = time - this.getLastUpdate();
        return this.getRawRankPoint() - this.reductionLimitter(reduction);
    }

    default public void addRankPoint(class_1309 user, long point) {
        long time = user.method_37908().method_8510();
        ConcentrationRanks oldRank = this.getRank(time);
        this.setRawRankPoint(Math.min(Math.max(0L, point + this.getRankPoint(time)), this.getMaxCapacity()));
        this.setLastUpdate(time);
        if (oldRank.level < this.getRank((long)time).level) {
            this.setLastRankRise(time);
        }
        if (user instanceof class_3222 && !user.method_37908().method_8608()) {
            if (((class_3222)user).field_13987 == null) {
                return;
            }
            ServerPlayNetworking.send((class_3222)((class_3222)user), (class_8710)new RankSyncPacket(this.getRawRankPoint()));
        }
    }

    default public void addRankPoint(class_1282 src) {
        if (!(src.method_5529() instanceof class_1309)) {
            return;
        }
        class_1309 user = (class_1309)src.method_5529();
        class_1799 stack = user.method_6047();
        Optional<class_2960> combo = CapabilitySlashBlade.getBladeState(stack).map(s -> s.resolvCurrentComboState(user));
        float modifier = combo.map(this::getRankPointModifier).orElse(Float.valueOf(this.getRankPointModifier(src))).floatValue();
        this.addRankPoint(user, (long)(modifier * (float)this.getUnitCapacity()));
    }

    public float getRankPointModifier(class_1282 var1);

    public float getRankPointModifier(class_2960 var1);

    public static enum ConcentrationRanks {
        NONE(0, (Range<Float>)Range.lessThan((Comparable)Float.valueOf(1.0f))),
        D(1, (Range<Float>)Range.closedOpen((Comparable)Float.valueOf(1.0f), (Comparable)Float.valueOf(2.0f))),
        C(2, (Range<Float>)Range.closedOpen((Comparable)Float.valueOf(2.0f), (Comparable)Float.valueOf(3.0f))),
        B(3, (Range<Float>)Range.closedOpen((Comparable)Float.valueOf(3.0f), (Comparable)Float.valueOf(4.0f))),
        A(4, (Range<Float>)Range.closedOpen((Comparable)Float.valueOf(4.0f), (Comparable)Float.valueOf(5.0f))),
        S(5, (Range<Float>)Range.closedOpen((Comparable)Float.valueOf(5.0f), (Comparable)Float.valueOf(5.25f))),
        SS(6, (Range<Float>)Range.closedOpen((Comparable)Float.valueOf(5.25f), (Comparable)Float.valueOf(5.5f))),
        SSS(7, (Range<Float>)Range.atLeast((Comparable)Float.valueOf(5.5f)));

        public static float MAX_LEVEL;
        final Range<Float> pointRange;
        public final int level;
        private static RangeMap<Float, ConcentrationRanks> concentrationRanksMap;

        private ConcentrationRanks(int level, Range<Float> pointRange) {
            this.pointRange = pointRange;
            this.level = level;
        }

        public static ConcentrationRanks getRankFromLevel(float point) {
            return (ConcentrationRanks)((Object)concentrationRanksMap.get((Comparable)Float.valueOf(point)));
        }

        static {
            MAX_LEVEL = 6.0f;
            concentrationRanksMap = ImmutableRangeMap.builder().put(ConcentrationRanks.NONE.pointRange, (Object)NONE).put(ConcentrationRanks.D.pointRange, (Object)D).put(ConcentrationRanks.C.pointRange, (Object)C).put(ConcentrationRanks.B.pointRange, (Object)B).put(ConcentrationRanks.A.pointRange, (Object)A).put(ConcentrationRanks.S.pointRange, (Object)S).put(ConcentrationRanks.SS.pointRange, (Object)SS).put(ConcentrationRanks.SSS.pointRange, (Object)SSS).build();
        }
    }
}

