/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.compat.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import mods.flammpfeil.slashblade.compat.emi.EMICompat;
import mods.flammpfeil.slashblade.compat.emi.EMISimpleRecipe;
import mods.flammpfeil.slashblade.recipe.SlashBladeSmithingRecipe;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_310;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_7225;
import net.minecraft.class_9697;

public class SlashBladeSmithingEmiRecipe
extends EMISimpleRecipe {
    private final SlashBladeSmithingRecipe recipe;

    public SlashBladeSmithingEmiRecipe(SlashBladeSmithingRecipe recipe) {
        super(SlashBladeSmithingEmiRecipe.createInputs(recipe), SlashBladeSmithingEmiRecipe.createOutputs(recipe), recipe.outputBlade());
        this.recipe = recipe;
    }

    private static List<EmiIngredient> createInputs(SlashBladeSmithingRecipe recipe) {
        ArrayList<EmiIngredient> inputs = new ArrayList<EmiIngredient>();
        inputs.add(EmiIngredient.of((class_1856)recipe.template()));
        inputs.add(EmiIngredient.of((class_1856)recipe.base()));
        inputs.add(EmiIngredient.of((class_1856)recipe.addition()));
        return inputs;
    }

    private static List<EmiStack> createOutputs(SlashBladeSmithingRecipe recipe) {
        ArrayList<EmiStack> outputs = new ArrayList<EmiStack>();
        class_1799[] additions = recipe.addition().method_8105();
        if (additions.length == 0) {
            return outputs;
        }
        class_1799 addition = additions[0];
        for (class_1799 template : recipe.template().method_8105()) {
            for (class_1799 base : recipe.base().method_8105()) {
                class_9697 input = SlashBladeSmithingEmiRecipe.createInput(template, base, addition);
                class_1799 output = SlashBladeSmithingEmiRecipe.assembleResultItem(input, recipe);
                if (output.method_7960()) continue;
                outputs.add(EmiStack.of((class_1799)output));
            }
        }
        return outputs;
    }

    private static class_9697 createInput(class_1799 template, class_1799 base, class_1799 addition) {
        return new class_9697(template, base, addition);
    }

    private static class_1799 assembleResultItem(class_9697 input, SlashBladeSmithingRecipe recipe) {
        class_310 minecraft = class_310.method_1551();
        class_638 level = minecraft.field_1687;
        if (level == null) {
            throw new NullPointerException("level must not be null.");
        }
        class_5455 registryAccess = level.method_30349();
        return recipe.assemble(input, (class_7225.class_7874)registryAccess);
    }

    public EmiRecipeCategory getCategory() {
        return EMICompat.SLASHBLADE_SMITHING_CATEGORY;
    }

    public int getDisplayWidth() {
        return 112;
    }

    public int getDisplayHeight() {
        return 18;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 62, 1);
        widgets.addSlot((EmiIngredient)this.inputs.get(0), 0, 0);
        widgets.addSlot((EmiIngredient)this.inputs.get(1), 18, 0);
        widgets.addSlot((EmiIngredient)this.inputs.get(2), 36, 0);
        widgets.addSlot((EmiIngredient)this.outputs.get(0), 94, 0).recipeContext((EmiRecipe)this);
    }

    public SlashBladeSmithingRecipe getRecipe() {
        return this.recipe;
    }
}

