/*
 * Decompiled with CFR 0.152.
 */
package com.vltno.timeloop;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.vltno.timeloop.LoopTypes;
import com.vltno.timeloop.TimeLoop;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Commands {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"LoopCommands");
    private final TimeLoop mod;

    public Commands(TimeLoop mod) {
        this.mod = mod;
    }

    public void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"loop").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"start").requires(source -> source.method_9259(2))).executes(context -> {
            if (!this.mod.isLooping) {
                this.mod.config.startTimeOfDay = this.mod.startTimeOfDay = this.mod.serverWorld.method_8532();
                this.mod.startLoop();
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Loop started!"));
                LOGGER.info("loop started");
                return 1;
            }
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Loop already running!"));
            return 0;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"stop").requires(source -> source.method_9259(2))).executes(context -> {
            if (this.mod.isLooping) {
                this.mod.stopLoop();
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Loop stopped"));
                LOGGER.info("Loop stopped");
                return 1;
            }
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Loop not running"));
            return 0;
        }))).then(class_2170.method_9247((String)"status").executes(context -> {
            String extras = " Looping on " + String.valueOf((Object)this.mod.loopType) + "." + (String)(this.mod.isLooping && this.mod.loopType == LoopTypes.TICKS ? " Ticks Left: " + this.mod.ticksLeft : "") + (this.mod.trackItems ? " Tracking items." : "");
            String status = this.mod.isLooping ? "Loop is active. Current iteration: " + this.mod.loopIteration + extras : "Loop is inactive. Last iteration: " + this.mod.loopIteration + extras;
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)status));
            LOGGER.info("Status requested: {}", (Object)status);
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"settings").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"setLoopType").requires(source -> source.method_9259(2))).executes(context -> {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Loop type is set to: " + String.valueOf((Object)this.mod.loopType))));
            return 1;
        })).then(class_2170.method_9244((String)"loopType", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9253((String[])new String[]{"TICKS", "TIME_OF_DAY", "SLEEP", "DEATH"}, (SuggestionsBuilder)builder)).executes(context -> {
            LoopTypes newLoopType;
            this.mod.loopType = newLoopType = LoopTypes.valueOf(StringArgumentType.getString((CommandContext)context, (String)"loopType"));
            this.mod.config.loopType = newLoopType;
            this.mod.config.save();
            if (this.mod.showLoopInfo) {
                this.mod.loopBossBar.visible(newLoopType.equals((Object)LoopTypes.TICKS) || newLoopType.equals((Object)LoopTypes.TIME_OF_DAY));
            }
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Looping type is set to: " + String.valueOf((Object)newLoopType))));
            LOGGER.info("Loop type set to {}", (Object)newLoopType);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"setLength").requires(source -> source.method_9259(2))).executes(context -> {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Loop length is set to: " + this.mod.loopLengthTicks + " ticks")));
            return 1;
        })).then(class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)20)).executes(context -> {
            int newTicks;
            this.mod.loopLengthTicks = newTicks = IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks");
            this.mod.config.loopLengthTicks = newTicks;
            this.mod.ticksLeft = newTicks;
            this.mod.config.ticksLeft = newTicks;
            this.mod.config.save();
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Loop length is set to: " + newTicks + " ticks")));
            LOGGER.info("Loop length set to {} ticks", (Object)newTicks);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"maxLoops").requires(source -> source.method_9259(2))).executes(context -> {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Max loops is set to: " + this.mod.maxLoops)));
            return 1;
        })).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            int maxLoops;
            this.mod.maxLoops = maxLoops = IntegerArgumentType.getInteger((CommandContext)context, (String)"value");
            this.mod.config.maxLoops = maxLoops;
            this.mod.config.save();
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Max loops is set to: " + maxLoops)));
            LOGGER.info("Max loops set to {}", (Object)maxLoops);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"setTimeOfDay").requires(source -> source.method_9259(2))).executes(context -> {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Time of day is set to: " + this.mod.timeSetting)));
            return 1;
        })).then(class_2170.method_9244((String)"time", (ArgumentType)IntegerArgumentType.integer((int)0, (int)24000)).executes(context -> {
            int newTime = IntegerArgumentType.getInteger((CommandContext)context, (String)"time");
            this.mod.timeSetting = newTime;
            this.mod.config.timeSetting = newTime;
            this.mod.config.save();
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Time of day is set to: " + newTime)));
            LOGGER.info("Time of day set to {}", (Object)newTime);
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"modifyPlayer").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"targetPlayer", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"newName", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"newSkin", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String targetPlayer = StringArgumentType.getString((CommandContext)context, (String)"targetPlayer");
            String newName = StringArgumentType.getString((CommandContext)context, (String)"newName");
            String newSkin = StringArgumentType.getString((CommandContext)context, (String)"newSkin");
            this.mod.modifyPlayerAttributes(targetPlayer, newName, newSkin);
            return 1;
        })))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"toggles").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"trackTimeOfDay").requires(source -> source.method_9259(2))).executes(context -> {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Track time of day is set to: " + this.mod.trackTimeOfDay)));
            return 1;
        })).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean newTrackTimeOfDay;
            this.mod.trackTimeOfDay = newTrackTimeOfDay = BoolArgumentType.getBool((CommandContext)context, (String)"value");
            this.mod.config.trackTimeOfDay = newTrackTimeOfDay;
            this.mod.config.save();
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Track time of day is set to: " + newTrackTimeOfDay)));
            LOGGER.info("Track time of day set to {}", (Object)newTrackTimeOfDay);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"trackItems").requires(source -> source.method_9259(2))).executes(context -> {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Track items is set to: " + this.mod.trackItems)));
            return 1;
        })).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean newTrackItems;
            this.mod.trackItems = newTrackItems = BoolArgumentType.getBool((CommandContext)context, (String)"value");
            this.mod.config.trackItems = newTrackItems;
            this.mod.config.save();
            this.mod.updateEntitiesToTrack(newTrackItems);
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Track items is set to: " + newTrackItems)));
            LOGGER.info("Track items set to {}", (Object)newTrackItems);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"displayTimeInTicks").requires(source -> source.method_9259(2))).executes(context -> {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Display time in ticks is set to: " + this.mod.displayTimeInTicks)));
            return 1;
        })).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean newDisplayTimeInTicks;
            this.mod.displayTimeInTicks = newDisplayTimeInTicks = BoolArgumentType.getBool((CommandContext)context, (String)"value");
            this.mod.config.displayTimeInTicks = newDisplayTimeInTicks;
            this.mod.config.save();
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Display time in ticks is set to: " + newDisplayTimeInTicks)));
            LOGGER.info("Display time in ticks set to {}", (Object)newDisplayTimeInTicks);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"showLoopInfo").requires(source -> source.method_9259(2))).executes(context -> {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Show loop info is set to: " + this.mod.showLoopInfo)));
            return 1;
        })).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean newShowLoopInfo;
            this.mod.showLoopInfo = newShowLoopInfo = BoolArgumentType.getBool((CommandContext)context, (String)"value");
            this.mod.config.showLoopInfo = newShowLoopInfo;
            this.mod.config.save();
            if (newShowLoopInfo) {
                this.mod.loopBossBar.visible(this.mod.loopType.equals((Object)LoopTypes.TICKS) || this.mod.loopType.equals((Object)LoopTypes.TIME_OF_DAY));
            }
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Showing loop info is set to: " + newShowLoopInfo)));
            LOGGER.info("Show loop info set to {}", (Object)newShowLoopInfo);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"trackChat").requires(source -> source.method_9259(2))).executes(context -> {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Tracking chat is set to: " + this.mod.trackChat)));
            return 1;
        })).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean newTrackChat;
            this.mod.trackChat = newTrackChat = BoolArgumentType.getBool((CommandContext)context, (String)"value");
            this.mod.config.trackChat = newTrackChat;
            this.mod.config.save();
            this.mod.executeCommand("mocap settings recording chat_recording " + newTrackChat);
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Tracking chat is set to: " + newTrackChat)));
            LOGGER.info("Tracking chat set to {}", (Object)newTrackChat);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"hurtLoopedPlayers").requires(source -> source.method_9259(2))).executes(context -> {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Hurting looped players is set to: " + this.mod.hurtLoopedPlayers)));
            return 1;
        })).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean newHurtLoopedPlayers;
            this.mod.hurtLoopedPlayers = newHurtLoopedPlayers = BoolArgumentType.getBool((CommandContext)context, (String)"value");
            this.mod.config.hurtLoopedPlayers = newHurtLoopedPlayers;
            this.mod.config.save();
            this.mod.executeCommand("mocap settings playback invulnerable_playback " + !newHurtLoopedPlayers);
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Hurting looped players is set to: " + newHurtLoopedPlayers)));
            LOGGER.info("Hurting looped players set to {}", (Object)newHurtLoopedPlayers);
            return 1;
        }))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").requires(source -> source.method_9259(2))).executes(context -> {
            this.mod.stopLoop();
            this.mod.startTimeOfDay = 0L;
            this.mod.config.startTimeOfDay = 0L;
            this.mod.timeSetting = 13000L;
            this.mod.config.timeSetting = 0L;
            this.mod.ticksLeft = this.mod.loopLengthTicks;
            this.mod.config.ticksLeft = this.mod.config.loopLengthTicks;
            this.mod.trackItems = false;
            this.mod.config.trackItems = false;
            this.mod.loopType = LoopTypes.TICKS;
            this.mod.config.loopType = LoopTypes.TICKS;
            this.mod.displayTimeInTicks = false;
            this.mod.config.displayTimeInTicks = false;
            this.mod.executeCommand("mocap playback stop_all");
            this.mod.loopSceneManager.forEachPlayerSceneName(playerSceneName -> {
                this.mod.executeCommand(String.format("mocap scenes remove %s", playerSceneName));
                this.mod.executeCommand(String.format("mocap scenes add %s", playerSceneName));
            });
            this.mod.loopIteration = 0;
            this.mod.config.loopIteration = 0;
            this.mod.config.save();
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Loop reset!"));
            return 1;
        }))));
    }
}

