/*
 * Decompiled with CFR 0.152.
 */
package com.vltno.timeloop;

import com.vltno.timeloop.PlayerData;
import com.vltno.timeloop.TimeLoopConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class LoopSceneManager {
    private TimeLoopConfig config;
    private String scenePrefix;
    private Map<String, PlayerData> recordingPlayers;

    public LoopSceneManager(TimeLoopConfig config) {
        this.config = config;
        this.scenePrefix = config.scenePrefix;
        this.recordingPlayers = new HashMap<String, PlayerData>();
    }

    public void addPlayer(List<String> args) {
        List<String> skin;
        String playerName = args.get(0);
        List<String> nickname = args.size() > 1 ? args.subList(1, args.size()) : null;
        List<String> list = skin = args.size() > 2 ? args.subList(2, args.size()) : null;
        if (playerName != null && !playerName.isEmpty()) {
            String tempNickname = nickname == null || nickname.isEmpty() ? playerName : nickname.getFirst();
            String tempSkin = skin == null || skin.isEmpty() ? playerName : skin.getFirst();
            this.recordingPlayers.put(playerName, new PlayerData(playerName, tempNickname, tempSkin));
        } else {
            System.out.println("Invalid player data. Player not added.");
        }
    }

    public void removePlayer(String playerName) {
        if (playerName != null && !playerName.isEmpty()) {
            PlayerData removed = this.recordingPlayers.remove(playerName);
            if (removed != null) {
                System.out.println("Player '" + playerName + "' removed successfully.");
            } else {
                System.out.println("Player '" + playerName + "' not found in the list.");
            }
        } else {
            System.out.println("Invalid player name. Player not removed.");
        }
    }

    public String getPlayerSceneName(String playerName) {
        return playerName.startsWith(this.scenePrefix) ? playerName : (this.scenePrefix + "_" + playerName).toLowerCase();
    }

    public List<String> getAllPlayerSceneNames() {
        ArrayList<String> playerSceneNames = new ArrayList<String>();
        for (PlayerData player : this.recordingPlayers.values()) {
            playerSceneNames.add(this.getPlayerSceneName(player.getName()));
        }
        return playerSceneNames;
    }

    public void forEachPlayerSceneName(Consumer<String> action) {
        this.getAllPlayerSceneNames().forEach(action);
    }

    public void forEachRecordingPlayer(Consumer<PlayerData> action) {
        this.recordingPlayers.values().forEach(action);
    }

    public void setRecordingPlayers(Map<String, PlayerData> recordingPlayers) {
        this.recordingPlayers = recordingPlayers;
    }

    public void saveRecordingPlayers() {
        this.config.recordingPlayers = new HashMap<String, PlayerData>(this.recordingPlayers);
    }
}

