/*
 * Decompiled with CFR 0.152.
 */
package com.vltno.timeloop;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.CommandDispatcher;
import com.vltno.timeloop.Commands;
import com.vltno.timeloop.LoopBossBar;
import com.vltno.timeloop.LoopSceneManager;
import com.vltno.timeloop.LoopTypes;
import com.vltno.timeloop.TimeLoopConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeLoop
implements ModInitializer {
    public static final Logger LOOP_LOGGER = LoggerFactory.getLogger((String)"TimeLoop");
    private Commands commands;
    private static MinecraftServer server;
    public class_3218 serverWorld;
    public LoopBossBar loopBossBar;
    public int loopIteration;
    public int loopLengthTicks;
    public long startTimeOfDay;
    public long timeSetting;
    public boolean trackTimeOfDay;
    public boolean isLooping;
    public int maxLoops;
    private int tickCounter = 0;
    public int ticksLeft;
    public boolean showLoopInfo;
    public boolean displayTimeInTicks;
    public boolean trackItems;
    public LoopTypes loopType;
    public boolean trackChat;
    public boolean hurtLoopedPlayers;
    public TimeLoopConfig config;
    public LoopSceneManager loopSceneManager;
    private Path worldFolder;

    public void onInitialize() {
        LOOP_LOGGER.info("Initializing TimeLoop mod");
        this.commands = new Commands(this);
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            if (environment.field_25423 || environment.field_25422) {
                this.commands.register((CommandDispatcher<class_2168>)dispatcher);
            }
        });
        this.loopBossBar = new LoopBossBar();
        EntitySleepEvents.STOP_SLEEPING.register((entity, sleepingPos) -> {
            if (entity.method_31747() && this.loopType == LoopTypes.SLEEP) {
                LOOP_LOGGER.info("Player slept, looping.");
                this.runLoopIteration();
            }
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            this.worldFolder = server.method_27050(class_5218.field_24188);
            this.config = TimeLoopConfig.load(this.worldFolder);
            this.loopSceneManager = new LoopSceneManager(this.config);
            this.loopIteration = this.config.loopIteration;
            this.loopLengthTicks = this.config.loopLengthTicks;
            this.isLooping = this.config.isLooping;
            this.startTimeOfDay = this.config.startTimeOfDay;
            this.timeSetting = this.config.timeSetting;
            this.trackTimeOfDay = this.config.trackTimeOfDay;
            this.ticksLeft = this.config.ticksLeft;
            this.showLoopInfo = this.config.showLoopInfo;
            this.displayTimeInTicks = this.config.displayTimeInTicks;
            this.trackItems = this.config.trackItems;
            this.loopType = this.config.loopType;
            this.trackChat = this.config.trackChat;
            this.hurtLoopedPlayers = this.config.hurtLoopedPlayers;
            this.loopSceneManager.setRecordingPlayers(this.config.recordingPlayers);
            TimeLoop.server = server;
            this.serverWorld = server.method_30002();
            this.loopBossBar.visible(false);
            this.executeCommand("mocap settings advanced experimental_release_warning false");
            this.executeCommand("mocap settings playback start_as_recorded true");
            this.executeCommand("mocap settings recording assign_player_name true");
            this.executeCommand("mocap settings recording start_instantly true");
            this.executeCommand("mocap settings recording on_death continue_synced");
            this.executeCommand("mocap settings recording chat_recording " + this.trackChat);
            this.executeCommand("mocap settings playback invulnerable_playback " + !this.hurtLoopedPlayers);
            this.executeCommand("mocap settings recording entity_tracking_distance 1");
            this.updateEntitiesToTrack(this.trackItems);
            try {
                this.loopSceneManager.forEachPlayerSceneName(playerSceneName -> this.executeCommand(String.format("mocap scenes add %s", playerSceneName)));
            }
            catch (Error e) {
                LOOP_LOGGER.error("Failed to add player scenes to mocap scenes: {}", (Object)e.getMessage());
            }
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            if (this.isLooping) {
                this.stopLoop();
                this.config.isLooping = true;
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            String playerName = player.method_5477().getString();
            this.loopSceneManager.addPlayer(Arrays.asList(playerName));
            this.loopBossBar.addPlayer(player);
            this.executeCommand(String.format("mocap scenes add %s", this.loopSceneManager.getPlayerSceneName(playerName)));
            if (this.config.firstStart) {
                this.config.firstStart = false;
                this.config.save();
                LOOP_LOGGER.info("First start detected, sending message to ops.");
                if (server.method_3760().method_14569(player.method_7334())) {
                    player.method_64398((class_2561)class_2561.method_43470((String)"Use '/loop start' to start the time loop!"));
                }
            }
            if (this.isLooping) {
                LOOP_LOGGER.info("Starting recording for newly joined player: {}", (Object)playerName);
                this.executeCommand(String.format("mocap recording start %s", playerName));
                if (this.showLoopInfo) {
                    this.loopBossBar.visible(this.loopType.equals((Object)LoopTypes.TICKS) || this.loopType.equals((Object)LoopTypes.TIME_OF_DAY));
                }
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            class_3222 player = handler.method_32311();
            String playerName = player.method_5477().getString();
            this.loopSceneManager.removePlayer(playerName);
            this.loopBossBar.removePlayer(player);
            if (this.isLooping) {
                this.saveRecordings();
                this.loopSceneManager.saveRecordingPlayers();
            }
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            if (this.loopType != LoopTypes.DEATH) {
                return;
            }
            this.runLoopIteration();
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (this.loopType == LoopTypes.SLEEP || this.loopType == LoopTypes.DEATH) {
                return;
            }
            if (this.isLooping) {
                if (this.loopType == LoopTypes.TIME_OF_DAY) {
                    if (this.timeSetting <= this.startTimeOfDay) {
                        this.startTimeOfDay = 0L;
                        this.config.startTimeOfDay = 0L;
                    }
                    long time = this.serverWorld.method_8532() > 24000L ? this.serverWorld.method_8532() % 24000L : this.serverWorld.method_8532();
                    long timeLeft = time > this.timeSetting ? Math.abs(this.serverWorld.method_8532() - 2L * this.timeSetting) : Math.abs(time - this.timeSetting);
                    this.updateInfoBar((int)this.timeSetting, (int)timeLeft);
                    if (Math.abs(this.timeSetting - timeLeft) >= this.timeSetting) {
                        this.runLoopIteration();
                    }
                } else if (this.loopType == LoopTypes.TICKS) {
                    ++this.tickCounter;
                    this.ticksLeft = this.loopLengthTicks - this.tickCounter;
                    this.updateInfoBar(this.loopLengthTicks, this.ticksLeft);
                    if (this.tickCounter >= this.loopLengthTicks) {
                        this.tickCounter = 0;
                        this.ticksLeft = this.loopLengthTicks;
                        this.runLoopIteration();
                    }
                }
            }
        });
        LOOP_LOGGER.info("TimeLoop mod initialized successfully");
    }

    public void startLoop() {
        if (this.isLooping) {
            LOOP_LOGGER.info("Attempted to start already running recording loop");
            return;
        }
        if (this.showLoopInfo) {
            this.loopBossBar.visible(this.loopType.equals((Object)LoopTypes.TICKS) || this.loopType.equals((Object)LoopTypes.TIME_OF_DAY));
        }
        this.isLooping = true;
        this.config.isLooping = true;
        this.tickCounter = 0;
        this.ticksLeft = this.loopLengthTicks;
        LOOP_LOGGER.info("Starting Loop");
        this.startRecordings();
    }

    private void runLoopIteration() {
        LOOP_LOGGER.info("Starting iteration {} of loop", (Object)this.loopIteration);
        this.saveRecordings();
        this.removeOldSceneEntries();
        this.startRecordings();
        if (this.trackTimeOfDay) {
            this.serverWorld.method_29199(this.startTimeOfDay);
        }
        this.executeCommand("mocap playback stop_all including_others");
        this.loopSceneManager.forEachRecordingPlayer(playerData -> {
            String playerName = playerData.getName();
            String playerNickname = playerData.getNickname();
            String playerSkin = playerData.getSkin();
            String playerSceneName = this.loopSceneManager.getPlayerSceneName(playerName);
            this.executeCommand(String.format("mocap playback start .%s %s skin_from_player %s", playerSceneName, playerNickname, playerSkin));
        });
        ++this.loopIteration;
        this.config.loopIteration = this.loopIteration;
        this.config.save();
        LOOP_LOGGER.info("Completed loop iteration {}", (Object)(this.loopIteration - 1));
    }

    private void startRecordings() {
        this.loopSceneManager.forEachRecordingPlayer(playerData -> {
            String playerName = playerData.getName();
            this.executeCommand(String.format("mocap recording start %s", playerName));
        });
    }

    public void saveRecordings() {
        this.loopSceneManager.forEachRecordingPlayer(playerData -> {
            String playerName = playerData.getName();
            String recordingName = playerName + "_" + System.currentTimeMillis();
            String playerSceneName = this.loopSceneManager.getPlayerSceneName(playerName);
            LOOP_LOGGER.info("Processing recording for player: {}", (Object)playerName);
            this.executeCommand(String.format("mocap recording stop -+mc.%s.1", playerName));
            this.executeCommand(String.format("mocap recording save %s -+mc.%s.1", recordingName.toLowerCase(), playerName));
            if (this.recordingFileExists(recordingName)) {
                this.executeCommand(String.format("mocap scenes add_to %s %s", playerSceneName, recordingName.toLowerCase()));
            }
        });
    }

    public void stopLoop() {
        if (this.isLooping) {
            LOOP_LOGGER.info("Stopping loop");
            this.isLooping = false;
            this.config.isLooping = false;
            this.loopBossBar.visible(false);
            this.saveRecordings();
            this.loopSceneManager.saveRecordingPlayers();
            this.executeCommand("mocap playback stop_all including_others");
            this.tickCounter = 0;
            this.ticksLeft = this.loopLengthTicks;
            LOOP_LOGGER.info("Loop stopped!");
        }
    }

    public void updateInfoBar(int time, int timeLeft) {
        if (this.showLoopInfo && this.isLooping) {
            if (this.displayTimeInTicks) {
                this.loopBossBar.setBossBarName("Time Left: " + timeLeft);
            } else {
                this.loopBossBar.setBossBarName("Time Left: " + this.convertTicksToTime(timeLeft));
            }
            this.loopBossBar.setBossBarPercentage(time, timeLeft);
        }
    }

    public void executeCommand(String command) {
        if (server != null) {
            LOOP_LOGGER.info("Executing command: {}", (Object)command);
            server.method_3734().method_44252(server.method_3739(), command);
            LOOP_LOGGER.info("Command executed successfully: {}", (Object)command);
        } else {
            LOOP_LOGGER.error("Attempted to execute command while server is null: {}", (Object)command);
        }
    }

    private boolean recordingFileExists(String recordingName) {
        Path recordingDir = this.worldFolder.resolve("mocap_files").resolve("recordings");
        Path recordingFile = recordingDir.resolve(recordingName.toLowerCase() + ".mcmocap_rec");
        boolean exists = recordingFile.toFile().exists();
        if (!exists) {
            LOOP_LOGGER.error("Expected recording file does not exist: {}", (Object)recordingFile.toAbsolutePath());
        }
        return exists;
    }

    private void removeOldSceneEntries() {
        if (this.isLooping && this.maxLoops > 1) {
            Path sceneDir = this.worldFolder.resolve("mocap_files").resolve("scenes");
            ArrayList sceneFiles = new ArrayList();
            this.loopSceneManager.forEachRecordingPlayer(playerData -> {
                String playerSceneName = this.loopSceneManager.getPlayerSceneName(playerData.getName());
                if (playerSceneName != null && !playerSceneName.isBlank()) {
                    sceneFiles.add(sceneDir.resolve(playerSceneName + ".mcmocap_scene"));
                } else {
                    LOOP_LOGGER.warn("Invalid playerSceneName encountered: {}", (Object)playerSceneName);
                }
            });
            if (sceneFiles.isEmpty()) {
                LOOP_LOGGER.warn("No scene files found to process.");
            }
            for (Path sceneFile : sceneFiles) {
                if (sceneFile.toFile().exists()) {
                    try {
                        String jsonContent = new String(Files.readAllBytes(sceneFile));
                        JsonObject jsonObject = JsonParser.parseString((String)jsonContent).getAsJsonObject();
                        JsonArray subScenes = jsonObject.getAsJsonArray("subscenes");
                        if (subScenes.size() <= this.maxLoops) continue;
                        int entriesToRemove = subScenes.size() - this.maxLoops;
                        for (int i = 0; i < entriesToRemove; ++i) {
                            subScenes.remove(0);
                        }
                        jsonObject.add("subScenes", (JsonElement)subScenes);
                        Files.write(sceneFile, jsonObject.toString().getBytes(), new OpenOption[0]);
                        LOOP_LOGGER.info("Removed old scene entries for file: {}", (Object)sceneFile);
                    }
                    catch (IOException e) {
                        LOOP_LOGGER.error("Failed to process scene file: {}", (Object)sceneFile, (Object)e);
                    }
                    continue;
                }
                LOOP_LOGGER.error("Scene file does not exist: {}", (Object)sceneFile);
            }
        }
    }

    public void updateEntitiesToTrack(boolean items) {
        String entitiesToTrack = "@vehicles" + (items ? ";@items" : "");
        this.executeCommand(String.format("mocap settings recording track_entities %s", entitiesToTrack));
        this.executeCommand(String.format("mocap settings playback play_entities %s", entitiesToTrack));
    }

    public String convertTicksToTime(int ticksLeft) {
        int timeLeft = ticksLeft / 20;
        int hours = timeLeft / 3600;
        int minutes = timeLeft % 3600 / 60;
        int seconds = timeLeft % 60;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    public void modifyPlayerAttributes(String targetPlayerName, String newPlayerNickname, String newSkin) {
        String playerSceneName = this.loopSceneManager.getPlayerSceneName(targetPlayerName);
        this.executeCommand(String.format("mocap scenes modify .%s %s player_skin skin_from_player %s", playerSceneName, newPlayerNickname, newSkin));
        this.loopSceneManager.forEachRecordingPlayer(playerData -> {
            if (playerData.getName().equals(targetPlayerName)) {
                playerData.setNickname(newPlayerNickname);
                playerData.setSkin(newSkin);
                LOOP_LOGGER.info("Modified loop attributes for player '{}' -> '{}' with skin '{}'", new Object[]{targetPlayerName, newPlayerNickname, newSkin});
            }
        });
    }
}

