/*
 * Decompiled with CFR 0.152.
 */
package com.vltno.timeloop;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.vltno.timeloop.LoopTypes;
import com.vltno.timeloop.PlayerData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class TimeLoopConfig {
    public String scenePrefix = "loop_scene";
    public boolean firstStart = true;
    public int loopIteration = 1;
    public boolean isLooping = false;
    public int loopLengthTicks = 6000;
    public int maxLoops = 0;
    public long timeSetting = 13000L;
    public long startTimeOfDay = 0L;
    public boolean trackTimeOfDay = true;
    public int ticksLeft;
    public boolean showLoopInfo = true;
    public boolean displayTimeInTicks = false;
    public boolean trackItems = false;
    public LoopTypes loopType = LoopTypes.TICKS;
    public boolean trackChat = false;
    public boolean hurtLoopedPlayers = false;
    public Map<String, PlayerData> recordingPlayers = new HashMap<String, PlayerData>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static Path configPath;

    public static TimeLoopConfig load(Path configDir) {
        configPath = configDir.resolve("timeloop.json");
        TimeLoopConfig config = null;
        if (Files.exists(configPath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(configPath);){
                config = (TimeLoopConfig)GSON.fromJson((Reader)reader, TimeLoopConfig.class);
            }
            catch (Exception e) {
                System.err.println("Failed to load config file: " + e.getMessage());
                e.printStackTrace();
            }
        }
        if (config == null) {
            config = new TimeLoopConfig();
            System.err.println("Config file not found or invalid. Generating a default configuration.");
        }
        if (config.recordingPlayers == null || !(config.recordingPlayers instanceof Map)) {
            System.err.println("Invalid or missing recordingPlayers data in config. Initializing with an empty map.");
            config.recordingPlayers = new HashMap<String, PlayerData>();
        }
        config.save();
        return config;
    }

    public void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

