/*
 * Decompiled with CFR 0.152.
 */
package com.vltno.timeloop.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.vltno.timeloop.LoopCommands;
import com.vltno.timeloop.LoopTypes;
import com.vltno.timeloop.TimeLoop;
import com.vltno.timeloop.TimeLoopConfig;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class BaseCommands {
    public static void register(LiteralArgumentBuilder<CommandSourceStack> parentBuilder) {
        parentBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)"start").executes(BaseCommands::start)).requires(source -> source.hasPermission(2)));
        parentBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)"skip").executes(BaseCommands::skip)).requires(source -> source.hasPermission(2)));
        parentBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)"stop").executes(BaseCommands::stop)).requires(source -> source.hasPermission(2)));
        parentBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)"reset").executes(BaseCommands::reset)).requires(source -> source.hasPermission(2)));
        parentBuilder.then(Commands.literal((String)"status").executes(BaseCommands::status));
    }

    private static int start(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!TimeLoop.isLooping) {
            if (TimeLoop.serverLevel == null) {
                source.sendFailure((Component)Component.literal((String)"Error: Server world not available yet."));
                return 0;
            }
            TimeLoop.config.startTimeOfDay = TimeLoop.startTimeOfDay = TimeLoop.serverLevel.getDayTime();
            TimeLoop.startLoop();
            source.sendSuccess(() -> Component.literal((String)"Loop started!"), true);
            LoopCommands.LOOP_COMMANDS_LOGGER.info("Loop started");
            return 1;
        }
        source.sendFailure((Component)Component.literal((String)"Loop already running!"));
        return 0;
    }

    private static int skip(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (TimeLoop.isLooping) {
            if (TimeLoop.serverLevel == null) {
                source.sendFailure((Component)Component.literal((String)"Error: Server world not available yet."));
                return 0;
            }
            TimeLoop.runLoopIteration();
            source.sendSuccess(() -> Component.literal((String)"Loop skipped!"), true);
            LoopCommands.LOOP_COMMANDS_LOGGER.info("Loop skipped");
            return 1;
        }
        source.sendFailure((Component)Component.literal((String)"Loop not running"));
        return 0;
    }

    private static int stop(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (TimeLoop.isLooping) {
            TimeLoop.stopLoop();
            source.sendSuccess(() -> Component.literal((String)"Loop stopped"), true);
            LoopCommands.LOOP_COMMANDS_LOGGER.info("Loop stopped");
            return 1;
        }
        source.sendFailure((Component)Component.literal((String)"Loop not running"));
        return 0;
    }

    private static int status(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String status = BaseCommands.getString();
        source.sendSuccess(() -> Component.literal((String)status), false);
        LoopCommands.LOOP_COMMANDS_LOGGER.info("Status requested: {}", (Object)status);
        return 1;
    }

    @NotNull
    private static String getString() {
        String loopTypeName = TimeLoop.loopType != null ? TimeLoop.loopType.name() : "UNKNOWN";
        String extras = " Looping on " + loopTypeName + "." + (String)(TimeLoop.isLooping && TimeLoop.loopType == LoopTypes.TICKS ? " Ticks Left: " + TimeLoop.ticksLeft : "") + (TimeLoop.trackItems ? " Tracking items." : "");
        return TimeLoop.isLooping ? "Loop is active. Current iteration: " + TimeLoop.loopIteration + extras : "Loop is inactive. Last iteration: " + TimeLoop.loopIteration + extras;
    }

    private static int reset(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        TimeLoop.stopLoop();
        TimeLoopConfig baseConfig = new TimeLoopConfig();
        TimeLoop.startTimeOfDay = baseConfig.startTimeOfDay;
        TimeLoop.config.startTimeOfDay = baseConfig.startTimeOfDay;
        TimeLoop.timeSetting = baseConfig.timeSetting;
        TimeLoop.config.timeSetting = baseConfig.timeSetting;
        TimeLoop.ticksLeft = TimeLoop.loopLengthTicks;
        TimeLoop.config.ticksLeft = TimeLoop.config.loopLengthTicks;
        TimeLoop.trackItems = baseConfig.trackItems;
        TimeLoop.config.trackItems = baseConfig.trackItems;
        TimeLoop.loopType = baseConfig.loopType;
        TimeLoop.config.loopType = baseConfig.loopType;
        TimeLoop.displayTimeInTicks = baseConfig.displayTimeInTicks;
        TimeLoop.config.displayTimeInTicks = baseConfig.displayTimeInTicks;
        TimeLoop.executeCommand("mocap playback stop_all");
        TimeLoop.loopSceneManager.forEachPlayerSceneName(playerSceneName -> {
            TimeLoop.executeCommand(String.format("mocap scenes remove %s", playerSceneName));
            TimeLoop.executeCommand(String.format("mocap scenes add %s", playerSceneName));
        });
        TimeLoop.loopIteration = 0;
        TimeLoop.config.loopIteration = 0;
        TimeLoop.config.save();
        source.sendSuccess(() -> Component.literal((String)"Loop reset!"), true);
        return 1;
    }
}

