/*
 * Decompiled with CFR 0.152.
 */
package com.vltno.timeloop.neoforge;

import com.mojang.brigadier.CommandDispatcher;
import com.vltno.timeloop.LoopCommands;
import com.vltno.timeloop.TimeLoop;
import com.vltno.timeloop.neoforge.events.EntitySleepNeoForgeEvent;
import com.vltno.timeloop.neoforge.events.LifecycleNeoForgeEvent;
import com.vltno.timeloop.neoforge.events.PlayConnectionNeoForgeEvent;
import com.vltno.timeloop.neoforge.events.PlayerNeoForgeEvent;
import com.vltno.timeloop.neoforge.events.TickNeoForgeEvent;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerWakeUpEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="timeloop")
public class TimeLoopNeoForge {
    public static final Logger LOOP_LOGGER = LoggerFactory.getLogger((String)"TimeLoop");
    public static final boolean isLogicalServer = !FMLEnvironment.dist.isClient();

    public TimeLoopNeoForge(IEventBus modEventBus) {
        LOOP_LOGGER.info("Initializing TimeLoop mod (NeoForge)");
        TimeLoop.init(isLogicalServer);
        NeoForge.EVENT_BUS.register((Object)this);
        LOOP_LOGGER.info("TimeLoop mod initialized successfully (NeoForge)");
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        LOOP_LOGGER.info("Registering TimeLoop commands (NeoForge)");
        LoopCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onEndServerTick(ServerTickEvent.Post event) {
        TickNeoForgeEvent.onEndServerTick(event.getServer());
    }

    @SubscribeEvent
    public void onPlayerWakeUp(PlayerWakeUpEvent event) {
        EntitySleepNeoForgeEvent.onStopSleeping((LivingEntity)event.getEntity());
    }

    @SubscribeEvent
    public void onServerStart(ServerStartedEvent event) {
        LifecycleNeoForgeEvent.onServerStart(event.getServer());
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        LifecycleNeoForgeEvent.onServerStopping(event.getServer());
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ServerGamePacketListenerImpl connection = player2.connection;
            MinecraftServer server = player2.server;
            PlayConnectionNeoForgeEvent.onJoin(connection, server);
        } else {
            LOOP_LOGGER.warn("PlayerLoggedInEvent received a non-ServerPlayer entity?");
        }
    }

    @SubscribeEvent
    public void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ServerGamePacketListenerImpl connection = player2.connection;
            PlayConnectionNeoForgeEvent.onDisconnect(connection);
        } else {
            LOOP_LOGGER.warn("PlayerLoggedOutEvent received a non-ServerPlayer entity?");
        }
    }

    @SubscribeEvent
    public void afterRespawn(PlayerEvent.PlayerRespawnEvent event) {
        PlayerNeoForgeEvent.afterRespawn();
    }
}

