/*
 * Decompiled with CFR 0.152.
 */
package com.vltno.timeloop;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.vltno.timeloop.PlayerData;
import com.vltno.timeloop.TimeLoop;
import com.vltno.timeloop.TimeLoopConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2522;

public class LoopSceneManager {
    private final TimeLoopConfig config;
    private final String scenePrefix;
    private Map<String, PlayerData> recordingPlayers;

    public LoopSceneManager(TimeLoopConfig config) {
        this.config = config;
        this.scenePrefix = config.scenePrefix;
        this.recordingPlayers = new HashMap<String, PlayerData>();
    }

    public void addPlayer(List<String> args) {
        class_2487 inventoryTag;
        String tempInventoryTag;
        String playerName = args.get(0);
        String tempNickname = args.size() > 1 ? args.get(1) : null;
        String tempSkin = args.size() > 2 ? args.get(2) : null;
        String tempRewindPosition = args.size() > 3 ? args.get(3) : null;
        String string = tempInventoryTag = args.size() > 4 ? args.get(4) : "";
        if (playerName == null || playerName.isEmpty()) {
            TimeLoop.LOOP_LOGGER.error("Player name is null or empty. Skipping player addition.");
            return;
        }
        String nickname = tempNickname == null || tempNickname.isEmpty() ? playerName : tempNickname;
        String skin = tempSkin == null || tempSkin.isEmpty() ? playerName : tempSkin;
        try {
            class_2487 compoundTag;
            class_2487 tag = class_2522.method_10718((String)tempInventoryTag);
            inventoryTag = tag instanceof class_2487 ? (compoundTag = tag) : new class_2487();
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
        class_243 rewindPosition = class_243.field_1353;
        if (tempRewindPosition != null && !tempRewindPosition.isEmpty()) {
            try {
                String[] positionParts;
                String processedString = tempRewindPosition.trim();
                if (processedString.startsWith("(") && processedString.endsWith(")") || processedString.startsWith("[") && processedString.endsWith("]")) {
                    processedString = processedString.substring(1, processedString.length() - 1).trim();
                }
                if ((positionParts = processedString.split("\\s*,\\s*")).length == 3) {
                    double x = Double.parseDouble(positionParts[0]);
                    double y = Double.parseDouble(positionParts[1]);
                    double z = Double.parseDouble(positionParts[2]);
                    rewindPosition = new class_243(x, y, z);
                }
            }
            catch (NumberFormatException e) {
                TimeLoop.LOOP_LOGGER.error("Invalid rewind position format. Skipping rewind position.");
            }
        }
        PlayerData playerData = new PlayerData(playerName, nickname, skin, rewindPosition, inventoryTag);
        this.recordingPlayers.put(playerName, playerData);
    }

    public void removePlayer(String playerName) {
        if (playerName != null && !playerName.isEmpty()) {
            PlayerData removed = this.recordingPlayers.remove(playerName);
            if (removed != null) {
                TimeLoop.LOOP_LOGGER.info("Player '" + playerName + "' removed successfully.");
            } else {
                TimeLoop.LOOP_LOGGER.info("Player '" + playerName + "' not found in the list.");
            }
        } else {
            TimeLoop.LOOP_LOGGER.info("Invalid player name. Player not removed.");
        }
    }

    public String getPlayerSceneName(String playerName) {
        return playerName.startsWith(this.scenePrefix) ? playerName : (this.scenePrefix + "_" + playerName).toLowerCase();
    }

    public List<String> getAllPlayerSceneNames() {
        ArrayList<String> playerSceneNames = new ArrayList<String>();
        for (PlayerData player : this.recordingPlayers.values()) {
            playerSceneNames.add(this.getPlayerSceneName(player.getName()));
        }
        return playerSceneNames;
    }

    public void forEachPlayerSceneName(Consumer<String> action) {
        this.getAllPlayerSceneNames().forEach(action);
    }

    public void forEachRecordingPlayer(Consumer<PlayerData> action) {
        this.recordingPlayers.values().forEach(action);
    }

    public void setRecordingPlayers(Map<String, PlayerData> recordingPlayers) {
        this.recordingPlayers = recordingPlayers;
    }

    public void saveRecordingPlayers() {
        this.config.recordingPlayers = new HashMap<String, PlayerData>(this.recordingPlayers);
    }

    public PlayerData getRecordingPlayer(String playerName) {
        return this.recordingPlayers.get(playerName);
    }
}

