/*
 * Decompiled with CFR 0.152.
 */
package com.vltno.timeloop.fabric;

import com.mojang.brigadier.CommandDispatcher;
import com.vltno.timeloop.LoopCommands;
import com.vltno.timeloop.TimeLoop;
import com.vltno.timeloop.fabric.events.EntitySleepFabricEvent;
import com.vltno.timeloop.fabric.events.LifecycleFabricEvent;
import com.vltno.timeloop.fabric.events.PlayConnectionFabricEvent;
import com.vltno.timeloop.fabric.events.PlayerFabricEvent;
import com.vltno.timeloop.fabric.events.TickFabricEvent;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeLoopFabric
implements ModInitializer {
    public static final Logger LOOP_LOGGER = LoggerFactory.getLogger((String)"TimeLoop");
    public static final boolean isDedicatedServer = FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER;

    public void onInitialize() {
        LOOP_LOGGER.info("Initializing TimeLoop mod (Fabric)");
        TimeLoop.init(isDedicatedServer);
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            if (environment.field_25423 || environment.field_25422) {
                LoopCommands.register((CommandDispatcher<class_2168>)dispatcher);
            }
        });
        EntitySleepEvents.STOP_SLEEPING.register(EntitySleepFabricEvent::onStopSleeping);
        ServerLifecycleEvents.SERVER_STARTED.register(LifecycleFabricEvent::onServerStart);
        ServerLifecycleEvents.SERVER_STOPPING.register(LifecycleFabricEvent::onServerStopping);
        ServerPlayConnectionEvents.JOIN.register(PlayConnectionFabricEvent::onJoin);
        ServerPlayConnectionEvents.DISCONNECT.register(PlayConnectionFabricEvent::onDisconnect);
        ServerPlayerEvents.AFTER_RESPAWN.register(PlayerFabricEvent::afterRespawn);
        ServerTickEvents.END_SERVER_TICK.register(TickFabricEvent::onEndServerTick);
        LOOP_LOGGER.info("TimeLoop mod initialized successfully (Fabric)");
    }
}

